/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra.ssa;

import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanEliminateSpillMovePhase;

public class SSALinearScanEliminateSpillMovePhase
extends LinearScanEliminateSpillMovePhase {
    SSALinearScanEliminateSpillMovePhase(LinearScan allocator) {
        super(allocator);
    }

    @Override
    protected int firstInstructionOfInterest() {
        return 0;
    }

    @Override
    protected boolean canEliminateSpillMove(BasicBlock<?> block, StandardOp.MoveOp move) {
        if (super.canEliminateSpillMove(block, move)) {
            Interval curInterval = this.allocator.intervalFor((Value)move.getResult());
            assert (!ValueUtil.isRegister((Value)curInterval.location()) && curInterval.alwaysInMemory());
            if (!this.isPhiResolutionMove(block, move, curInterval)) {
                assert (LIRValueUtil.isStackSlotValue((Value)curInterval.location())) : "Not a stack slot: " + curInterval.location();
                return true;
            }
        }
        return false;
    }

    private boolean isPhiResolutionMove(BasicBlock<?> block, StandardOp.MoveOp move, Interval toInterval) {
        if (!toInterval.isSplitParent()) {
            return false;
        }
        if ((toInterval.from() & 1) == 1) {
            return false;
        }
        if (block.getSuccessorCount() != 1) {
            return false;
        }
        LIRInstruction op = this.allocator.instructionForId(toInterval.from());
        if (!(op instanceof StandardOp.LabelOp)) {
            return false;
        }
        BasicBlock<?> intStartBlock = this.allocator.blockForId(toInterval.from());
        assert (this.allocator.getLIR().getLIRforBlock(intStartBlock).get(0).equals(op));
        if (!block.getSuccessorAt(0).equals(intStartBlock)) {
            return false;
        }
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.indent();){
            debug.log("Is a move (%s) to phi interval %s", (Object)move, (Object)toInterval);
        }
        return true;
    }
}

