/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra.ssa;

import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanEliminateSpillMovePhase;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanLifetimeAnalysisPhase;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanResolveDataFlowPhase;
import org.graalvm.compiler.lir.alloc.lsra.MoveResolver;
import org.graalvm.compiler.lir.alloc.lsra.ssa.SSALinearScanEliminateSpillMovePhase;
import org.graalvm.compiler.lir.alloc.lsra.ssa.SSALinearScanLifetimeAnalysisPhase;
import org.graalvm.compiler.lir.alloc.lsra.ssa.SSALinearScanResolveDataFlowPhase;
import org.graalvm.compiler.lir.alloc.lsra.ssa.SSAMoveResolver;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.MoveFactory;
import org.graalvm.compiler.lir.ssa.SSAUtil;

public final class SSALinearScan
extends LinearScan {
    public SSALinearScan(TargetDescription target, LIRGenerationResult res, MoveFactory spillMoveFactory, RegisterAllocationConfig regAllocConfig, int[] sortedBlocks, boolean neverSpillConstants) {
        super(target, res, spillMoveFactory, regAllocConfig, sortedBlocks, neverSpillConstants);
    }

    @Override
    protected MoveResolver createMoveResolver() {
        SSAMoveResolver moveResolver = new SSAMoveResolver(this);
        assert (moveResolver.checkEmpty());
        return moveResolver;
    }

    @Override
    protected LinearScanLifetimeAnalysisPhase createLifetimeAnalysisPhase() {
        return new SSALinearScanLifetimeAnalysisPhase(this);
    }

    @Override
    protected LinearScanResolveDataFlowPhase createResolveDataFlowPhase() {
        return new SSALinearScanResolveDataFlowPhase(this);
    }

    @Override
    protected LinearScanEliminateSpillMovePhase createSpillMoveEliminationPhase() {
        return new SSALinearScanEliminateSpillMovePhase(this);
    }

    @Override
    protected void beforeSpillMoveElimination() {
        try (DebugContext.Scope s1 = this.debug.scope("Remove Phi In");){
            for (int blockId : this.sortedBlocks()) {
                BasicBlock<?> toBlock = this.getLIR().getBlockById(blockId);
                if (toBlock.getPredecessorCount() <= 1) continue;
                SSAUtil.removePhiIn(this.getLIR(), toBlock);
            }
        }
    }
}

