/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64CalcStringAttributesOp;
import org.graalvm.compiler.lir.aarch64.AArch64ComplexVectorOp;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="HAS_NEGATIVES")
public final class AArch64HasNegativesOp
extends AArch64ComplexVectorOp {
    public static final LIRInstructionClass<AArch64HasNegativesOp> TYPE = LIRInstructionClass.create(AArch64HasNegativesOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private Value result;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value array;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value length;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] vectorTemp;

    public AArch64HasNegativesOp(LIRGeneratorTool tool, Value result, Value array, Value length) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.array = array;
        this.length = length;
        this.temp = AArch64HasNegativesOp.allocateTempRegisters(tool, 1);
        this.vectorTemp = AArch64HasNegativesOp.allocateVectorRegisters(tool, 3);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler asm) {
        try (AArch64MacroAssembler.ScratchRegister sc1 = asm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sc2 = asm.getScratchRegister();){
            Register arr = sc1.getRegister();
            Register len = sc2.getRegister();
            Register tmp = ValueUtil.asRegister((Value)this.temp[0]);
            Register ret = ValueUtil.asRegister((Value)this.result);
            Label end = new Label();
            asm.mov(64, arr, ValueUtil.asRegister((Value)this.array));
            asm.mov(32, len, ValueUtil.asRegister((Value)this.length));
            AArch64CalcStringAttributesOp.emitLatin1(asm, arr, len, tmp, ret, end, ValueUtil.asRegister((Value)this.vectorTemp[0]), ValueUtil.asRegister((Value)this.vectorTemp[1]), ValueUtil.asRegister((Value)this.vectorTemp[2]));
            asm.align(16);
            asm.bind(end);
        }
    }
}

