/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@StubPort(path="src/hotspot/cpu/aarch64/macroAssembler_aarch64.hpp", lineStart=516, lineEnd=519, commit="b1d89f30663aed28783e839c5690f46a2b382002", sha1="446563a578452e34c8a2792d62debbfd01dae113")
public class AArch64FloatToHalfFloatOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64FloatToHalfFloatOp> TYPE = LIRInstructionClass.create(AArch64FloatToHalfFloatOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value dstValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value srcValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value tmpValue;

    public AArch64FloatToHalfFloatOp(LIRGeneratorTool tool, Value dstValue, Value srcValue) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.dstValue = dstValue;
        this.srcValue = srcValue;
        this.tmpValue = tool.newVariable(srcValue.getValueKind());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Register tmp = ValueUtil.asRegister((Value)this.tmpValue);
        masm.fcvt(16, 32, tmp, src);
        masm.neon.smovGX(AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64ASIMDAssembler.ElementSize.HalfWord, dst, tmp, 0);
    }
}

