/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.lir.CastValue;
import org.graalvm.compiler.lir.CompositeValue;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;

public final class LIRValueUtil {
    public static boolean isVariable(Value value) {
        assert (value != null);
        return LIRValueUtil.stripCast(value) instanceof Variable;
    }

    public static Variable asVariable(Value value) {
        assert (value != null);
        return (Variable)LIRValueUtil.stripCast(value);
    }

    public static boolean isConstantValue(Value value) {
        assert (value != null);
        return value instanceof ConstantValue;
    }

    public static ConstantValue asConstantValue(Value value) {
        assert (value != null);
        return (ConstantValue)value;
    }

    public static Constant asConstant(Value value) {
        return LIRValueUtil.asConstantValue(value).getConstant();
    }

    public static boolean isJavaConstant(Value value) {
        return LIRValueUtil.isConstantValue(value) && LIRValueUtil.asConstantValue(value).isJavaConstant();
    }

    public static JavaConstant asJavaConstant(Value value) {
        return LIRValueUtil.asConstantValue(value).getJavaConstant();
    }

    public static boolean isNullConstant(Value value) {
        assert (value != null);
        return LIRValueUtil.isJavaConstant(value) && LIRValueUtil.asJavaConstant(value).isNull();
    }

    public static boolean isIntConstant(Value value, long expected) {
        JavaConstant javaConstant;
        if (LIRValueUtil.isJavaConstant(value) && (javaConstant = LIRValueUtil.asJavaConstant(value)) != null && javaConstant.getJavaKind().isNumericInteger()) {
            return javaConstant.asLong() == expected;
        }
        return false;
    }

    public static boolean isStackSlotValue(Value value) {
        assert (value != null);
        return value instanceof StackSlot || value instanceof VirtualStackSlot;
    }

    public static boolean isVirtualStackSlot(Value value) {
        assert (value != null);
        return value instanceof VirtualStackSlot;
    }

    public static VirtualStackSlot asVirtualStackSlot(Value value) {
        assert (value != null);
        return (VirtualStackSlot)value;
    }

    public static boolean sameRegister(Value v1, Value v2) {
        return ValueUtil.isRegister((Value)v1) && ValueUtil.isRegister((Value)v2) && ValueUtil.asRegister((Value)v1).equals((Object)ValueUtil.asRegister((Value)v2));
    }

    public static boolean sameRegister(Value v1, Value v2, Value v3) {
        return LIRValueUtil.sameRegister(v1, v2) && LIRValueUtil.sameRegister(v1, v3);
    }

    public static boolean isCast(Value value) {
        assert (value != null);
        return value instanceof CastValue;
    }

    public static Value stripCast(Value value) {
        return LIRValueUtil.isCast(value) ? ((CastValue)value).underlyingValue() : value;
    }

    public static boolean differentRegisters(Object ... values) {
        List<Register> registers = LIRValueUtil.collectRegisters(values, new ArrayList<Register>());
        for (int i = 1; i < registers.size(); ++i) {
            Register r1 = registers.get(i);
            for (int j = 0; j < i; ++j) {
                Register r2 = registers.get(j);
                assert (!r1.equals((Object)r2)) : r1 + " appears more than once";
            }
        }
        return true;
    }

    private static List<Register> collectRegisters(Object[] values, List<Register> registers) {
        for (Object o : values) {
            if (o instanceof Register) {
                registers.add((Register)o);
                continue;
            }
            if (o instanceof Value) {
                if (ValueUtil.isRegister((Value)((Value)o))) {
                    registers.add(ValueUtil.asRegister((Value)((Value)o)));
                    continue;
                }
                if (!(o instanceof CompositeValue)) continue;
                CompositeValue compositeValue = (CompositeValue)((Object)o);
                compositeValue.visitEachComponent(null, null, (instruction, value, mode, flags) -> {
                    if (ValueUtil.isRegister((Value)((Value)o))) {
                        registers.add(ValueUtil.asRegister((Value)((Value)o)));
                    }
                });
                continue;
            }
            if (o instanceof Object[]) {
                LIRValueUtil.collectRegisters((Object[])o, registers);
                continue;
            }
            throw new IllegalArgumentException("Not a Register or Value: " + o);
        }
        return registers;
    }
}

