/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.word;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.hotspot.nodes.type.MethodCountersPointerStamp;
import org.graalvm.compiler.hotspot.nodes.type.MethodPointerStamp;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.hotspot.word.MetaspacePointer;
import org.graalvm.compiler.hotspot.word.MethodCountersPointer;
import org.graalvm.compiler.hotspot.word.MethodPointer;
import org.graalvm.compiler.word.WordTypes;

public class HotSpotWordTypes
extends WordTypes {
    private final ResolvedJavaType metaspacePointerType;
    private final Class<?> metaspacePointerClass;
    private final ResolvedJavaType klassPointerType;
    private final ResolvedJavaType methodPointerType;
    private final ResolvedJavaType methodCountersPointerType;
    private final Class<?> klassPointerClass;
    private final Class<?> methodPointerClass;
    private final Class<?> methodCountersPointerClass;

    public HotSpotWordTypes(MetaAccessProvider metaAccess, JavaKind wordKind) {
        super(metaAccess, wordKind);
        this.metaspacePointerType = metaAccess.lookupJavaType(MetaspacePointer.class);
        this.metaspacePointerClass = MetaspacePointer.class;
        this.klassPointerType = metaAccess.lookupJavaType(KlassPointer.class);
        this.klassPointerClass = KlassPointer.class;
        this.methodPointerClass = MethodPointer.class;
        this.methodPointerType = metaAccess.lookupJavaType(MethodPointer.class);
        this.methodCountersPointerType = metaAccess.lookupJavaType(MethodCountersPointer.class);
        this.methodCountersPointerClass = MethodCountersPointer.class;
        assert (this.metaspacePointerType.isAssignableFrom(this.klassPointerType));
        assert (this.metaspacePointerType.isAssignableFrom(this.methodPointerType));
        assert (this.metaspacePointerType.isAssignableFrom(this.methodCountersPointerType));
    }

    @Override
    public boolean isWord(JavaType type) {
        if (type instanceof ResolvedJavaType && this.metaspacePointerType.isAssignableFrom((ResolvedJavaType)type)) {
            return true;
        }
        return super.isWord(type);
    }

    @Override
    public boolean isWord(Class<?> clazz) {
        if (this.metaspacePointerClass.isAssignableFrom(clazz)) {
            return true;
        }
        return super.isWord(clazz);
    }

    @Override
    public JavaKind asKind(JavaType type) {
        if (type instanceof ResolvedJavaType && this.metaspacePointerType.isAssignableFrom((ResolvedJavaType)type)) {
            return this.getWordKind();
        }
        return super.asKind(type);
    }

    @Override
    public Stamp getWordStamp(ResolvedJavaType type) {
        if (type.equals(this.klassPointerType)) {
            return KlassPointerStamp.klass();
        }
        if (type.equals(this.methodPointerType)) {
            return MethodPointerStamp.method();
        }
        if (type.equals(this.methodCountersPointerType)) {
            return MethodCountersPointerStamp.methodCounters();
        }
        return super.getWordStamp(type);
    }

    @Override
    public Stamp getWordStamp(Class<?> type) {
        if (type.equals(this.klassPointerClass)) {
            return KlassPointerStamp.klass();
        }
        if (type.equals(this.methodPointerClass)) {
            return MethodPointerStamp.method();
        }
        if (type.equals(this.methodCountersPointerClass)) {
            return MethodCountersPointerStamp.methodCounters();
        }
        return super.getWordStamp(type);
    }
}

