/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.stubs.Stub;

public class StubCompilationIdentifier
implements CompilationIdentifier {
    private static final AtomicLong uniqueStubIds = new AtomicLong();
    private final long id = uniqueStubIds.getAndIncrement();
    private final Stub stub;

    public StubCompilationIdentifier(Stub stub) {
        this.stub = stub;
    }

    @Override
    public final String toString() {
        return this.toString(CompilationIdentifier.Verbosity.DETAILED);
    }

    @Override
    public String toString(CompilationIdentifier.Verbosity verbosity) {
        switch (verbosity) {
            case ID: {
                return this.buildID();
            }
            case NAME: {
                return this.buildName();
            }
            case DETAILED: {
                return this.buildID() + "[" + this.buildName() + "]";
            }
        }
        throw new GraalError("unknown verbosity: " + verbosity);
    }

    private String buildName() {
        return this.stub.toString();
    }

    private String buildID() {
        return "StubCompilation-" + this.id;
    }
}

