/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.StubForeignCallNode;
import org.graalvm.compiler.hotspot.stubs.AbstractForeignCallStub;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.GraphKit;
import org.graalvm.compiler.replacements.nodes.ReadRegisterNode;
import org.graalvm.compiler.word.WordCastNode;

public class InvokeJavaMethodStub
extends AbstractForeignCallStub {
    private final ResolvedJavaMethod javaMethod;

    public InvokeJavaMethodStub(OptionValues options, HotSpotJVMCIRuntime runtime, HotSpotProviders providers, long address, HotSpotForeignCallDescriptor descriptor, ResolvedJavaMethod staticMethod) {
        super(options, runtime, providers, address, descriptor, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, true);
        this.javaMethod = staticMethod;
        GraalError.guarantee(!this.javaMethod.getSignature().getReturnKind().isNumericFloat(), "float/double returns don't work with register save/restore logic: %s", (Object)this.javaMethod);
    }

    @Override
    protected HotSpotForeignCallDescriptor getTargetSignature(HotSpotForeignCallDescriptor descriptor) {
        return HotSpotHostForeignCallsProvider.INVOKE_STATIC_METHOD_ONE_ARG;
    }

    @Override
    protected boolean returnsObject() {
        return this.javaMethod.getSignature().getReturnKind().isObject();
    }

    @Override
    protected boolean shouldClearException() {
        return false;
    }

    @Override
    protected ValueNode createTargetCall(GraphKit kit, ReadRegisterNode thread) {
        ParameterNode[] params = this.createParameters(kit);
        ValueNode[] targetArguments = new ValueNode[2 + params.length];
        targetArguments[0] = thread;
        targetArguments[1] = ConstantNode.forConstant(this.providers.getStampProvider().createMethodStamp(), this.javaMethod.getEncoding(), this.providers.getMetaAccess(), kit.getGraph());
        if (params.length == 0) {
            targetArguments[2] = ConstantNode.defaultForKind(JavaKind.Long, kit.getGraph());
        } else {
            ValueNode value = params[0];
            Stamp valueStamp = value.stamp(NodeView.DEFAULT);
            if (valueStamp instanceof ObjectStamp) {
                value = WordCastNode.objectToUntrackedPointer(value, JavaKind.Long);
                kit.append(value);
            } else if (valueStamp instanceof PrimitiveStamp) {
                int bits;
                if (valueStamp instanceof FloatStamp) {
                    value = ReinterpretNode.create(valueStamp.getStackKind() == JavaKind.Float ? JavaKind.Int : JavaKind.Long, value, NodeView.DEFAULT);
                }
                if ((bits = PrimitiveStamp.getBits(valueStamp)) != 0 && bits < JavaKind.Long.getBitCount()) {
                    value = new ZeroExtendNode(value, JavaKind.Long.getBitCount());
                }
            }
            targetArguments[2] = value;
        }
        assert (HotSpotHostForeignCallsProvider.INVOKE_STATIC_METHOD_ONE_ARG.getResultType() == Long.TYPE);
        Stamp returnStamp = StampFactory.forKind(JavaKind.Long);
        StubForeignCallNode result = kit.append(new StubForeignCallNode(this.providers.getForeignCalls(), returnStamp, HotSpotHostForeignCallsProvider.INVOKE_STATIC_METHOD_ONE_ARG, targetArguments));
        return result;
    }

    @Override
    protected void checkSafeDataReference(DataPatch data) {
        HotSpotMetaspaceConstant meta;
        ConstantReference reference;
        if (data.reference instanceof ConstantReference && (reference = (ConstantReference)data.reference).getConstant() instanceof HotSpotMetaspaceConstant && this.javaMethod.equals((meta = (HotSpotMetaspaceConstant)reference.getConstant()).asResolvedJavaMethod())) {
            return;
        }
        super.checkSafeDataReference(data);
    }
}

