/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.FastNotifyNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class ObjectSnippets
implements Snippets {
    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native boolean fastNotifyStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    @Snippet
    public static void fastNotify(Object thisObj) {
        if (BranchProbabilityNode.probability(0.99, ObjectSnippets.fastNotifyStub(HotSpotHostForeignCallsProvider.NOTIFY, thisObj))) {
            return;
        }
        PiNode.piCastNonNull(thisObj, SnippetAnchorNode.anchor()).notify();
    }

    @Snippet
    public static void fastNotifyAll(Object thisObj) {
        if (BranchProbabilityNode.probability(0.99, ObjectSnippets.fastNotifyStub(HotSpotHostForeignCallsProvider.NOTIFY_ALL, thisObj))) {
            return;
        }
        PiNode.piCastNonNull(thisObj, SnippetAnchorNode.anchor()).notifyAll();
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo notifySnippet;
        private final SnippetTemplate.SnippetInfo notifyAllSnippet;

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
            this.notifySnippet = this.snippet((Providers)providers, ObjectSnippets.class, "fastNotify", Templates.findMethod(providers.getMetaAccess(), Object.class, "notify"), null, new LocationIdentity[0]);
            this.notifyAllSnippet = this.snippet((Providers)providers, ObjectSnippets.class, "fastNotifyAll", Templates.findMethod(providers.getMetaAccess(), Object.class, "notifyAll"), null, new LocationIdentity[0]);
        }

        public void lower(Node n, LoweringTool tool) {
            if (n instanceof FastNotifyNode) {
                FastNotifyNode fn = (FastNotifyNode)n;
                StructuredGraph graph = (StructuredGraph)n.graph();
                FrameState stateDuringCall = fn.stateDuring();
                assert (stateDuringCall != null) : "Must have valid state for snippet recursive notify call";
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(fn.isNotifyAll() ? this.notifyAllSnippet : this.notifySnippet, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("thisObj", fn.object);
                SnippetTemplate template = this.template(tool, fn, args);
                graph.getDebug().log("Lowering fast notify in %s: node=%s, template=%s, arguments=%s", graph, (Object)fn, (Object)template, (Object)args);
                UnmodifiableEconomicMap<Node, Node> duplicates = template.instantiate(tool.getMetaAccess(), fn, SnippetTemplate.DEFAULT_REPLACER, args);
                for (Node originalNode : duplicates.getKeys()) {
                    if (originalNode instanceof InvokeNode) {
                        InvokeNode invoke = (InvokeNode)duplicates.get((Object)originalNode);
                        assert (invoke.asNode().graph() == graph);
                        invoke.setBci(fn.getBci());
                        invoke.setStateDuring(null);
                        invoke.setStateAfter(null);
                        invoke.setStateDuring(stateDuringCall);
                        continue;
                    }
                    if (!(originalNode instanceof InvokeWithExceptionNode)) continue;
                    throw new GraalError("unexpected invoke with exception %s in snippet", originalNode);
                }
            } else {
                GraalError.shouldNotReachHere("Unknown object snippet lowered node");
            }
        }
    }
}

