/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.word.Word;
import org.graalvm.compiler.word.WordTypes;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class MonitorCounterNode
extends FloatingNode
implements LIRLowerable,
Node.ValueNumberable {
    public static final NodeClass<MonitorCounterNode> TYPE = NodeClass.create(MonitorCounterNode.class);

    public MonitorCounterNode(@Node.InjectedNodeParameter WordTypes wordTypes) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(wordTypes.getWordKind()));
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.graph().getNodes().filter(MonitorCounterNode.class).count() == 1) : "monitor counters not canonicalized to single instance";
        VirtualStackSlot counter = gen.getLIRGeneratorTool().allocateStackMemory(4, 4);
        Variable result = gen.getLIRGeneratorTool().emitAddress(counter);
        gen.setResult(this, (Value)result);
    }

    @Node.NodeIntrinsic
    public static native Word counter();
}

