/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public final class DeoptimizeWithExceptionInCallerNode
extends ControlSinkNode
implements LIRLowerable {
    public static final NodeClass<DeoptimizeWithExceptionInCallerNode> TYPE = NodeClass.create(DeoptimizeWithExceptionInCallerNode.class);
    @Node.Input
    protected ValueNode exception;

    public DeoptimizeWithExceptionInCallerNode(ValueNode exception) {
        super((NodeClass<? extends ControlSinkNode>)TYPE, StampFactory.forVoid());
        this.exception = exception;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Value e = gen.operand(this.exception);
        ((HotSpotLIRGenerator)gen.getLIRGeneratorTool()).emitDeoptimizeWithExceptionInCaller(e);
    }

    @Node.NodeIntrinsic
    public static native void deopt(Object var0);
}

