/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.SnippetObjectConstant;
import org.graalvm.compiler.word.WordTypes;

public class HotSpotSnippetReflectionProvider
implements SnippetReflectionProvider {
    private final HotSpotGraalRuntimeProvider runtime;
    private final HotSpotConstantReflectionProvider constantReflection;
    private final WordTypes wordTypes;
    private final Method hotSpotJDKReflectionGetMethod;
    private final Method hotSpotJDKReflectionGetField;
    private Class<?> wordTypesType;
    private Class<?> runtimeType;
    private Class<?> configType;

    public HotSpotSnippetReflectionProvider(HotSpotGraalRuntimeProvider runtime, HotSpotConstantReflectionProvider constantReflection, WordTypes wordTypes) {
        this.runtime = runtime;
        this.constantReflection = constantReflection;
        this.wordTypes = wordTypes;
        if (Services.IS_IN_NATIVE_IMAGE) {
            this.hotSpotJDKReflectionGetMethod = null;
            this.hotSpotJDKReflectionGetField = null;
        } else {
            try {
                Class<?> hsJDKReflection = Class.forName("jdk.vm.ci.hotspot.HotSpotJDKReflection");
                this.hotSpotJDKReflectionGetMethod = HotSpotSnippetReflectionProvider.lookupMethod(hsJDKReflection, "getMethod", Class.forName("jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl"));
                this.hotSpotJDKReflectionGetField = HotSpotSnippetReflectionProvider.lookupMethod(hsJDKReflection, "getField", Class.forName("jdk.vm.ci.hotspot.HotSpotResolvedJavaFieldImpl"));
            }
            catch (ReflectiveOperationException ex) {
                throw GraalError.shouldNotReachHere(ex);
            }
        }
    }

    @Override
    public JavaConstant forObject(Object object) {
        return this.constantReflection.forObject(object);
    }

    @Override
    public <T> T asObject(Class<T> type, JavaConstant constant) {
        if (constant.isNull()) {
            return null;
        }
        if (constant instanceof HotSpotObjectConstant) {
            HotSpotObjectConstant hsConstant = (HotSpotObjectConstant)constant;
            return (T)hsConstant.asObject(type);
        }
        if (constant instanceof SnippetObjectConstant) {
            SnippetObjectConstant snippetObject = (SnippetObjectConstant)constant;
            return snippetObject.asObject(type);
        }
        return null;
    }

    @Override
    public JavaConstant forBoxed(JavaKind kind, Object value) {
        if (kind == JavaKind.Object) {
            return this.forObject(value);
        }
        return JavaConstant.forBoxedPrimitive((Object)value);
    }

    @Override
    public <T> T getInjectedNodeIntrinsicParameter(Class<T> type) {
        GraalHotSpotVMConfig config = this.runtime.getVMConfig();
        if (this.configType == null || this.wordTypesType == null || this.runtimeType == null) {
            this.wordTypesType = this.wordTypes.getClass();
            this.runtimeType = this.runtime.getClass();
            this.configType = config.getClass();
        }
        if (type.isAssignableFrom(this.wordTypesType)) {
            return type.cast(this.wordTypes);
        }
        if (type.isAssignableFrom(this.runtimeType)) {
            return type.cast(this.runtime);
        }
        if (type.isAssignableFrom(this.configType)) {
            return type.cast(config);
        }
        return null;
    }

    @Override
    public Class<?> originalClass(ResolvedJavaType type) {
        return HotSpotJVMCIRuntime.runtime().getMirror(type);
    }

    private static Method lookupMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) throws ReflectiveOperationException {
        Method result = declaringClass.getDeclaredMethod(methodName, parameterTypes);
        result.setAccessible(true);
        return result;
    }

    @Override
    public Executable originalMethod(ResolvedJavaMethod method) {
        if (method.isClassInitializer()) {
            return null;
        }
        if (this.hotSpotJDKReflectionGetMethod == null) {
            return null;
        }
        try {
            return (Executable)this.hotSpotJDKReflectionGetMethod.invoke(null, method);
        }
        catch (ReflectiveOperationException ex) {
            throw HotSpotSnippetReflectionProvider.rethrow(ex.getCause());
        }
    }

    @Override
    public Field originalField(ResolvedJavaField field) {
        if (this.hotSpotJDKReflectionGetField == null) {
            return null;
        }
        try {
            return (Field)this.hotSpotJDKReflectionGetField.invoke(null, field);
        }
        catch (ReflectiveOperationException ex) {
            if (ex.getCause() instanceof IllegalArgumentException) {
                return null;
            }
            throw HotSpotSnippetReflectionProvider.rethrow(ex.getCause());
        }
    }

    private static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }
}

