/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.lir;

import java.util.ArrayList;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerationResult;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInsertionBuffer;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.ValueConsumer;
import org.graalvm.compiler.lir.gen.DiagnosticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;

public final class HotSpotZapRegistersPhase
extends PostAllocationOptimizationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        Stub stub = ((HotSpotLIRGenerationResult)lirGenRes).getStub();
        boolean zapRegisters = stub == null;
        boolean zapStack = false;
        CallingConvention callingConvention = lirGenRes.getCallingConvention();
        for (AllocatableValue arg : callingConvention.getArguments()) {
            if (!ValueUtil.isStackSlot((Value)arg)) continue;
            zapStack = true;
            break;
        }
        if (zapRegisters || zapStack) {
            LIR lir = lirGenRes.getLIR();
            EconomicSet allocatableRegisters = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
            for (Register r : lirGenRes.getFrameMap().getRegisterConfig().getAllocatableRegisters()) {
                allocatableRegisters.add((Object)r);
            }
            HotSpotZapRegistersPhase.processLIR(context.diagnosticLirGenTool, lir, (EconomicSet<Register>)allocatableRegisters, zapRegisters, zapStack);
        }
    }

    private static void processLIR(DiagnosticLIRGeneratorTool diagnosticLirGenTool, LIR lir, EconomicSet<Register> allocatableRegisters, boolean zapRegisters, boolean zapStack) {
        LIRInsertionBuffer buffer = new LIRInsertionBuffer();
        for (int blockId : lir.getBlocks()) {
            if (LIR.isBlockDeleted(blockId)) continue;
            BasicBlock<?> block = lir.getBlockById(blockId);
            HotSpotZapRegistersPhase.processBlock(diagnosticLirGenTool, lir, allocatableRegisters, buffer, block, zapRegisters, zapStack);
        }
    }

    private static void processBlock(DiagnosticLIRGeneratorTool diagnosticLirGenTool, LIR lir, EconomicSet<Register> allocatableRegisters, LIRInsertionBuffer buffer, BasicBlock<?> block, boolean zapRegisters, boolean zapStack) {
        DebugContext debug = lir.getDebug();
        try (Indent indent = debug.logAndIndent("Process block %s", block);){
            ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(block);
            buffer.init(instructions);
            for (int index = 0; index < instructions.size(); ++index) {
                LIRInstruction zap;
                LIRInstruction inst = instructions.get(index);
                if (zapStack && inst instanceof DiagnosticLIRGeneratorTool.ZapStackArgumentSpaceBeforeInstruction && (zap = diagnosticLirGenTool.zapArgumentSpace()) != null) {
                    buffer.append(index, zap);
                }
                if (!zapRegisters || !(inst instanceof DiagnosticLIRGeneratorTool.ZapRegistersAfterInstruction)) continue;
                EconomicSet destroyedRegisters = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
                ValueConsumer tempConsumer = (value, mode, flags) -> {
                    Register reg;
                    if (ValueUtil.isRegister((Value)value) && allocatableRegisters.contains((Object)(reg = ValueUtil.asRegister((Value)value)))) {
                        destroyedRegisters.add((Object)reg);
                    }
                };
                ValueConsumer defConsumer = (value, mode, flags) -> {
                    if (ValueUtil.isRegister((Value)value)) {
                        Register reg = ValueUtil.asRegister((Value)value);
                        destroyedRegisters.remove((Object)reg);
                    }
                };
                inst.visitEachTemp(tempConsumer);
                inst.visitEachOutput(defConsumer);
                LIRInstruction zap2 = diagnosticLirGenTool.createZapRegisters((Register[])destroyedRegisters.toArray((Object[])new Register[destroyedRegisters.size()]));
                buffer.append(index + 1, zap2);
                debug.log("Insert ZapRegister after %s", inst);
            }
            buffer.finish();
        }
    }
}

