/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.amd64.AMD64X87MathIntrinsicNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.word.LocationIdentity;

public class AMD64X87MathSnippets
implements Snippets {
    private static final double PI_4 = 0.7853981633974483;

    @Snippet
    public static double sin(double input) {
        if (BranchProbabilityNode.probability(0.6, Math.abs(input) < 0.7853981633974483)) {
            return AMD64X87MathIntrinsicNode.compute(input, UnaryMathIntrinsicNode.UnaryOperation.SIN);
        }
        return AMD64X87MathSnippets.callDouble1(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallSignature, input);
    }

    @Snippet
    public static double cos(double input) {
        if (BranchProbabilityNode.probability(0.6, Math.abs(input) < 0.7853981633974483)) {
            return AMD64X87MathIntrinsicNode.compute(input, UnaryMathIntrinsicNode.UnaryOperation.COS);
        }
        return AMD64X87MathSnippets.callDouble1(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallSignature, input);
    }

    @Snippet
    public static double tan(double input) {
        if (BranchProbabilityNode.probability(0.6, Math.abs(input) < 0.7853981633974483)) {
            return AMD64X87MathIntrinsicNode.compute(input, UnaryMathIntrinsicNode.UnaryOperation.TAN);
        }
        return AMD64X87MathSnippets.callDouble1(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallSignature, input);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native double callDouble1(@Node.ConstantNodeParameter ForeignCallSignature var0, double var1);

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo sin;
        private final SnippetTemplate.SnippetInfo cos;
        private final SnippetTemplate.SnippetInfo tan;

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
            this.sin = this.snippet(providers, AMD64X87MathSnippets.class, "sin", new LocationIdentity[0]);
            this.cos = this.snippet(providers, AMD64X87MathSnippets.class, "cos", new LocationIdentity[0]);
            this.tan = this.snippet(providers, AMD64X87MathSnippets.class, "tan", new LocationIdentity[0]);
        }

        public void lower(UnaryMathIntrinsicNode mathIntrinsicNode, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(switch (mathIntrinsicNode.getOperation()) {
                case UnaryMathIntrinsicNode.UnaryOperation.SIN -> this.sin;
                case UnaryMathIntrinsicNode.UnaryOperation.COS -> this.cos;
                case UnaryMathIntrinsicNode.UnaryOperation.TAN -> this.tan;
                default -> throw GraalError.shouldNotReachHere("Snippet not found for math intrinsic " + mathIntrinsicNode.getOperation().name());
            }, mathIntrinsicNode.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("input", mathIntrinsicNode.getValue());
            this.template(tool, mathIntrinsicNode, args).instantiate(tool.getMetaAccess(), mathIntrinsicNode, SnippetTemplate.DEFAULT_REPLACER, tool, args);
            mathIntrinsicNode.safeDelete();
        }
    }
}

