/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.options.OptionValues;

public class AMD64HotSpotMacroAssembler
extends AMD64MacroAssembler {
    private final GraalHotSpotVMConfig config;

    public AMD64HotSpotMacroAssembler(GraalHotSpotVMConfig config, TargetDescription target, OptionValues optionValues, boolean hasIntelJccErratum) {
        super(target, optionValues, hasIntelJccErratum);
        this.config = config;
    }

    @Override
    public void postCallNop(Infopoint infopoint) {
        if (this.config.continuationsEnabled && infopoint instanceof Call) {
            Call call = (Call)infopoint;
            if (call.debugInfo != null && call.reason == InfopointReason.CALL) {
                this.emitByte(15);
                this.emitByte(31);
                this.emitByte(132);
                this.emitByte(0);
                this.emitInt(0);
                return;
            }
        }
        super.postCallNop(infopoint);
    }

    public void nmethodEntryCompare(int displacement) {
        this.emitByte(65);
        this.emitByte(129);
        this.emitByte(127);
        GraalError.guarantee(NumUtil.isByte(displacement), "expected byte sized displacement");
        this.emitByte(displacement & 0xFF);
        GraalError.guarantee(this.position() % 4 == 0, "must be aligned");
        this.emitInt(0);
    }
}

