/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotZBarrierSetLIRGenerator;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64AtomicMove;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="CAS_Z")
public final class AArch64HotSpotZCompareAndSwapOp
extends AArch64AtomicMove.CompareAndSwapOp {
    public static final LIRInstructionClass<AArch64HotSpotZCompareAndSwapOp> TYPE = LIRInstructionClass.create(AArch64HotSpotZCompareAndSwapOp.class);
    private final GraalHotSpotVMConfig config;
    private final ForeignCallLinkage callTarget;
    @LIRInstruction.Temp
    protected AllocatableValue temp;

    public AArch64HotSpotZCompareAndSwapOp(AArch64Kind accessKind, MemoryOrderMode memoryOrder, boolean setConditionFlags, AllocatableValue result, Value expectedValue, AllocatableValue newValue, AllocatableValue addressValue, GraalHotSpotVMConfig config, ForeignCallLinkage callTarget, AllocatableValue temp) {
        super(TYPE, accessKind, memoryOrder, setConditionFlags, result, expectedValue, newValue, addressValue);
        this.config = config;
        this.callTarget = callTarget;
        this.temp = temp;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        super.emitCode(crb, masm);
        AArch64Address location = AArch64Address.createBaseRegisterOnlyAddress(64, ValueUtil.asRegister((Value)this.addressValue));
        Label good = new Label();
        AArch64HotSpotZBarrierSetLIRGenerator.emitBarrier(crb, masm, good, ValueUtil.asRegister((Value)this.resultValue), this.config, this.callTarget, location, this, null);
        super.emitCode(crb, masm);
        masm.bind(good);
    }
}

