/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.MethodFilter;
import org.graalvm.compiler.debug.PathUtilities;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.hotspot.CompilationTask;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.java.LambdaUtils;
import org.graalvm.compiler.java.StableMethodNameFormatter;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.spi.StableProfileProvider;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.util.json.JSONFormatter;
import org.graalvm.util.json.JSONParser;

public final class ProfileReplaySupport {
    private final StableProfileProvider.LambdaNameFormatter lambdaNameFormatter;
    private final Boolean expectedResult;
    private final String expectedCodeSignature;
    private final String expectedGraphSignature;
    private final MethodFilter profileFilter;
    private final StableProfileProvider.TypeFilter profileSaveFilter;

    private ProfileReplaySupport(StableProfileProvider.LambdaNameFormatter lambdaNameFormatter, Boolean expectedResult, String expectedCodeSignature, String expectedGraphSignature, MethodFilter profileFilter, StableProfileProvider.TypeFilter profileSaveFilter) {
        this.lambdaNameFormatter = lambdaNameFormatter;
        this.expectedResult = expectedResult;
        this.expectedCodeSignature = expectedCodeSignature;
        this.expectedGraphSignature = expectedGraphSignature;
        this.profileFilter = profileFilter;
        this.profileSaveFilter = profileSaveFilter;
    }

    public Boolean getExpectedResult() {
        return this.expectedResult;
    }

    public static ProfileReplaySupport profileReplayPrologue(final DebugContext debug, final HotSpotGraalRuntimeProvider graalRuntime, int entryBCI, HotSpotResolvedJavaMethod method, StableProfileProvider profileProvider, StableProfileProvider.TypeFilter profileSaveFilter) {
        if (Options.SaveProfiles.getValue(debug.getOptions()).booleanValue() || Options.LoadProfiles.getValue(debug.getOptions()) != null) {
            StableProfileProvider.LambdaNameFormatter lambdaNameFormatter = new StableProfileProvider.LambdaNameFormatter(){
                private final StableMethodNameFormatter stableFormatter;
                {
                    this.stableFormatter = new StableMethodNameFormatter(graalRuntime.getHostBackend().getProviders(), debug, true);
                }

                @Override
                public boolean isLambda(ResolvedJavaMethod m) {
                    return LambdaUtils.isLambdaType(m.getDeclaringClass()) || StableMethodNameFormatter.isMethodHandle(m.getDeclaringClass());
                }

                @Override
                public String formatLamdaName(ResolvedJavaMethod m) {
                    return this.stableFormatter.apply(m);
                }
            };
            Boolean expectedResult = null;
            String expectedCodeSignature = null;
            String expectedGraphSignature = null;
            MethodFilter profileFilter = null;
            String filterString = Options.ProfileMethodFilter.getValue(debug.getOptions());
            MethodFilter methodFilter = profileFilter = filterString == null || filterString.isEmpty() ? MethodFilter.matchAll() : MethodFilter.parse(filterString);
            if (Options.LoadProfiles.getValue(debug.getOptions()) != null && profileFilter.matches((JavaMethod)method)) {
                Path loadDir = Paths.get(Options.LoadProfiles.getValue(debug.getOptions()), new String[0]);
                try (Stream<Path> files = Files.list(loadDir);){
                    String s = PathUtilities.sanitizeFileName(method.format("%h.%n(%p)%r"));
                    boolean foundOne = false;
                    for (Path path : files.filter(x -> x.toString().contains(s)).filter(x -> x.toString().endsWith(".glog")).collect(Collectors.toList())) {
                        EconomicMap<String, Object> map = JSONParser.parseDict(new FileReader(path.toFile()));
                        if (entryBCI != (Integer)map.get((Object)"entryBCI")) continue;
                        foundOne = true;
                        expectedResult = (Boolean)map.get((Object)"result");
                        expectedCodeSignature = (String)map.get((Object)"codeSignature");
                        expectedGraphSignature = (String)map.get((Object)"graphSignature");
                        profileProvider.load(map, (ResolvedJavaType)method.getDeclaringClass(), Options.WarnAboutNotCachedLoadedAccess.getValue(debug.getOptions()), lambdaNameFormatter);
                        if (Options.StrictProfiles.getValue(debug.getOptions()).booleanValue()) {
                            profileProvider.freeze();
                        }
                        if (!Options.PrintProfileLoading.getValue(debug.getOptions()).booleanValue()) break;
                        TTY.println("Loaded profile data from " + path);
                        break;
                    }
                    if (Options.StrictProfiles.getValue(debug.getOptions()).booleanValue() && !foundOne) {
                        throw GraalError.shouldNotReachHere(String.format("No file for method %s found in %s, strict profiles, abort", s, loadDir));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return new ProfileReplaySupport(lambdaNameFormatter, expectedResult, expectedCodeSignature, expectedGraphSignature, profileFilter, profileSaveFilter);
        }
        return null;
    }

    public void profileReplayEpilogue(DebugContext debug, CompilationTask.HotSpotCompilationWrapper compilation, StableProfileProvider profileProvider, CompilationIdentifier compilationId, int entryBCI, HotSpotResolvedJavaMethod method) {
        if ((Options.SaveProfiles.getValue(debug.getOptions()).booleanValue() || Options.LoadProfiles.getValue(debug.getOptions()) != null) && this.profileFilter.matches((JavaMethod)method)) {
            String codeSignature = null;
            String graphSignature = null;
            if (compilation.result != null) {
                codeSignature = compilation.result.getCodeSignature();
                assert (compilation.graph != null);
                String s = ProfileReplaySupport.getCanonicalGraphString(compilation.graph);
                graphSignature = CompilationResult.getSignature(s.getBytes(StandardCharsets.UTF_8));
            }
            if (Options.WarnAboutCodeSignatureMismatch.getValue(debug.getOptions()).booleanValue() && this.expectedCodeSignature != null && !Objects.equals(codeSignature, this.expectedCodeSignature)) {
                TTY.printf("%s %s codeSignature differs %s != %s%n", method.format("%H.%n(%P)%R"), entryBCI, codeSignature, this.expectedCodeSignature);
            }
            if (Options.WarnAboutGraphSignatureMismatch.getValue(debug.getOptions()).booleanValue() && this.expectedGraphSignature != null && !Objects.equals(graphSignature, this.expectedGraphSignature)) {
                TTY.printf("%s %s graphSignature differs %s != %s%n", method.format("%H.%n(%P)%R"), entryBCI, graphSignature, this.expectedGraphSignature);
            }
            if (Options.SaveProfiles.getValue(debug.getOptions()).booleanValue()) {
                try {
                    EconomicMap map = EconomicMap.create();
                    map.put((Object)"identifier", (Object)compilationId.toString());
                    map.put((Object)"method", (Object)method.format("%H.%n(%P)%R"));
                    map.put((Object)"entryBCI", (Object)entryBCI);
                    map.put((Object)"codeSignature", (Object)codeSignature);
                    map.put((Object)"graphSignature", (Object)graphSignature);
                    map.put((Object)"result", (Object)(compilation.result != null ? 1 : 0));
                    profileProvider.recordProfiles((EconomicMap<String, Object>)map, this.profileSaveFilter, this.lambdaNameFormatter);
                    String path = null;
                    if (Options.SaveProfilesPath.getValue(debug.getOptions()) != null) {
                        String fileName = PathUtilities.sanitizeFileName(method.format("%h.%n(%p)%r") + ".glog");
                        String dirName = Options.SaveProfilesPath.getValue(debug.getOptions());
                        path = Paths.get(dirName, new String[0]).resolve(fileName).toString();
                        if (new File(path).exists()) {
                            throw new InternalError("Profile file for path " + path + " exists already");
                        }
                    } else {
                        path = debug.getDumpPath(".glog", false, false);
                    }
                    try (PrintStream out = new PrintStream(new BufferedOutputStream(PathUtilities.openOutputStream(path)));){
                        out.println(JSONFormatter.formatJSON((EconomicMap<String, Object>)map, true));
                    }
                }
                catch (Throwable t) {
                    throw debug.handle(t);
                }
            }
        }
    }

    private static String getCanonicalGraphString(StructuredGraph graph) {
        SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.SchedulingStrategy.EARLIEST);
        StructuredGraph.ScheduleResult scheduleResult = graph.getLastSchedule();
        NodeMap<Integer> canonicalId = graph.createNodeMap();
        int nextId = 0;
        StringBuilder result = new StringBuilder();
        for (HIRBlock block : scheduleResult.getCFG().getBlocks()) {
            result.append("Block ").append(block).append(' ');
            if (block == scheduleResult.getCFG().getStartBlock()) {
                result.append("* ");
            }
            result.append("-> ");
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                Object succ = block.getSuccessorAt(i);
                result.append(succ).append(' ');
            }
            result.append(String.format("%n", new Object[0]));
            for (Node node : scheduleResult.getBlockToNodesMap().get(block)) {
                int id;
                if (!(node instanceof ValueNode) || !node.isAlive() || node instanceof ConstantNode) continue;
                if (canonicalId.get(node) != null) {
                    id = (Integer)canonicalId.get(node);
                } else {
                    id = nextId++;
                    canonicalId.set(node, id);
                }
                String name = node.getClass().getSimpleName();
                result.append("  ").append(id).append('|').append(name);
                if (node instanceof AccessFieldNode) {
                    result.append('#');
                    result.append(((AccessFieldNode)node).field());
                }
                result.append("    (");
                result.append(node.usages().filter(n -> !(n instanceof FrameState)).count());
                result.append(')');
                result.append(String.format("%n", new Object[0]));
            }
        }
        return result.toString();
    }

    public static class Options {
        public static final OptionKey<Boolean> SaveProfiles = new OptionKey<Boolean>(false);
        public static final OptionKey<String> SaveProfilesPath = new OptionKey<Object>(null);
        public static final OptionKey<String> LoadProfiles = new OptionKey<Object>(null);
        public static final OptionKey<String> ProfileMethodFilter = new OptionKey<Object>(null);
        public static final OptionKey<Boolean> StrictProfiles = new OptionKey<Boolean>(true);
        public static final OptionKey<Boolean> PrintProfileLoading = new OptionKey<Boolean>(false);
        public static final OptionKey<Boolean> WarnAboutGraphSignatureMismatch = new OptionKey<Boolean>(true);
        public static final OptionKey<Boolean> WarnAboutCodeSignatureMismatch = new OptionKey<Boolean>(true);
        public static final OptionKey<Boolean> WarnAboutNotCachedLoadedAccess = new OptionKey<Boolean>(true);
    }
}

