/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.hotspot.HotSpotJVMCICompilerFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalCompilerFactory;
import org.graalvm.compiler.hotspot.IsGraalPredicateBase;

class IsGraalPredicate
extends IsGraalPredicateBase {
    private final Module jvmciModule = HotSpotJVMCICompilerFactory.class.getModule();
    private final Module graalModule = HotSpotGraalCompilerFactory.class.getModule();
    private Module compilerConfigurationModule;

    IsGraalPredicate() {
    }

    @Override
    void onCompilerConfigurationFactorySelection(HotSpotJVMCIRuntime runtime, CompilerConfigurationFactory factory) {
        this.compilerConfigurationModule = factory.getClass().getModule();
        runtime.excludeFromJVMCICompilation(new Module[]{this.jvmciModule, this.graalModule, this.compilerConfigurationModule});
    }

    @Override
    boolean apply(Class<?> declaringClass) {
        throw GraalError.shouldNotReachHere();
    }

    @Override
    HotSpotJVMCICompilerFactory.CompilationLevelAdjustment getCompilationLevelAdjustment() {
        return HotSpotJVMCICompilerFactory.CompilationLevelAdjustment.None;
    }
}

