/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.debug.TTYStreamProvider;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.IsolateUtil;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

@ServiceProvider(value=TTYStreamProvider.class)
public class HotSpotTTYStreamProvider
implements TTYStreamProvider {
    @Override
    public PrintStream getStream() {
        return Options.LogFile.getStream();
    }

    private static Pointer getBarrierPointer() {
        return (Pointer)WordFactory.nullPointer();
    }

    private static boolean execute(Runnable action, Pointer barrier) {
        if (barrier.isNull()) {
            action.run();
            return true;
        }
        long initial = 0L;
        long executing = 1L;
        long executed = 2L;
        while (true) {
            long value;
            if ((value = barrier.readLong(0)) == 0L) {
                if (barrier.compareAndSwapLong(0, value, 1L, LocationIdentity.ANY_LOCATION) != value) continue;
                action.run();
                barrier.writeLong(0, 2L);
                return true;
            }
            if (value == 2L) {
                return false;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            value = barrier.readLong(0);
        }
    }

    static {
        Word.ensureInitialized();
    }

    public static class Options {
        public static final LogStreamOptionKey LogFile = new LogStreamOptionKey();
    }

    private static class LogStreamOptionKey
    extends OptionKey<String> {
        LogStreamOptionKey() {
            super(null);
        }

        private static String makeFilename(String nameTemplate) {
            String name = nameTemplate;
            if (name.contains("%p")) {
                name = name.replace("%p", GraalServices.getExecutionID());
            }
            if (name.contains("%i")) {
                name = name.replace("%i", IsolateUtil.getIsolateID(false));
            }
            if (name.contains("%I")) {
                name = name.replace("%I", IsolateUtil.getIsolateID(true));
            }
            if (name.contains("%t")) {
                name = name.replace("%t", String.valueOf(System.currentTimeMillis()));
            }
            for (String subst : new String[]{"%o", "%e"}) {
                if (!name.contains(subst) || name.equals(subst)) continue;
                throw new IllegalArgumentException("LogFile substitution " + subst + " cannot be combined with any other characters");
            }
            return name;
        }

        public PrintStream getStream() {
            return new PrintStream(new DelayedOutputStream());
        }

        class DelayedOutputStream
        extends OutputStream {
            @NativeImageReinitialize
            private volatile OutputStream lazy;

            DelayedOutputStream() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private OutputStream lazy() {
                if (this.lazy == null) {
                    DelayedOutputStream delayedOutputStream = this;
                    synchronized (delayedOutputStream) {
                        if (this.lazy == null) {
                            try {
                                String nameTemplate = (String)LogStreamOptionKey.this.getValue(HotSpotGraalOptionValues.defaultOptions());
                                if (nameTemplate != null) {
                                    String name;
                                    switch (name = LogStreamOptionKey.makeFilename(nameTemplate)) {
                                        case "%o": {
                                            this.lazy = System.out;
                                            break;
                                        }
                                        case "%e": {
                                            this.lazy = System.err;
                                            break;
                                        }
                                        default: {
                                            boolean executed = HotSpotTTYStreamProvider.execute(() -> {
                                                File file = new File(name);
                                                if (file.exists()) {
                                                    file.delete();
                                                }
                                            }, HotSpotTTYStreamProvider.getBarrierPointer());
                                            boolean enableAutoflush = true;
                                            FileOutputStream result = new FileOutputStream(name, true);
                                            if (executed) {
                                                this.printVMConfig(true, result);
                                            }
                                            this.lazy = result;
                                        }
                                    }
                                    return this.lazy;
                                }
                                this.lazy = HotSpotJVMCIRuntime.runtime().getLogStream();
                                HotSpotTTYStreamProvider.execute(() -> {
                                    PrintStream ps = new PrintStream(this.lazy);
                                    ps.printf("[Use -D%sLogFile=<path> to redirect Graal log output to a file.]%n", "graal.");
                                    ps.flush();
                                }, HotSpotTTYStreamProvider.getBarrierPointer());
                            }
                            catch (Throwable t) {
                                System.err.println("Error initializing Graal log output:");
                                t.printStackTrace();
                                HotSpotGraalServices.exit(1, HotSpotJVMCIRuntime.runtime());
                            }
                        }
                    }
                }
                return this.lazy;
            }

            @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="false positive on dead store to `ps`")
            private void printVMConfig(boolean enableAutoflush, FileOutputStream result) {
                String cmd;
                PrintStream ps = new PrintStream(result, enableAutoflush);
                List<String> inputArguments = GraalServices.getInputArguments();
                if (inputArguments != null) {
                    ps.println("VM Arguments: " + String.join((CharSequence)" ", inputArguments));
                }
                if ((cmd = (String)Services.getSavedProperties().get("sun.java.command")) != null) {
                    ps.println("sun.java.command=" + cmd);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.lazy().write(b, off, len);
            }

            @Override
            public void write(int b) throws IOException {
                this.lazy().write(b);
            }

            @Override
            public void flush() throws IOException {
                this.lazy().flush();
            }

            @Override
            public void close() throws IOException {
                this.lazy().close();
            }
        }
    }
}

