/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.HotSpotVMEventListener;
import jdk.vm.ci.runtime.JVMCICompilerFactory;
import jdk.vm.ci.services.JVMCIServiceLocator;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotGraalCompilerFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.HotSpotGraalVMEventListener;
import org.graalvm.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=JVMCIServiceLocator.class)
public final class HotSpotGraalJVMCIServiceLocator
extends JVMCIServiceLocator {
    public <T> T getProvider(Class<T> service) {
        return Shared.SINGLETON.getProvider(service, this);
    }

    void onCompilerCreation(HotSpotGraalCompiler compiler) {
        Shared.SINGLETON.onCompilerCreation(compiler);
    }

    private static final class Shared {
        static final Shared SINGLETON = new Shared();
        @NativeImageReinitialize
        private HotSpotGraalRuntime graalRuntime;

        private Shared() {
        }

        <T> T getProvider(Class<T> service, HotSpotGraalJVMCIServiceLocator locator) {
            if (service == JVMCICompilerFactory.class) {
                return service.cast((Object)new HotSpotGraalCompilerFactory(locator));
            }
            if (service == HotSpotVMEventListener.class && this.graalRuntime != null) {
                return service.cast(new HotSpotGraalVMEventListener(this.graalRuntime));
            }
            return null;
        }

        void onCompilerCreation(HotSpotGraalCompiler compiler) {
            assert (this.graalRuntime == null) : "only expect a single JVMCICompiler to be created";
            this.graalRuntime = (HotSpotGraalRuntime)compiler.getGraalRuntime();
        }
    }
}

