/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotForeignCallTarget;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.word.WordTypes;

public class HotSpotForeignCallLinkageImpl
extends HotSpotForeignCallTarget
implements HotSpotForeignCallLinkage {
    protected final HotSpotForeignCallDescriptor descriptor;
    private Stub stub;
    private final CallingConvention outgoingCallingConvention;
    private final CallingConvention incomingCallingConvention;
    private final HotSpotForeignCallLinkage.RegisterEffect effect;
    private Value[] temporaries = AllocatableValue.NONE;

    public static HotSpotForeignCallLinkage create(MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes, HotSpotForeignCallsProvider foreignCalls, HotSpotForeignCallDescriptor descriptor, long address, HotSpotForeignCallLinkage.RegisterEffect effect, CallingConvention.Type outgoingCcType, CallingConvention.Type incomingCcType) {
        CallingConvention outgoingCc = HotSpotForeignCallLinkageImpl.createCallingConvention(metaAccess, codeCache, wordTypes, foreignCalls, descriptor, outgoingCcType);
        CallingConvention incomingCc = incomingCcType == null ? null : HotSpotForeignCallLinkageImpl.createCallingConvention(metaAccess, codeCache, wordTypes, foreignCalls, descriptor, incomingCcType);
        HotSpotForeignCallLinkageImpl linkage = new HotSpotForeignCallLinkageImpl(descriptor, address, effect, outgoingCc, incomingCc);
        if (outgoingCcType == HotSpotCallingConventionType.NativeCall) {
            linkage.temporaries = foreignCalls.getNativeABICallerSaveRegisters();
        }
        return linkage;
    }

    public static CallingConvention createCallingConvention(MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes, ValueKindFactory<?> valueKindFactory, ForeignCallDescriptor descriptor, CallingConvention.Type ccType) {
        assert (ccType != null);
        Class<?>[] argumentTypes = descriptor.getArgumentTypes();
        JavaType[] parameterTypes = new JavaType[argumentTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = HotSpotForeignCallLinkageImpl.asJavaType(argumentTypes[i], metaAccess, wordTypes);
        }
        JavaType returnType = HotSpotForeignCallLinkageImpl.asJavaType(descriptor.getResultType(), metaAccess, wordTypes);
        RegisterConfig regConfig = codeCache.getRegisterConfig();
        if (ccType instanceof StackOnlyCallingConvention) {
            StackOnlyCallingConvention conventionType = (StackOnlyCallingConvention)ccType;
            return conventionType.getCallingConvention(codeCache.getTarget(), returnType, parameterTypes, valueKindFactory);
        }
        return regConfig.getCallingConvention(ccType, returnType, parameterTypes, valueKindFactory);
    }

    private static JavaType asJavaType(Class<?> type, MetaAccessProvider metaAccess, WordTypes wordTypes) {
        if (wordTypes.isWord(type)) {
            return metaAccess.lookupJavaType(wordTypes.getWordKind().toJavaClass());
        }
        return metaAccess.lookupJavaType(type);
    }

    public HotSpotForeignCallLinkageImpl(HotSpotForeignCallDescriptor descriptor, long address, HotSpotForeignCallLinkage.RegisterEffect effect, CallingConvention outgoingCallingConvention, CallingConvention incomingCallingConvention) {
        super(address);
        this.descriptor = descriptor;
        this.address = address;
        this.effect = effect;
        assert (outgoingCallingConvention != null) : "only incomingCallingConvention can be null";
        this.outgoingCallingConvention = outgoingCallingConvention;
        this.incomingCallingConvention = incomingCallingConvention != null ? incomingCallingConvention : outgoingCallingConvention;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.stub == null ? this.descriptor.toString() : this.stub.toString());
        sb.append("@0x").append(Long.toHexString(this.address)).append(':').append(this.outgoingCallingConvention).append(":").append(this.incomingCallingConvention);
        if (this.temporaries != null && this.temporaries.length != 0) {
            sb.append("; temps=");
            String sep = "";
            for (Value op : this.temporaries) {
                sb.append(sep).append(op);
                sep = ",";
            }
        }
        return sb.toString();
    }

    @Override
    public HotSpotForeignCallLinkage.RegisterEffect getEffect() {
        return this.effect;
    }

    @Override
    public CallingConvention getOutgoingCallingConvention() {
        return this.outgoingCallingConvention;
    }

    @Override
    public CallingConvention getIncomingCallingConvention() {
        return this.incomingCallingConvention;
    }

    @Override
    public Value[] getTemporaries() {
        if (this.temporaries.length == 0) {
            return this.temporaries;
        }
        return (Value[])this.temporaries.clone();
    }

    @Override
    public long getMaxCallTargetOffset() {
        return HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getCodeCache().getMaxCallTargetOffset(this.address);
    }

    @Override
    public HotSpotForeignCallDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setCompiledStub(Stub stub) {
        assert (this.address == 0L) : "cannot set stub for linkage that already has an address: " + this;
        this.stub = stub;
    }

    @Override
    public boolean isCompiledStub() {
        return this.address == 0L || this.stub != null;
    }

    @Override
    public Stub getStub() {
        assert (this.checkStubCondition());
        return this.stub;
    }

    private boolean checkStubCondition() {
        assert (this.stub != null) : "linkage without an address must be a stub - forgot to register a Stub associated with " + this.descriptor + "?";
        return true;
    }

    private static CodeInfo getCodeInfo(Stub stub, Backend backend) {
        return new CodeInfo(stub.getCode(backend).getStart(), stub.getDestroyedCallerRegisters());
    }

    @Override
    public void finalizeAddress(Backend backend) {
        if (this.address == 0L) {
            assert (this.checkStubCondition());
            CodeInfo codeInfo = HotSpotForeignCallLinkageImpl.getCodeInfo(this.stub, backend);
            EconomicSet<Register> killedRegisters = codeInfo.killedRegisters;
            if (!killedRegisters.isEmpty()) {
                AllocatableValue[] temporaryLocations = new AllocatableValue[killedRegisters.size()];
                int i = 0;
                for (Register reg : killedRegisters) {
                    temporaryLocations[i++] = reg.asValue();
                }
                if (this.stub.getLinkage().getEffect() == HotSpotForeignCallLinkage.RegisterEffect.KILLS_NO_REGISTERS) {
                    GraalError.guarantee(temporaryLocations.length == 0, "no registers are expected to be killed: %s %s", (Object)this, (Object)temporaryLocations);
                }
                this.temporaries = temporaryLocations;
            }
            this.address = codeInfo.start;
        }
    }

    @Override
    public long getAddress() {
        assert (this.address != 0L) : "address not yet finalized: " + this;
        return this.address;
    }

    @Override
    public boolean destroysRegisters() {
        return this.effect == HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS;
    }

    @Override
    public boolean needsDebugInfo() {
        return this.descriptor.canDeoptimize();
    }

    @Override
    public boolean mayContainFP() {
        return this.descriptor.getTransition() != HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO;
    }

    @Override
    public boolean needsJavaFrameAnchor() {
        if (this.descriptor.getTransition() == HotSpotForeignCallDescriptor.Transition.SAFEPOINT || this.descriptor.getTransition() == HotSpotForeignCallDescriptor.Transition.STACK_INSPECTABLE_LEAF) {
            return this.stub == null;
        }
        return false;
    }

    @Override
    public String getSymbol() {
        return this.stub == null ? null : this.stub.toString();
    }

    @Override
    public boolean needsClearUpperVectorRegisters() {
        return this.isCompiledStub() && this.mayContainFP();
    }

    public static enum StackOnlyCallingConvention implements CallingConvention.Type
    {
        StackOnlyCall(true),
        StackOnlyCallee(false);

        public final boolean out;

        private StackOnlyCallingConvention(boolean out) {
            this.out = out;
        }

        public CallingConvention getCallingConvention(TargetDescription target, JavaType returnType, JavaType[] parameterTypes, ValueKindFactory<?> valueKindFactory) {
            ValueKind valueKind;
            AllocatableValue[] locations = new AllocatableValue[parameterTypes.length];
            int currentStackOffset = 0;
            for (int i = 0; i < parameterTypes.length; ++i) {
                JavaKind kind = parameterTypes[i].getJavaKind().getStackKind();
                switch (kind) {
                    case Illegal: 
                    case Void: {
                        throw GraalError.shouldNotReachHere(kind.toString());
                    }
                }
                valueKind = valueKindFactory.getValueKind(kind);
                locations[i] = StackSlot.get((ValueKind)valueKind, (int)currentStackOffset, (!this.out ? 1 : 0) != 0);
                currentStackOffset += Math.max(valueKind.getPlatformKind().getSizeInBytes(), target.wordSize);
            }
            JavaKind returnKind = returnType == null ? JavaKind.Void : returnType.getJavaKind();
            AllocatableValue returnLocation = Value.ILLEGAL;
            if (returnKind != JavaKind.Void) {
                valueKind = valueKindFactory.getValueKind(returnKind);
                returnLocation = StackSlot.get((ValueKind)valueKind, (int)0, (!this.out ? 1 : 0) != 0);
                int slotSize = Math.max(valueKind.getPlatformKind().getSizeInBytes(), target.wordSize);
                currentStackOffset = Math.max(currentStackOffset, slotSize);
            }
            return new CallingConvention(currentStackOffset, returnLocation, locations);
        }
    }

    public static final class CodeInfo {
        final long start;
        final EconomicSet<Register> killedRegisters;

        public CodeInfo(long start, EconomicSet<Register> killedRegisters) {
            this.start = start;
            this.killedRegisters = killedRegisters;
        }
    }
}

