/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigAccess;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.options.OptionValues;

public class GraalHotSpotVMConfig
extends GraalHotSpotVMConfigAccess {
    public static final GraalHotSpotVMConfig INJECTED_VMCONFIG = null;
    public static final MetaAccessProvider INJECTED_METAACCESS = null;
    public static final OptionValues INJECTED_OPTIONVALUES = null;
    public static final IntrinsicContext INJECTED_INTRINSIC_CONTEXT = null;
    private final CompressEncoding oopEncoding;
    private final CompressEncoding klassEncoding;
    private final String markWord = "markWord";
    public final HotSpotGraalRuntime.HotSpotGC gc = this.getSelectedGC();
    public final boolean cAssertions = this.getConstant("ASSERT", Boolean.class);
    public final int codeEntryAlignment = this.getFlag("CodeEntryAlignment", Integer.class);
    public final boolean verifyOops = this.getFlag("VerifyOops", Boolean.class);
    public final boolean dontCompileHugeMethods = this.getFlag("DontCompileHugeMethods", Boolean.class);
    public final int hugeMethodLimit = this.getFlag("HugeMethodLimit", Integer.class);
    public final boolean printInlining = this.getFlag("PrintInlining", Boolean.class);
    public final boolean inline = this.getFlag("Inline", Boolean.class);
    public final boolean useFastLocking = this.getFlag("JVMCIUseFastLocking", Boolean.class);
    public final boolean useHeavyMonitors = this.getFlag("UseHeavyMonitors", Boolean.class);
    public final boolean forceUnreachable = this.getFlag("ForceUnreachable", Boolean.class);
    public final boolean foldStableValues = this.getFlag("FoldStableValues", Boolean.class);
    public final int maxVectorSize = this.getFlag("MaxVectorSize", Integer.class);
    public final boolean verifyBeforeGC = this.getFlag("VerifyBeforeGC", Boolean.class);
    public final boolean verifyAfterGC = this.getFlag("VerifyAfterGC", Boolean.class);
    public final boolean useTLAB = this.getFlag("UseTLAB", Boolean.class);
    public final boolean useBiasedLocking = this.getFlag("UseBiasedLocking", Boolean.class, false, JDK < 18);
    public final boolean usePopCountInstruction = this.getFlag("UsePopCountInstruction", Boolean.class);
    public final boolean useUnalignedAccesses = this.getFlag("UseUnalignedAccesses", Boolean.class);
    public final boolean useCRC32Intrinsics = this.getFlag("UseCRC32Intrinsics", Boolean.class);
    public final boolean useCRC32CIntrinsics = this.getFlag("UseCRC32CIntrinsics", Boolean.class);
    private final boolean useSHA1Intrinsics = this.getFlag("UseSHA1Intrinsics", Boolean.class);
    private final boolean useSHA256Intrinsics = this.getFlag("UseSHA256Intrinsics", Boolean.class);
    private final boolean useSHA512Intrinsics = this.getFlag("UseSHA512Intrinsics", Boolean.class);
    private final boolean useMontgomeryMultiplyIntrinsic = this.getFlag("UseMontgomeryMultiplyIntrinsic", Boolean.class);
    private final boolean useMontgomerySquareIntrinsic = this.getFlag("UseMontgomerySquareIntrinsic", Boolean.class);
    public final boolean useVectorizedMismatchIntrinsic = this.getFlag("UseVectorizedMismatchIntrinsic", Boolean.class);
    public final boolean useFMAIntrinsics = this.getFlag("UseFMA", Boolean.class);
    public final int useAVX3Threshold = this.getFlag("AVX3Threshold", Integer.class, 4096, this.osArch.equals("amd64"));
    public final boolean preserveFramePointer = this.getFlag("PreserveFramePointer", Boolean.class);
    public final int diagnoseSyncOnValueBasedClasses = this.getFlag("DiagnoseSyncOnValueBasedClasses", Integer.class);
    public final int allocatePrefetchStyle = this.getFlag("AllocatePrefetchStyle", Integer.class);
    public final int allocatePrefetchInstr = this.getFlag("AllocatePrefetchInstr", Integer.class);
    public final int allocatePrefetchLines = this.getFlag("AllocatePrefetchLines", Integer.class);
    public final int allocateInstancePrefetchLines = this.getFlag("AllocateInstancePrefetchLines", Integer.class);
    public final int allocatePrefetchStepSize = this.getFlag("AllocatePrefetchStepSize", Integer.class);
    public final int allocatePrefetchDistance = this.getFlag("AllocatePrefetchDistance", Integer.class);
    private final long universeCollectedHeap = this.getFieldValue("CompilerToVM::Data::Universe_collectedHeap", Long.class, "CollectedHeap*");
    private final int collectedHeapTotalCollectionsOffset = this.getFieldOffset("CollectedHeap::_total_collections", Integer.class, "unsigned int");
    public final boolean useDeferredInitBarriers = this.getFlag("ReduceInitialCardMarks", Boolean.class);
    public final boolean useCompressedOops = this.getFlag("UseCompressedOops", Boolean.class);
    public final boolean useCompressedClassPointers = this.getFlag("UseCompressedClassPointers", Boolean.class);
    public final long narrowOopBase = this.getFieldValue("CompilerToVM::Data::Universe_narrow_oop_base", Long.class, "address");
    public final int narrowOopShift = this.getFieldValue("CompilerToVM::Data::Universe_narrow_oop_shift", Integer.class, "int");
    public final int objectAlignment = this.getFlag("ObjectAlignmentInBytes", Integer.class);
    public final int narrowKlassSize = this.getFieldValue("CompilerToVM::Data::sizeof_narrowKlass", Integer.class, "int");
    public final long narrowKlassBase = this.getFieldValue("CompilerToVM::Data::Universe_narrow_klass_base", Long.class, "address");
    public final int narrowKlassShift = this.getFieldValue("CompilerToVM::Data::Universe_narrow_klass_shift", Integer.class, "int");
    public final int logKlassAlignment = this.getConstant("LogKlassAlignmentInBytes", Integer.class);
    public final int stackShadowPages = this.getFlag("StackShadowPages", Integer.class);
    public final int vmPageSize = this.getFieldValue("CompilerToVM::Data::vm_page_size", Integer.class, JDK >= 21 ? "size_t" : "int");
    public final int markOffset = this.getFieldOffset("oopDesc::_mark", Integer.class, "markWord");
    public final int hubOffset = this.getFieldOffset("oopDesc::_metadata._klass", Integer.class, "Klass*");
    public final Integer prototypeMarkWordOffset = this.getFieldOffset("Klass::_prototype_header", Integer.class, "markWord", null, JDK < 18);
    public final int superCheckOffsetOffset = this.getFieldOffset("Klass::_super_check_offset", Integer.class, "juint");
    public final int secondarySuperCacheOffset = this.getFieldOffset("Klass::_secondary_super_cache", Integer.class, "Klass*");
    public final int secondarySupersOffset = this.getFieldOffset("Klass::_secondary_supers", Integer.class, "Array<Klass*>*");
    public final int classMirrorOffset = this.getFieldOffset("Klass::_java_mirror", Integer.class, "OopHandle");
    public final int klassSuperKlassOffset = this.getFieldOffset("Klass::_super", Integer.class, "Klass*");
    public final int klassModifierFlagsOffset = this.getFieldOffset("Klass::_modifier_flags", Integer.class, "jint");
    public final int klassAccessFlagsOffset = this.getFieldOffset("Klass::_access_flags", Integer.class, "AccessFlags");
    public final int klassLayoutHelperOffset = this.getFieldOffset("Klass::_layout_helper", Integer.class, "jint");
    public final int klassLayoutHelperNeutralValue = this.getConstant("Klass::_lh_neutral_value", Integer.class);
    public final int layoutHelperLog2ElementSizeShift = this.getConstant("Klass::_lh_log2_element_size_shift", Integer.class);
    public final int layoutHelperLog2ElementSizeMask = this.getConstant("Klass::_lh_log2_element_size_mask", Integer.class);
    public final int layoutHelperHeaderSizeShift = this.getConstant("Klass::_lh_header_size_shift", Integer.class);
    public final int layoutHelperHeaderSizeMask = this.getConstant("Klass::_lh_header_size_mask", Integer.class);
    public final int instanceKlassInitStateOffset = this.getFieldOffset("InstanceKlass::_init_state", Integer.class, JDK >= 20 ? "InstanceKlass::ClassState" : "u1");
    public final int instanceKlassInitThreadOffset = this.getFieldOffset("InstanceKlass::_init_thread", Integer.class, "Thread*");
    public final int instanceKlassStateBeingInitialized = this.getConstant("InstanceKlass::being_initialized", Integer.class);
    public final int instanceKlassStateFullyInitialized = this.getConstant("InstanceKlass::fully_initialized", Integer.class);
    public final int arrayOopDescSize = this.getFieldValue("CompilerToVM::Data::sizeof_arrayOopDesc", Integer.class, "int");
    public final int metaspaceArrayLengthOffset = this.getFieldOffset("Array<Klass*>::_length", Integer.class, "int");
    public final int metaspaceArrayBaseOffset = this.getFieldOffset("Array<Klass*>::_data[0]", Integer.class, "Klass*");
    public final int arrayClassElementOffset = this.getFieldOffset("ObjArrayKlass::_element_klass", Integer.class, "Klass*");
    public final int jvmAccHasFinalizer = this.getConstant("JVM_ACC_HAS_FINALIZER", Integer.class);
    public final int jvmAccWrittenFlags = this.getConstant("JVM_ACC_WRITTEN_FLAGS", Integer.class);
    public final int jvmAccIsHiddenClass = this.getConstant("JVM_ACC_IS_HIDDEN_CLASS", Integer.class);
    public final int jvmAccIsValueBasedClass = this.verifyConstant("JVM_ACC_IS_VALUE_BASED_CLASS", Integer.class, 0x8000000);
    public final int jvmciCompileStateCanPostOnExceptionsOffset = this.getJvmciJvmtiCapabilityOffset("_jvmti_can_post_on_exceptions");
    public final int jvmciCompileStateCanPopFrameOffset = this.getJvmciJvmtiCapabilityOffset("_jvmti_can_pop_frame");
    public final int jvmciCompileStateCanAccessLocalVariablesOffset = this.getJvmciJvmtiCapabilityOffset("_jvmti_can_access_local_variables");
    public final int threadTlabOffset = this.getFieldOffset("Thread::_tlab", Integer.class, "ThreadLocalAllocBuffer");
    public final int javaThreadAnchorOffset = this.getFieldOffset("JavaThread::_anchor", Integer.class, "JavaFrameAnchor");
    public final int javaThreadShouldPostOnExceptionsFlagOffset = this.getFieldOffset("JavaThread::_should_post_on_exceptions_flag", Integer.class, "int");
    public final int threadCurrentThreadObjectOffset = JDK < 19 ? this.getFieldOffset("JavaThread::_threadObj", Integer.class, "OopHandle").intValue() : this.getFieldOffset("JavaThread::_vthread", Integer.class, "OopHandle").intValue();
    public final int threadCarrierThreadObjectOffset = this.getFieldOffset("JavaThread::_threadObj", Integer.class, "OopHandle");
    public final int threadScopedValueCacheOffset = this.getFieldOffset("JavaThread::_scopedValueCache", Integer.class, "OopHandle", -1, JDK >= 20 && (!JVMCI || GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b06)));
    public final int javaLangThreadJFREpochOffset = this.getFieldValue("java_lang_Thread::_jfr_epoch_offset", Integer.class, "int", -1, JDK >= 21 || JDK >= 20 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b10));
    public final int javaLangThreadTIDOffset = this.getFieldValue("java_lang_Thread::_tid_offset", Integer.class, "int", -1, JDK >= 21 || JDK >= 20 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b10));
    public final int threadJFRThreadLocalOffset = this.getFieldOffset("Thread::_jfr_thread_local", Integer.class, "JfrThreadLocal", -1, JDK >= 21 || JDK >= 20 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b10));
    public final int jfrThreadLocalVthreadIDOffset = this.getFieldOffset("JfrThreadLocal::_vthread_id", Integer.class, "traceid", -1, JDK >= 21 || JDK >= 20 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b10));
    public final int jfrThreadLocalVthreadEpochOffset = this.getFieldOffset("JfrThreadLocal::_vthread_epoch", Integer.class, "u2", -1, JDK >= 21 || JDK >= 20 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b10));
    public final int jfrThreadLocalVthreadExcludedOffset = this.getFieldOffset("JfrThreadLocal::_vthread_excluded", Integer.class, "bool", -1, JDK >= 21 || JDK >= 20 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b10));
    public final int jfrThreadLocalVthreadOffset = this.getFieldOffset("JfrThreadLocal::_vthread", Integer.class, "bool", -1, JDK >= 21 || JDK >= 20 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b10));
    public final int osThreadOffset = this.getFieldOffset("JavaThread::_osthread", Integer.class, "OSThread*");
    public final int threadObjectResultOffset = this.getFieldOffset("JavaThread::_vm_result", Integer.class, "oop");
    public final int jvmciCountersThreadOffset = this.getFieldOffset("JavaThread::_jvmci_counters", Integer.class, "jlong*");
    public final int jvmciReserved0Offset;
    public final int jvmciReservedReference0Offset;
    public final int doingUnsafeAccessOffset;
    public final int javaThreadReservedStackActivationOffset;
    public final int jniEnvironmentOffset;
    public final int threadExceptionOopOffset;
    public final int threadExceptionPcOffset;
    public final int pendingExceptionOffset;
    public final int pendingDeoptimizationOffset;
    public final int pendingTransferToInterpreterOffset;
    private final int javaFrameAnchorLastJavaSpOffset;
    private final int javaFrameAnchorLastJavaPcOffset;
    public final int pendingFailedSpeculationOffset;
    public final int frameInterpreterFrameSenderSpOffset;
    public final int frameInterpreterFrameLastSpOffset;
    private final Integer biasedLockMaskInPlace;
    private final Integer lockMaskInPlace;
    public final int ageMaskInPlace;
    public final Integer epochMaskInPlace;
    public final int unlockedMask;
    public final int monitorMask;
    public final Integer biasedLockPattern;
    public final int objectMonitorOwner;
    public final int objectMonitorRecursions;
    public final int objectMonitorCxq;
    public final int objectMonitorEntryList;
    public final int objectMonitorSucc;
    public final int markWordNoHashInPlace;
    public final int markWordNoLockInPlace;
    public final int identityHashCodeShift;
    public final int uninitializedIdentityHashCodeValue;
    public final int methodCompiledEntryOffset;
    public final int invocationCounterOffset;
    public final int backedgeCounterOffset;
    public final int invocationCounterIncrement;
    public final int invocationCounterShift;
    public final int compilationLevelFullOptimization;
    public final int heapWordSize;
    public final long nonOopBits;
    public final long verifyOopCounterAddress;
    public final long verifyOopMask;
    public final long verifyOopBits;
    public final int logOfHRGrainBytes;
    public final int cardtableShift;
    public final long cardtableStartAddress;
    public final int maxOopMapStackOffset;
    public final byte dirtyCardValue;
    public final byte g1YoungCardValue;
    public final int g1SATBQueueMarkingActiveOffset;
    public final int g1SATBQueueIndexOffset;
    public final int g1SATBQueueBufferOffset;
    public final int g1CardQueueIndexOffset;
    public final int g1CardQueueBufferOffset;
    public final int klassOffset;
    public final int arrayKlassOffset;
    public final int basicLockSize;
    public final int basicLockDisplacedHeaderOffset;
    private final boolean zgcSupport;
    public final int threadPollingPageOffset;
    public final int threadPollingWordOffset;
    public final int savedExceptionPCOffset;
    private final int threadLocalAllocBufferEndOffset;
    private final int threadLocalAllocBufferTopOffset;
    public final int psrInfoDczidValue;
    public final int zvaLength;
    public final long inlineCacheMissStub;
    public final long handleWrongMethodStub;
    public final long deoptBlobUnpack;
    public final long deoptBlobUnpackWithExceptionInTLS;
    public final long pollingPageReturnHandler;
    public final long deoptBlobUncommonTrap;
    public final long codeCacheLowBound;
    public final long codeCacheHighBound;
    public final long updateBytesCRC32Stub;
    public final long crcTableAddress;
    public final long md5ImplCompress;
    public final long md5ImplCompressMultiBlock;
    public final long sha1ImplCompress;
    public final long sha1ImplCompressMultiBlock;
    public final long sha256ImplCompress;
    public final long sha256ImplCompressMultiBlock;
    public final long sha512ImplCompress;
    public final long sha512ImplCompressMultiBlock;
    public final long sha3ImplCompress;
    public final long sha3ImplCompressMultiBlock;
    public final long base64EncodeBlock;
    public final long base64DecodeBlock;
    public final long crc32cTableTddr;
    public final long updateBytesCRC32C;
    public final long updateBytesAdler32;
    public final long montgomeryMultiply;
    public final long montgomerySquare;
    public final long bigIntegerLeftShiftWorker;
    public final long bigIntegerRightShiftWorker;
    public final long electronicCodeBookEncrypt;
    public final long electronicCodeBookDecrypt;
    public final long galoisCounterModeCrypt;
    public final long poly1305ProcessBlocks;
    public final long chacha20Block;
    public final long throwDelayedStackOverflowErrorEntry;
    public final long jbyteArraycopy;
    public final long jshortArraycopy;
    public final long jintArraycopy;
    public final long jlongArraycopy;
    public final long oopArraycopy;
    public final long oopArraycopyUninit;
    public final long jbyteDisjointArraycopy;
    public final long jshortDisjointArraycopy;
    public final long jintDisjointArraycopy;
    public final long jlongDisjointArraycopy;
    public final long oopDisjointArraycopy;
    public final long oopDisjointArraycopyUninit;
    public final long jbyteAlignedArraycopy;
    public final long jshortAlignedArraycopy;
    public final long jintAlignedArraycopy;
    public final long jlongAlignedArraycopy;
    public final long oopAlignedArraycopy;
    public final long oopAlignedArraycopyUninit;
    public final long jbyteAlignedDisjointArraycopy;
    public final long jshortAlignedDisjointArraycopy;
    public final long jintAlignedDisjointArraycopy;
    public final long jlongAlignedDisjointArraycopy;
    public final long oopAlignedDisjointArraycopy;
    public final long oopAlignedDisjointArraycopyUninit;
    public final long checkcastArraycopy;
    public final long checkcastArraycopyUninit;
    public final long unsafeArraycopy;
    public final long genericArraycopy;
    public final long newInstanceAddress;
    public final long newArrayAddress;
    public final long newMultiArrayAddress;
    public final long dynamicNewInstanceAddress;
    public final long newInstanceOrNullAddress;
    public final long newArrayOrNullAddress;
    public final long newMultiArrayOrNullAddress;
    public final long dynamicNewInstanceOrNullAddress;
    public final long invokeJavaMethodAddress;
    public final long vmMessageAddress;
    public final long identityHashCodeAddress;
    public final long exceptionHandlerForPcAddress;
    public final long monitorenterAddress;
    public final long monitorexitAddress;
    public final long notifyAddress;
    public final long notifyAllAddress;
    public final boolean continuationsEnabled;
    public final int threadDisarmedOffset;
    public final long nmethodEntryBarrier;
    public final int threadAddressBadMaskOffset;
    public final long zBarrierSetRuntimeLoadBarrierOnOopFieldPreloaded;
    public final long zBarrierSetRuntimeLoadBarrierOnWeakOopFieldPreloaded;
    public final long zBarrierSetRuntimeWeakLoadBarrierOnWeakOopFieldPreloaded;
    public final long zBarrierSetRuntimeWeakLoadBarrierOnPhantomOopFieldPreloaded;
    public final long zBarrierSetRuntimeLoadBarrierOnOopArray;
    public final Boolean nmethodEntryBarrierConcurrentPatch;
    public final int threadHeldMonitorCountOffset;
    public final boolean threadHeldMonitorCountIsWord;
    public final boolean updateHeldMonitorCount;
    public final long throwAndPostJvmtiExceptionAddress;
    public final long throwKlassExternalNameExceptionAddress;
    public final long throwClassCastExceptionAddress;
    public final long logPrimitiveAddress;
    public final long logObjectAddress;
    public final long logPrintfAddress;
    public final long vmErrorAddress;
    public final long loadAndClearExceptionAddress;
    public final long writeBarrierPreAddress;
    public final long writeBarrierPostAddress;
    public final long validateObject;
    public final long testDeoptimizeCallInt;
    public final long registerFinalizerAddress;
    public final long exceptionHandlerForReturnAddressAddress;
    public final long osrMigrationEndAddress;
    public final long enableStackReservedZoneAddress;
    public final long javaTimeMillisAddress;
    public final long javaTimeNanosAddress;
    public final long arithmeticSinAddress;
    public final long arithmeticCosAddress;
    public final long arithmeticTanAddress;
    public final long arithmeticExpAddress;
    public final long arithmeticLogAddress;
    public final long arithmeticLog10Address;
    public final long arithmeticPowAddress;
    public final long fremAddress;
    public final long dremAddress;
    public final int jvmciCountersSize;
    public final boolean deoptimizationSupportLargeAccessByteArrayVirtualization;
    public final int VMINTRINSIC_FIRST_MH_SIG_POLY;
    public final int VMINTRINSIC_LAST_MH_SIG_POLY;
    public final int VMINTRINSIC_INVOKE_GENERIC;
    public final int VMINTRINSIC_COMPILED_LAMBDA_FORM;
    public final boolean CPU_HAS_INTEL_JCC_ERRATUM;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    GraalHotSpotVMConfig(HotSpotVMConfigStore store) {
        super(store);
        int offset;
        try {
            offset = this.getFieldOffset("JavaThread::_jvmci_reserved0", Integer.class, "jlong");
        }
        catch (JVMCIError t) {
            offset = this.getFieldOffset("JavaThread::_jvmci_reserved0", Integer.class, "intptr_t*");
        }
        this.jvmciReserved0Offset = offset;
        this.jvmciReservedReference0Offset = this.getFieldOffset("JavaThread::_jvmci_reserved_oop0", Integer.class, "oop");
        this.doingUnsafeAccessOffset = this.getFieldOffset("JavaThread::_doing_unsafe_access", Integer.class, "bool");
        this.javaThreadReservedStackActivationOffset = JDK <= 15 ? this.getFieldOffset("JavaThread::_reserved_stack_activation", Integer.class, "address").intValue() : this.getFieldOffset("JavaThread::_stack_overflow_state._reserved_stack_activation", Integer.class, "address").intValue();
        this.jniEnvironmentOffset = this.getFieldOffset("JavaThread::_jni_environment", Integer.class, "JNIEnv");
        this.threadExceptionOopOffset = this.getFieldOffset("JavaThread::_exception_oop", Integer.class, "oop");
        this.threadExceptionPcOffset = this.getFieldOffset("JavaThread::_exception_pc", Integer.class, "address");
        this.pendingExceptionOffset = this.getFieldOffset("ThreadShadow::_pending_exception", Integer.class, "oop");
        this.pendingDeoptimizationOffset = this.getFieldOffset("JavaThread::_pending_deoptimization", Integer.class, "int");
        this.pendingTransferToInterpreterOffset = this.getFieldOffset("JavaThread::_pending_transfer_to_interpreter", Integer.class, "bool");
        this.javaFrameAnchorLastJavaSpOffset = this.getFieldOffset("JavaFrameAnchor::_last_Java_sp", Integer.class, "intptr_t*");
        this.javaFrameAnchorLastJavaPcOffset = this.getFieldOffset("JavaFrameAnchor::_last_Java_pc", Integer.class, "address");
        String name = "JavaThread::_pending_failed_speculation";
        int offset2 = -1;
        try {
            offset2 = this.getFieldOffset(name, Integer.class, "jlong");
        }
        catch (JVMCIError e) {
            try {
                offset2 = this.getFieldOffset(name, Integer.class, "long");
            }
            catch (JVMCIError jVMCIError) {
                // empty catch block
            }
        }
        if (offset2 == -1) {
            throw new JVMCIError("cannot get offset of field " + name + " with type long or jlong");
        }
        this.pendingFailedSpeculationOffset = offset2;
        this.frameInterpreterFrameSenderSpOffset = this.getConstant("frame::interpreter_frame_sender_sp_offset", Integer.class, 0, this.osArch.equals("amd64"));
        this.frameInterpreterFrameLastSpOffset = this.getConstant("frame::interpreter_frame_last_sp_offset", Integer.class, 0, this.osArch.equals("amd64"));
        this.biasedLockMaskInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("biased_lock_mask_in_place"), Integer.class, null, JDK < 18);
        this.lockMaskInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("lock_mask_in_place"), Integer.class, null, JDK == 20 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b12));
        this.ageMaskInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("age_mask_in_place"), Integer.class);
        this.epochMaskInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("epoch_mask_in_place"), Integer.class, null, JDK < 18);
        this.unlockedMask = this.getConstant(GraalHotSpotVMConfig.markWordField("unlocked_value"), Integer.class);
        this.monitorMask = this.getConstant(GraalHotSpotVMConfig.markWordField("monitor_value"), Integer.class);
        this.biasedLockPattern = this.getConstant(GraalHotSpotVMConfig.markWordField("biased_lock_pattern"), Integer.class, null, JDK < 18);
        this.objectMonitorOwner = this.getFieldOffset("ObjectMonitor::_owner", Integer.class, null);
        this.objectMonitorRecursions = this.getFieldOffset("ObjectMonitor::_recursions", Integer.class, "intptr_t");
        this.objectMonitorCxq = this.getFieldOffset("ObjectMonitor::_cxq", Integer.class, "ObjectWaiter*");
        this.objectMonitorEntryList = this.getFieldOffset("ObjectMonitor::_EntryList", Integer.class, "ObjectWaiter*");
        this.objectMonitorSucc = this.getFieldOffset("ObjectMonitor::_succ", Integer.class, "JavaThread*");
        this.markWordNoHashInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("no_hash_in_place"), Integer.class);
        this.markWordNoLockInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("no_lock_in_place"), Integer.class);
        this.identityHashCodeShift = this.getConstant(GraalHotSpotVMConfig.markWordField("hash_shift"), Integer.class);
        this.uninitializedIdentityHashCodeValue = this.getConstant(GraalHotSpotVMConfig.markWordField("no_hash"), Integer.class);
        this.methodCompiledEntryOffset = this.getFieldOffset("Method::_from_compiled_entry", Integer.class, "address");
        this.invocationCounterOffset = this.getFieldOffset("MethodCounters::_invocation_counter", Integer.class, "InvocationCounter");
        this.backedgeCounterOffset = this.getFieldOffset("MethodCounters::_backedge_counter", Integer.class, "InvocationCounter");
        this.invocationCounterIncrement = this.getConstant("InvocationCounter::count_increment", Integer.class);
        this.invocationCounterShift = this.getConstant("InvocationCounter::count_shift", Integer.class);
        this.compilationLevelFullOptimization = this.getConstant("CompLevel_full_optimization", Integer.class);
        this.heapWordSize = this.getConstant("HeapWordSize", Integer.class);
        this.nonOopBits = this.getFieldValue("CompilerToVM::Data::Universe_non_oop_bits", Long.class, "void*");
        this.verifyOopCounterAddress = this.getFieldAddress("StubRoutines::_verify_oop_count", "jint");
        this.verifyOopMask = this.getFieldValue("CompilerToVM::Data::Universe_verify_oop_mask", Long.class, "uintptr_t");
        this.verifyOopBits = this.getFieldValue("CompilerToVM::Data::Universe_verify_oop_bits", Long.class, "uintptr_t");
        this.logOfHRGrainBytes = this.getFieldValue("HeapRegion::LogOfHRGrainBytes", Integer.class, "int");
        this.cardtableShift = this.getFieldValue("CompilerToVM::Data::cardtable_shift", Integer.class, "int");
        this.cardtableStartAddress = JDK < 15 ? this.getFieldValue("CompilerToVM::Data::cardtable_start_address", Long.class, "jbyte*").longValue() : this.getFieldValue("CompilerToVM::Data::cardtable_start_address", Long.class, "CardTable::CardValue*").longValue();
        this.maxOopMapStackOffset = this.getFieldValue("CompilerToVM::Data::_max_oop_map_stack_offset", Integer.class, "int");
        this.dirtyCardValue = this.getConstant("CardTable::dirty_card", Byte.class);
        this.g1YoungCardValue = this.getConstant("G1CardTable::g1_young_gen", Byte.class);
        this.g1SATBQueueMarkingActiveOffset = this.getConstant("G1ThreadLocalData::satb_mark_queue_active_offset", Integer.class);
        this.g1SATBQueueIndexOffset = this.getConstant("G1ThreadLocalData::satb_mark_queue_index_offset", Integer.class);
        this.g1SATBQueueBufferOffset = this.getConstant("G1ThreadLocalData::satb_mark_queue_buffer_offset", Integer.class);
        this.g1CardQueueIndexOffset = this.getConstant("G1ThreadLocalData::dirty_card_queue_index_offset", Integer.class);
        this.g1CardQueueBufferOffset = this.getConstant("G1ThreadLocalData::dirty_card_queue_buffer_offset", Integer.class);
        this.klassOffset = this.getFieldValue("java_lang_Class::_klass_offset", Integer.class, "int");
        this.arrayKlassOffset = this.getFieldValue("java_lang_Class::_array_klass_offset", Integer.class, "int");
        this.basicLockSize = this.getFieldValue("CompilerToVM::Data::sizeof_BasicLock", Integer.class, "int");
        this.basicLockDisplacedHeaderOffset = this.getFieldOffset("BasicLock::_displaced_header", Integer.class, "markWord");
        boolean support = false;
        support = JDK == 19 ? JVMCI && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b05) : (JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b07) : JDK >= 20);
        this.zgcSupport = support;
        this.threadPollingPageOffset = this.getFieldOffset("JavaThread::_poll_data", Integer.class, "SafepointMechanism::ThreadData") + this.getFieldOffset("SafepointMechanism::ThreadData::_polling_page", Integer.class, "volatile uintptr_t");
        this.threadPollingWordOffset = this.getFieldOffset("JavaThread::_poll_data", Integer.class, "SafepointMechanism::ThreadData") + this.getFieldOffset("SafepointMechanism::ThreadData::_polling_word", Integer.class, "volatile uintptr_t");
        this.savedExceptionPCOffset = this.getFieldOffset("JavaThread::_saved_exception_pc", Integer.class, "address", -1, this.zgcSupport);
        this.threadLocalAllocBufferEndOffset = this.getFieldOffset("ThreadLocalAllocBuffer::_end", Integer.class, "HeapWord*");
        this.threadLocalAllocBufferTopOffset = this.getFieldOffset("ThreadLocalAllocBuffer::_top", Integer.class, "HeapWord*");
        this.psrInfoDczidValue = (Integer)this.access.getFieldValue("VM_Version::_psr_info.dczid_el0", Integer.class, "uint32_t", (Object)16);
        this.zvaLength = (Integer)this.access.getFieldValue("VM_Version::_zva_length", Integer.class, "int", (Object)Integer.MAX_VALUE);
        this.inlineCacheMissStub = this.getFieldValue("CompilerToVM::Data::SharedRuntime_ic_miss_stub", Long.class, "address");
        this.handleWrongMethodStub = this.getFieldValue("CompilerToVM::Data::SharedRuntime_handle_wrong_method_stub", Long.class, "address");
        this.deoptBlobUnpack = this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_unpack", Long.class, "address");
        this.deoptBlobUnpackWithExceptionInTLS = this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_unpack_with_exception_in_tls", Long.class, "address");
        this.pollingPageReturnHandler = this.getFieldValue("CompilerToVM::Data::SharedRuntime_polling_page_return_handler", Long.class, "address", 0L, this.zgcSupport);
        this.deoptBlobUncommonTrap = this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_uncommon_trap", Long.class, "address");
        this.codeCacheLowBound = this.getFieldValue("CodeCache::_low_bound", Long.class, "address");
        this.codeCacheHighBound = this.getFieldValue("CodeCache::_high_bound", Long.class, "address");
        this.updateBytesCRC32Stub = this.getFieldValue("StubRoutines::_updateBytesCRC32", Long.class, "address");
        this.crcTableAddress = this.getFieldValue("StubRoutines::_crc_table_adr", Long.class, "address");
        this.md5ImplCompress = this.getFieldValue("StubRoutines::_md5_implCompress", Long.class, "address", 0L, JVMCI ? JDK >= 17 : JDK >= 19);
        this.md5ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_md5_implCompressMB", Long.class, "address", 0L, JVMCI ? JDK >= 17 : JDK >= 19);
        this.sha1ImplCompress = this.getFieldValue("StubRoutines::_sha1_implCompress", Long.class, "address");
        this.sha1ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha1_implCompressMB", Long.class, "address");
        this.sha256ImplCompress = this.getFieldValue("StubRoutines::_sha256_implCompress", Long.class, "address");
        this.sha256ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha256_implCompressMB", Long.class, "address");
        this.sha512ImplCompress = this.getFieldValue("StubRoutines::_sha512_implCompress", Long.class, "address");
        this.sha512ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha512_implCompressMB", Long.class, "address");
        this.sha3ImplCompress = this.getFieldValue("StubRoutines::_sha3_implCompress", Long.class, "address", 0L, JVMCI ? JDK >= 17 : JDK >= 19);
        this.sha3ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha3_implCompressMB", Long.class, "address", 0L, JVMCI ? JDK >= 17 : JDK >= 19);
        this.base64EncodeBlock = this.getFieldValue("StubRoutines::_base64_encodeBlock", Long.class, "address");
        this.base64DecodeBlock = this.getFieldValue("StubRoutines::_base64_decodeBlock", Long.class, "address");
        this.crc32cTableTddr = this.getFieldValue("StubRoutines::_crc32c_table_addr", Long.class, "address");
        this.updateBytesCRC32C = this.getFieldValue("StubRoutines::_updateBytesCRC32C", Long.class, "address");
        this.updateBytesAdler32 = this.getFieldValue("StubRoutines::_updateBytesAdler32", Long.class, "address");
        this.montgomeryMultiply = this.getFieldValue("StubRoutines::_montgomeryMultiply", Long.class, "address");
        this.montgomerySquare = this.getFieldValue("StubRoutines::_montgomerySquare", Long.class, "address");
        this.bigIntegerLeftShiftWorker = this.getFieldValue("StubRoutines::_bigIntegerLeftShiftWorker", Long.class, "address");
        this.bigIntegerRightShiftWorker = this.getFieldValue("StubRoutines::_bigIntegerRightShiftWorker", Long.class, "address");
        this.electronicCodeBookEncrypt = this.getFieldValue("StubRoutines::_electronicCodeBook_encryptAESCrypt", Long.class, "address");
        this.electronicCodeBookDecrypt = this.getFieldValue("StubRoutines::_electronicCodeBook_decryptAESCrypt", Long.class, "address");
        this.galoisCounterModeCrypt = this.getFieldValue("StubRoutines::_galoisCounterMode_AESCrypt", Long.class, "address", 0L, JDK >= 20 || JDK >= 19 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b05));
        this.poly1305ProcessBlocks = this.getFieldValue("StubRoutines::_poly1305_processBlocks", Long.class, "address", 0L, JDK >= 21 || JDK >= 20 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b10));
        this.chacha20Block = this.getFieldValue("StubRoutines::_chacha20Block", Long.class, "address", 0L, JVMCI ? JDK >= 20 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b05) : JDK >= 21);
        this.throwDelayedStackOverflowErrorEntry = this.getFieldValue("StubRoutines::_throw_delayed_StackOverflowError_entry", Long.class, "address");
        this.jbyteArraycopy = this.getFieldValue("StubRoutines::_jbyte_arraycopy", Long.class, "address");
        this.jshortArraycopy = this.getFieldValue("StubRoutines::_jshort_arraycopy", Long.class, "address");
        this.jintArraycopy = this.getFieldValue("StubRoutines::_jint_arraycopy", Long.class, "address");
        this.jlongArraycopy = this.getFieldValue("StubRoutines::_jlong_arraycopy", Long.class, "address");
        this.oopArraycopy = this.getFieldValue("StubRoutines::_oop_arraycopy", Long.class, "address");
        this.oopArraycopyUninit = this.getFieldValue("StubRoutines::_oop_arraycopy_uninit", Long.class, "address");
        this.jbyteDisjointArraycopy = this.getFieldValue("StubRoutines::_jbyte_disjoint_arraycopy", Long.class, "address");
        this.jshortDisjointArraycopy = this.getFieldValue("StubRoutines::_jshort_disjoint_arraycopy", Long.class, "address");
        this.jintDisjointArraycopy = this.getFieldValue("StubRoutines::_jint_disjoint_arraycopy", Long.class, "address");
        this.jlongDisjointArraycopy = this.getFieldValue("StubRoutines::_jlong_disjoint_arraycopy", Long.class, "address");
        this.oopDisjointArraycopy = this.getFieldValue("StubRoutines::_oop_disjoint_arraycopy", Long.class, "address");
        this.oopDisjointArraycopyUninit = this.getFieldValue("StubRoutines::_oop_disjoint_arraycopy_uninit", Long.class, "address");
        this.jbyteAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jbyte_arraycopy", Long.class, "address");
        this.jshortAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jshort_arraycopy", Long.class, "address");
        this.jintAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jint_arraycopy", Long.class, "address");
        this.jlongAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jlong_arraycopy", Long.class, "address");
        this.oopAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_oop_arraycopy", Long.class, "address");
        this.oopAlignedArraycopyUninit = this.getFieldValue("StubRoutines::_arrayof_oop_arraycopy_uninit", Long.class, "address");
        this.jbyteAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jbyte_disjoint_arraycopy", Long.class, "address");
        this.jshortAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jshort_disjoint_arraycopy", Long.class, "address");
        this.jintAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jint_disjoint_arraycopy", Long.class, "address");
        this.jlongAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jlong_disjoint_arraycopy", Long.class, "address");
        this.oopAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_oop_disjoint_arraycopy", Long.class, "address");
        this.oopAlignedDisjointArraycopyUninit = this.getFieldValue("StubRoutines::_arrayof_oop_disjoint_arraycopy_uninit", Long.class, "address");
        this.checkcastArraycopy = this.getFieldValue("StubRoutines::_checkcast_arraycopy", Long.class, "address");
        this.checkcastArraycopyUninit = this.getFieldValue("StubRoutines::_checkcast_arraycopy_uninit", Long.class, "address");
        this.unsafeArraycopy = this.getFieldValue("StubRoutines::_unsafe_arraycopy", Long.class, "address");
        this.genericArraycopy = this.getFieldValue("StubRoutines::_generic_arraycopy", Long.class, "address");
        this.newInstanceAddress = this.getAddress("JVMCIRuntime::new_instance");
        this.newArrayAddress = this.getAddress("JVMCIRuntime::new_array");
        this.newMultiArrayAddress = this.getAddress("JVMCIRuntime::new_multi_array");
        this.dynamicNewInstanceAddress = this.getAddress("JVMCIRuntime::dynamic_new_instance");
        this.newInstanceOrNullAddress = this.getAddress("JVMCIRuntime::new_instance_or_null");
        this.newArrayOrNullAddress = this.getAddress("JVMCIRuntime::new_array_or_null");
        this.newMultiArrayOrNullAddress = this.getAddress("JVMCIRuntime::new_multi_array_or_null");
        this.dynamicNewInstanceOrNullAddress = this.getAddress("JVMCIRuntime::dynamic_new_instance_or_null");
        this.invokeJavaMethodAddress = this.getAddress("JVMCIRuntime::invoke_static_method_one_arg");
        this.vmMessageAddress = this.getAddress("JVMCIRuntime::vm_message");
        this.identityHashCodeAddress = this.getAddress("JVMCIRuntime::identity_hash_code");
        this.exceptionHandlerForPcAddress = this.getAddress("JVMCIRuntime::exception_handler_for_pc");
        this.monitorenterAddress = this.getAddress("JVMCIRuntime::monitorenter");
        this.monitorexitAddress = this.getAddress("JVMCIRuntime::monitorexit");
        this.notifyAddress = this.getAddress("JVMCIRuntime::object_notify");
        this.notifyAllAddress = this.getAddress("JVMCIRuntime::object_notifyAll");
        this.continuationsEnabled = this.getFieldValue("CompilerToVM::Data::continuations_enabled", Boolean.class, "bool", JDK > 19, JDK >= 19 && GraalHotSpotVMConfig.jvmciGE(JVMCI_23_0_b04));
        this.threadDisarmedOffset = this.getFieldValue("CompilerToVM::Data::thread_disarmed_offset", Integer.class, "int", 0, this.zgcSupport);
        this.nmethodEntryBarrier = this.getFieldValue("CompilerToVM::Data::nmethod_entry_barrier", Long.class, "address", 0L, this.zgcSupport);
        this.threadAddressBadMaskOffset = this.getFieldValue("CompilerToVM::Data::thread_address_bad_mask_offset", Integer.class, "int", 0, this.zgcSupport);
        this.zBarrierSetRuntimeLoadBarrierOnOopFieldPreloaded = this.getZGCAddressField("CompilerToVM::Data::ZBarrierSetRuntime_load_barrier_on_oop_field_preloaded");
        this.zBarrierSetRuntimeLoadBarrierOnWeakOopFieldPreloaded = this.getZGCAddressField("CompilerToVM::Data::ZBarrierSetRuntime_load_barrier_on_weak_oop_field_preloaded");
        this.zBarrierSetRuntimeWeakLoadBarrierOnWeakOopFieldPreloaded = this.getZGCAddressField("CompilerToVM::Data::ZBarrierSetRuntime_weak_load_barrier_on_weak_oop_field_preloaded");
        this.zBarrierSetRuntimeWeakLoadBarrierOnPhantomOopFieldPreloaded = this.getZGCAddressField("CompilerToVM::Data::ZBarrierSetRuntime_weak_load_barrier_on_phantom_oop_field_preloaded");
        this.zBarrierSetRuntimeLoadBarrierOnOopArray = this.getZGCAddressField("CompilerToVM::Data::ZBarrierSetRuntime_load_barrier_on_oop_array");
        Boolean patchConcurrent = null;
        if (this.osArch.equals("aarch64") && this.nmethodEntryBarrier != 0L) {
            if (JDK >= 20) {
                Integer patchingType = this.getFieldValue("CompilerToVM::Data::BarrierSetAssembler_nmethod_patching_type", Integer.class, "int");
                if (patchingType != null) {
                    int stw = this.getConstant("NMethodPatchingType::stw_instruction_and_data_patch", Integer.class);
                    int conc = this.getConstant("NMethodPatchingType::conc_data_patch", Integer.class);
                    if (patchingType == stw) {
                        patchConcurrent = false;
                    } else {
                        if (patchingType != conc) throw new IllegalArgumentException("unsupported barrier sequence " + patchingType);
                        patchConcurrent = true;
                    }
                }
            } else {
                patchConcurrent = true;
            }
        }
        this.nmethodEntryBarrierConcurrentPatch = patchConcurrent;
        offset = -1;
        boolean isWord = false;
        if (JDK >= 20) {
            offset = this.getFieldOffset("JavaThread::_held_monitor_count", Integer.class, "int64_t");
            isWord = true;
        }
        this.threadHeldMonitorCountOffset = offset;
        this.threadHeldMonitorCountIsWord = isWord;
        this.updateHeldMonitorCount = JDK >= 20 || this.continuationsEnabled;
        this.throwAndPostJvmtiExceptionAddress = this.getAddress("JVMCIRuntime::throw_and_post_jvmti_exception");
        this.throwKlassExternalNameExceptionAddress = this.getAddress("JVMCIRuntime::throw_klass_external_name_exception");
        this.throwClassCastExceptionAddress = this.getAddress("JVMCIRuntime::throw_class_cast_exception");
        this.logPrimitiveAddress = this.getAddress("JVMCIRuntime::log_primitive");
        this.logObjectAddress = this.getAddress("JVMCIRuntime::log_object");
        this.logPrintfAddress = this.getAddress("JVMCIRuntime::log_printf");
        this.vmErrorAddress = this.getAddress("JVMCIRuntime::vm_error");
        this.loadAndClearExceptionAddress = this.getAddress("JVMCIRuntime::load_and_clear_exception");
        this.writeBarrierPreAddress = this.getAddress("JVMCIRuntime::write_barrier_pre");
        this.writeBarrierPostAddress = this.getAddress("JVMCIRuntime::write_barrier_post");
        this.validateObject = this.getAddress("JVMCIRuntime::validate_object");
        this.testDeoptimizeCallInt = this.getAddress("JVMCIRuntime::test_deoptimize_call_int");
        this.registerFinalizerAddress = this.getAddress("SharedRuntime::register_finalizer");
        this.exceptionHandlerForReturnAddressAddress = this.getAddress("SharedRuntime::exception_handler_for_return_address");
        this.osrMigrationEndAddress = this.getAddress("SharedRuntime::OSR_migration_end");
        this.enableStackReservedZoneAddress = this.getAddress("SharedRuntime::enable_stack_reserved_zone");
        this.javaTimeMillisAddress = this.getAddress("os::javaTimeMillis");
        this.javaTimeNanosAddress = this.getAddress("os::javaTimeNanos");
        this.arithmeticSinAddress = this.getFieldValue("CompilerToVM::Data::dsin", Long.class, "address");
        this.arithmeticCosAddress = this.getFieldValue("CompilerToVM::Data::dcos", Long.class, "address");
        this.arithmeticTanAddress = this.getFieldValue("CompilerToVM::Data::dtan", Long.class, "address");
        this.arithmeticExpAddress = this.getFieldValue("CompilerToVM::Data::dexp", Long.class, "address");
        this.arithmeticLogAddress = this.getFieldValue("CompilerToVM::Data::dlog", Long.class, "address");
        this.arithmeticLog10Address = this.getFieldValue("CompilerToVM::Data::dlog10", Long.class, "address");
        this.arithmeticPowAddress = this.getFieldValue("CompilerToVM::Data::dpow", Long.class, "address");
        this.fremAddress = this.getAddress("SharedRuntime::frem");
        this.dremAddress = this.getAddress("SharedRuntime::drem");
        this.jvmciCountersSize = this.getFlag("JVMCICounterSize", Integer.class);
        this.deoptimizationSupportLargeAccessByteArrayVirtualization = this.getConstant("Deoptimization::_support_large_access_byte_array_virtualization", Boolean.class);
        this.VMINTRINSIC_FIRST_MH_SIG_POLY = this.getConstant("vmIntrinsics::FIRST_MH_SIG_POLY", Integer.class);
        this.VMINTRINSIC_LAST_MH_SIG_POLY = this.getConstant("vmIntrinsics::LAST_MH_SIG_POLY", Integer.class);
        this.VMINTRINSIC_INVOKE_GENERIC = this.getConstant("vmIntrinsics::_invokeGeneric", Integer.class);
        this.VMINTRINSIC_COMPILED_LAMBDA_FORM = this.getConstant("vmIntrinsics::_compiledLambdaForm", Integer.class);
        this.CPU_HAS_INTEL_JCC_ERRATUM = this.getFieldValue("VM_Version::_has_intel_jcc_erratum", Boolean.class, "bool", true, "amd64".equals(this.osArch));
        assert (this.narrowKlassShift <= this.logKlassAlignment);
        assert (this.narrowOopShift <= this.logMinObjAlignment());
        this.oopEncoding = new CompressEncoding(this.narrowOopBase, this.narrowOopShift);
        this.klassEncoding = new CompressEncoding(this.narrowKlassBase, this.narrowKlassShift);
        assert (this.check());
        this.reportErrors();
        this.populateMarkConstants();
    }

    public CompressEncoding getOopEncoding() {
        return this.oopEncoding;
    }

    public CompressEncoding getKlassEncoding() {
        return this.klassEncoding;
    }

    public boolean useG1GC() {
        return this.gc == HotSpotGraalRuntime.HotSpotGC.G1;
    }

    private HotSpotGraalRuntime.HotSpotGC getSelectedGC() throws GraalError {
        HotSpotGraalRuntime.HotSpotGC selected = null;
        for (HotSpotGraalRuntime.HotSpotGC value : HotSpotGraalRuntime.HotSpotGC.values()) {
            if (!value.isSelected(this)) continue;
            if (!value.supported) {
                throw new GraalError(value.name() + " garbage collector is not supported by Graal");
            }
            if (selected != null) {
                throw new GraalError("Multiple garbage collectors selected: " + selected + " " + value);
            }
            selected = value;
        }
        if (selected == null) {
            selected = HotSpotGraalRuntime.HotSpotGC.Serial;
        }
        return selected;
    }

    public boolean useSHA1Intrinsics() {
        return this.useSHA1Intrinsics && this.sha1ImplCompress != 0L && this.sha1ImplCompressMultiBlock != 0L;
    }

    public boolean useSHA256Intrinsics() {
        return this.useSHA256Intrinsics && this.sha256ImplCompress != 0L && this.sha256ImplCompressMultiBlock != 0L;
    }

    public boolean useSHA512Intrinsics() {
        return this.useSHA512Intrinsics && this.sha512ImplCompress != 0L && this.sha512ImplCompressMultiBlock != 0L;
    }

    public boolean useMontgomeryMultiplyIntrinsic() {
        return this.useMontgomeryMultiplyIntrinsic && this.montgomeryMultiply != 0L;
    }

    public boolean useMontgomerySquareIntrinsic() {
        return this.useMontgomerySquareIntrinsic && this.montgomerySquare != 0L;
    }

    public boolean inlineNotify() {
        return this.notifyAddress != 0L;
    }

    public boolean inlineNotifyAll() {
        return this.notifyAllAddress != 0L;
    }

    public boolean useCRC32Intrinsics() {
        return this.useCRC32Intrinsics && this.updateBytesCRC32Stub != 0L;
    }

    public boolean useCRC32CIntrinsics() {
        return this.useCRC32CIntrinsics && this.updateBytesCRC32C != 0L;
    }

    public long gcTotalCollectionsAddress() {
        return this.universeCollectedHeap + (long)this.collectedHeapTotalCollectionsOffset;
    }

    public final int logMinObjAlignment() {
        return (int)(Math.log(this.objectAlignment) / Math.log(2.0));
    }

    public final int arrayOopDescLengthOffset() {
        return this.useCompressedClassPointers ? this.hubOffset + this.narrowKlassSize : this.arrayOopDescSize;
    }

    private int getJvmciJvmtiCapabilityOffset(String name) {
        if (JVMCI) {
            return this.getFieldOffset("JVMCICompileState::" + name, Integer.class, "jbyte");
        }
        if (JDK >= 13) {
            return this.getFieldOffset("JVMCICompileState::" + name, Integer.class, "jbyte");
        }
        if (JDK == 12) {
            return this.getFieldOffset("JVMCIEnv::" + name, Integer.class, "jbyte");
        }
        return Integer.MIN_VALUE;
    }

    public boolean requiresReservedStackCheck(List<ResolvedJavaMethod> methods) {
        if (this.enableStackReservedZoneAddress != 0L && methods != null) {
            for (ResolvedJavaMethod method : methods) {
                if (!(method instanceof HotSpotResolvedJavaMethod) || !((HotSpotResolvedJavaMethod)method).hasReservedStackAccess()) continue;
                return true;
            }
        }
        return false;
    }

    public int threadLastJavaSpOffset() {
        return this.javaThreadAnchorOffset + this.javaFrameAnchorLastJavaSpOffset;
    }

    public int threadLastJavaPcOffset() {
        return this.javaThreadAnchorOffset + this.javaFrameAnchorLastJavaPcOffset;
    }

    public int threadLastJavaFpOffset() {
        assert (this.osArch.equals("aarch64") || this.osArch.equals("amd64"));
        return this.javaThreadAnchorOffset + this.getFieldOffset("JavaFrameAnchor::_last_Java_fp", Integer.class, "intptr_t*");
    }

    public int getLockMaskInPlace() {
        if (JDK >= 18) {
            if (this.lockMaskInPlace != null) {
                return this.lockMaskInPlace;
            }
            return 0;
        }
        return this.biasedLockMaskInPlace;
    }

    public long defaultPrototypeMarkWord() {
        return this.markWordNoHashInPlace | this.markWordNoLockInPlace;
    }

    private static String markWordField(String simpleName) {
        return (JDK < 14 ? "markOopDesc::" : "markWord::") + simpleName;
    }

    public int threadTlabEndOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferEndOffset;
    }

    public int threadTlabTopOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferTopOffset;
    }

    public static final boolean base64DecodeBlockHasIsMIMEParameter() {
        try {
            Base64.Decoder.class.getDeclaredMethod("decodeBlock", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean areNullAllocationStubsAvailable() {
        return this.newInstanceOrNullAddress != 0L;
    }

    private boolean checkNullAllocationStubs() {
        if (this.newInstanceOrNullAddress == 0L) {
            assert (this.newArrayOrNullAddress == 0L);
            assert (this.newMultiArrayOrNullAddress == 0L);
            assert (this.dynamicNewInstanceOrNullAddress == 0L);
        } else {
            assert (this.newArrayOrNullAddress != 0L);
            assert (this.newMultiArrayOrNullAddress != 0L);
            assert (this.dynamicNewInstanceOrNullAddress != 0L);
        }
        return true;
    }

    private long getZGCAddressField(String name) {
        long address = this.getFieldValue(name, Long.class, "address", 0L, this.zgcSupport);
        GraalError.guarantee(this.gc != HotSpotGraalRuntime.HotSpotGC.Z || address != 0L, "Unexpected null value for %s", (Object)name);
        return address;
    }

    private void populateMarkConstants() {
        Map constants = this.getStore().getConstants();
        for (HotSpotMarkId markId : HotSpotMarkId.values()) {
            String key = "CodeInstaller::" + markId.name();
            Long result = (Long)constants.get(key);
            if (result == null) {
                if (markId == HotSpotMarkId.ENTRY_BARRIER_PATCH) continue;
                GraalHotSpotVMConfigAccess.reportError("Unsupported Mark " + markId);
            }
            markId.setValue(result.intValue());
        }
    }

    protected boolean check() {
        for (Field f : this.getClass().getDeclaredFields()) {
            int modifiers = f.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) assert (Modifier.isFinal(modifiers)) : "field should be final: " + f;
        }
        assert (this.codeEntryAlignment > 0) : this.codeEntryAlignment;
        assert (this.checkNullAllocationStubs());
        return true;
    }

    public boolean isMethodHandleCall(HotSpotResolvedJavaMethod targetMethod) {
        int intrinsicId = targetMethod.intrinsicId();
        return intrinsicId >= this.VMINTRINSIC_FIRST_MH_SIG_POLY && intrinsicId <= this.VMINTRINSIC_LAST_MH_SIG_POLY && intrinsicId != this.VMINTRINSIC_INVOKE_GENERIC || intrinsicId == this.VMINTRINSIC_COMPILED_LAMBDA_FORM;
    }

    public boolean supportsMethodHandleDeoptimizationEntry() {
        return HotSpotMarkId.DEOPT_MH_HANDLER_ENTRY.isAvailable() && this.VMINTRINSIC_FIRST_MH_SIG_POLY != -1 && this.VMINTRINSIC_LAST_MH_SIG_POLY != -1 && this.VMINTRINSIC_INVOKE_GENERIC != -1 && this.VMINTRINSIC_COMPILED_LAMBDA_FORM != -1;
    }
}

