/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.Instrumentation;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.core.common.util.PhasePlan;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.HotSpotBackendFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.options.EnumOptionKey;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.serviceprovider.GraalServices;

public abstract class CompilerConfigurationFactory
implements Comparable<CompilerConfigurationFactory> {
    private final String name;
    private final String info;
    private final int autoSelectionPriority;
    private static String nativeImageLocationQualifier;

    protected CompilerConfigurationFactory(String name, String info, int autoSelectionPriority) {
        this.name = name;
        this.info = info;
        this.autoSelectionPriority = autoSelectionPriority;
    }

    public abstract CompilerConfiguration createCompilerConfiguration();

    public abstract Instrumentation createInstrumentation(OptionValues var1);

    public BackendMap createBackendMap() {
        return new DefaultBackendMap(this.name);
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public int compareTo(CompilerConfigurationFactory o) {
        if (this.autoSelectionPriority > o.autoSelectionPriority) {
            return -1;
        }
        if (this.autoSelectionPriority < o.autoSelectionPriority) {
            return 1;
        }
        assert (this == o) : "distinct compiler configurations cannot have the same auto selection priority";
        return 0;
    }

    private static boolean checkUnique(CompilerConfigurationFactory factory, List<CompilerConfigurationFactory> factories) {
        for (CompilerConfigurationFactory other : factories) {
            if (other == factory || factory.autoSelectionPriority != other.autoSelectionPriority) continue;
            assert (!other.name.equals(factory.name)) : factory.getClass().getName() + " cannot have the same selector as " + other.getClass().getName() + ": " + factory.name;
            assert (other.autoSelectionPriority != factory.autoSelectionPriority) : factory.getClass().getName() + " cannot have the same auto-selection priority as " + other.getClass().getName() + ": " + factory.autoSelectionPriority;
        }
        return true;
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="false positive on dead store to `candidates`")
    private static List<CompilerConfigurationFactory> getAllCandidates() {
        ArrayList<CompilerConfigurationFactory> candidates = new ArrayList<CompilerConfigurationFactory>();
        for (CompilerConfigurationFactory candidate : GraalServices.load(CompilerConfigurationFactory.class)) {
            assert (CompilerConfigurationFactory.checkUnique(candidate, candidates));
            candidates.add(candidate);
        }
        Collections.sort(candidates);
        return candidates;
    }

    public static CompilerConfigurationFactory selectFactory(String name, OptionValues options, HotSpotJVMCIRuntime runtime) {
        CompilerConfigurationFactory factory = null;
        try (InitTimer t = InitTimer.timer((String)"CompilerConfigurationFactory.selectFactory");){
            String value;
            String string = value = name == null ? Options.CompilerConfiguration.getValue(options) : name;
            if ("help".equals(value)) {
                System.out.println("The available compiler configurations are:");
                for (CompilerConfigurationFactory candidate : CompilerConfigurationFactory.getAllCandidates()) {
                    System.out.println("    " + candidate.name + " priority " + candidate.autoSelectionPriority);
                }
                HotSpotGraalServices.exit(0, runtime);
            } else if (value != null) {
                for (CompilerConfigurationFactory candidate : CompilerConfigurationFactory.getAllCandidates()) {
                    if (!candidate.name.equals(value)) continue;
                    factory = candidate;
                    break;
                }
                if (factory == null) {
                    throw new GraalError("Compiler configuration '%s' not found. Available configurations are: %s", value, CompilerConfigurationFactory.getAllCandidates().stream().map(c -> c.name).collect(Collectors.joining(", ")));
                }
            } else {
                List<CompilerConfigurationFactory> candidates = CompilerConfigurationFactory.getAllCandidates();
                if (candidates.isEmpty()) {
                    throw new GraalError("No %s providers found", CompilerConfigurationFactory.class.getName());
                }
                factory = candidates.get(0);
            }
        }
        assert (factory != null);
        ShowConfigurationLevel level = Options.ShowConfiguration.getValue(options);
        if (level != ShowConfigurationLevel.none) {
            switch (level) {
                case info: {
                    CompilerConfigurationFactory.printConfigInfo(factory);
                    break;
                }
                case verbose: {
                    CompilerConfigurationFactory.printConfigVerbose(factory);
                    CompilerConfiguration config = factory.createCompilerConfiguration();
                    CompilerConfigurationFactory.printPlan("High tier:", () -> config.createHighTier(options));
                    CompilerConfigurationFactory.printPlan("Mid tier:", () -> config.createMidTier(options));
                    CompilerConfigurationFactory.printPlan("Low tier:", () -> config.createLowTier(options, runtime.getHostJVMCIBackend().getTarget().arch));
                    CompilerConfigurationFactory.printPlan("Pre regalloc stage:", () -> config.createPreAllocationOptimizationStage(options));
                    CompilerConfigurationFactory.printPlan("Regalloc stage:", () -> config.createAllocationStage(options));
                    CompilerConfigurationFactory.printPlan("Post regalloc stage:", () -> config.createPostAllocationOptimizationStage(options));
                    break;
                }
            }
        }
        return factory;
    }

    private Object getLoadedFromLocation(boolean verbose) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            if (nativeImageLocationQualifier != null) {
                return "a " + nativeImageLocationQualifier + " Native Image shared library";
            }
            return "a Native Image shared library";
        }
        return verbose ? this.getClass().getResource(this.getClass().getSimpleName() + ".class") : "class files";
    }

    public static void setNativeImageLocationQualifier(String s) {
        GraalError.guarantee(nativeImageLocationQualifier == null, "Native image location qualifier is already set to %s", (Object)nativeImageLocationQualifier);
        nativeImageLocationQualifier = s;
    }

    private static void printConfigInfo(CompilerConfigurationFactory factory) {
        Object location = factory.getLoadedFromLocation(false);
        TTY.printf("Using \"%s\" loaded from %s%n", factory.info, location);
    }

    private static void printConfigVerbose(CompilerConfigurationFactory factory) {
        Object location = factory.getLoadedFromLocation(true);
        TTY.printf("Using compiler configuration '%s' (\"%s\") provided by %s loaded from %s%n", factory.name, factory.info, factory.getClass().getName(), location);
    }

    private static <T> void printPlan(String label, Supplier<PhasePlan<T>> plan) {
        try {
            TTY.printf("%s%n%s", label, new PhasePlan.Printer().toString(plan.get()));
        }
        catch (Throwable t) {
            t.printStackTrace(TTY.out);
        }
    }

    public static class DefaultBackendMap
    implements BackendMap {
        private final EconomicMap<Class<? extends Architecture>, HotSpotBackendFactory> backends = EconomicMap.create();

        public DefaultBackendMap(String backendName) {
            try (InitTimer t = InitTimer.timer((String)"HotSpotBackendFactory.register");){
                for (HotSpotBackendFactory backend : GraalServices.load(HotSpotBackendFactory.class)) {
                    Class<? extends Architecture> arch;
                    if (!backend.getName().equals(backendName) || (arch = backend.getArchitecture()) == null) continue;
                    HotSpotBackendFactory oldEntry = (HotSpotBackendFactory)this.backends.put(arch, (Object)backend);
                    assert (oldEntry == null || oldEntry == backend) : "duplicate Graal backend";
                }
            }
        }

        @Override
        public final HotSpotBackendFactory getBackendFactory(Architecture arch) {
            return (HotSpotBackendFactory)this.backends.get(arch.getClass());
        }
    }

    static class Options {
        public static final OptionKey<String> CompilerConfiguration = new OptionKey<Object>(null);
        public static final OptionKey<ShowConfigurationLevel> ShowConfiguration = new EnumOptionKey<ShowConfigurationLevel>(ShowConfigurationLevel.none);

        Options() {
        }
    }

    static enum ShowConfigurationLevel {
        none,
        info,
        verbose;

    }

    public static interface BackendMap {
        public HotSpotBackendFactory getBackendFactory(Architecture var1);
    }
}

