/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.io.PrintStream;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotCompilationRequestResult;
import jdk.vm.ci.hotspot.HotSpotInstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationPrinter;
import org.graalvm.compiler.core.CompilationWatchDog;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.GraalCompilerOptions;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpScope;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.hotspot.CompilationStatistics;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotCompilationIdentifier;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotGraalCompilerFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.hotspot.ProfileReplaySupport;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.ProfileProvider;
import org.graalvm.compiler.nodes.spi.StableProfileProvider;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;

public class CompilationTask
implements CompilationWatchDog.EventHandler {
    private final HotSpotJVMCIRuntime jvmciRuntime;
    protected final HotSpotGraalCompiler compiler;
    private final HotSpotCompilationIdentifier compilationId;
    private HotSpotInstalledCode installedCode;
    private final boolean installAsDefault;
    private final StableProfileProvider profileProvider;
    private final boolean shouldRetainLocalVariables;
    private final boolean eagerResolving;
    private StableProfileProvider.TypeFilter profileSaveFilter;
    public static final TimerKey CompilationTime = DebugContext.timer("CompilationTime").doc("Time spent in compilation and code installation.");
    private static final CounterKey CompiledBytecodes = DebugContext.counter("CompiledBytecodes");
    public static final CounterKey CompiledAndInstalledBytecodes = DebugContext.counter("CompiledAndInstalledBytecodes");
    private static final CounterKey InstalledCodeSize = DebugContext.counter("InstalledCodeSize");
    public static final TimerKey CodeInstallationTime = DebugContext.timer("CodeInstallation");

    @Override
    public void onStuckCompilation(CompilationWatchDog watchDog, Thread watched, CompilationIdentifier compilation, StackTraceElement[] stackTrace, int stuckTime) {
        CompilationWatchDog.EventHandler.super.onStuckCompilation(watchDog, watched, compilation, stackTrace, stuckTime);
        TTY.println("Compilation %s on %s appears stuck - exiting VM", compilation, watched);
        HotSpotGraalServices.exit(84, this.jvmciRuntime);
    }

    public CompilationTask(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalCompiler compiler, HotSpotCompilationRequest request, boolean useProfilingInfo, boolean installAsDefault) {
        this(jvmciRuntime, compiler, request, useProfilingInfo, false, false, installAsDefault);
    }

    public CompilationTask(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalCompiler compiler, HotSpotCompilationRequest request, boolean useProfilingInfo, boolean shouldRetainLocalVariables, boolean installAsDefault) {
        this(jvmciRuntime, compiler, request, useProfilingInfo, shouldRetainLocalVariables, false, installAsDefault);
    }

    public CompilationTask(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalCompiler compiler, HotSpotCompilationRequest request, boolean useProfilingInfo, boolean shouldRetainLocalVariables, boolean eagerResolving, boolean installAsDefault) {
        this.jvmciRuntime = jvmciRuntime;
        this.compiler = compiler;
        this.compilationId = new HotSpotCompilationIdentifier(request);
        this.profileProvider = useProfilingInfo ? new StableProfileProvider() : null;
        this.shouldRetainLocalVariables = shouldRetainLocalVariables;
        this.eagerResolving = eagerResolving;
        this.installAsDefault = installAsDefault;
    }

    public void setTypeFilter(StableProfileProvider.TypeFilter typeFilter) {
        this.profileSaveFilter = typeFilter;
    }

    public OptionValues filterOptions(OptionValues options) {
        HotSpotGraalRuntimeProvider graalRuntime = this.compiler.getGraalRuntime();
        GraalHotSpotVMConfig config = graalRuntime.getVMConfig();
        OptionValues newOptions = options;
        if (!config.inline) {
            EconomicMap<OptionKey<?>, Object> m = OptionValues.newOptionMap();
            if (HighTier.Options.Inline.getValue(options).booleanValue() && !HighTier.Options.Inline.hasBeenSet(options)) {
                m.put(HighTier.Options.Inline, (Object)false);
            }
            if (BytecodeParserOptions.InlineDuringParsing.getValue(options).booleanValue() && !BytecodeParserOptions.InlineDuringParsing.hasBeenSet(options)) {
                m.put(BytecodeParserOptions.InlineDuringParsing, (Object)false);
            }
            if (!m.isEmpty()) {
                newOptions = new OptionValues(options, (UnmodifiableEconomicMap<OptionKey<?>, Object>)m);
            }
        }
        return newOptions;
    }

    public HotSpotResolvedJavaMethod getMethod() {
        return this.getRequest().getMethod();
    }

    CompilationIdentifier getCompilationIdentifier() {
        return this.compilationId;
    }

    public int getId() {
        return this.getRequest().getId();
    }

    public int getEntryBCI() {
        return this.getRequest().getEntryBCI();
    }

    public String getIdString() {
        if (this.getEntryBCI() != -1) {
            return this.getId() + "%";
        }
        return Integer.toString(this.getId());
    }

    public HotSpotInstalledCode getInstalledCode() {
        return this.installedCode;
    }

    public HotSpotCompilationRequestResult runCompilation(OptionValues initialOptions) {
        OptionValues options = this.filterOptions(initialOptions);
        HotSpotGraalRuntimeProvider graalRuntime = this.compiler.getGraalRuntime();
        try (DebugContext debug = graalRuntime.openDebugContext(options, this.compilationId, this.getMethod(), this.compiler.getDebugHandlersFactories(), DebugContext.getDefaultLogStream());){
            HotSpotCompilationRequestResult hotSpotCompilationRequestResult = this.runCompilation(debug);
            return hotSpotCompilationRequestResult;
        }
    }

    private static void resolveTypesInSignature(ResolvedJavaMethod method) {
        Signature sig = method.getSignature();
        int max = sig.getParameterCount(false);
        ResolvedJavaType accessingClass = method.getDeclaringClass();
        for (int i = 0; i < max; ++i) {
            JavaType type = sig.getParameterType(i, accessingClass);
            if (type instanceof ResolvedJavaType) continue;
            try {
                type.resolve(accessingClass);
                continue;
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
    }

    public ProfileProvider getProfileProvider() {
        return this.profileProvider;
    }

    public HotSpotCompilationRequestResult runCompilation(DebugContext debug) {
        return this.runCompilation(debug, new HotSpotCompilationWrapper());
    }

    /*
     * Loose catch block
     */
    protected HotSpotCompilationRequestResult runCompilation(DebugContext debug, HotSpotCompilationWrapper compilation) {
        HotSpotCompilationRequestResult hotSpotCompilationRequestResult;
        DebugCloseable a;
        ProfileReplaySupport result;
        HotSpotResolvedJavaMethod method;
        int entryBCI;
        block23: {
            HotSpotGraalRuntimeProvider graalRuntime = this.compiler.getGraalRuntime();
            GraalHotSpotVMConfig config = graalRuntime.getVMConfig();
            entryBCI = this.getEntryBCI();
            boolean isOSR = entryBCI != -1;
            method = this.getMethod();
            CompilationTask.resolveTypesInSignature((ResolvedJavaMethod)method);
            if (this.installAsDefault || isOSR) {
                if (method.hasCodeAtLevel(entryBCI, config.compilationLevelFullOptimization)) {
                    return HotSpotCompilationRequestResult.failure((String)"Already compiled", (boolean)false);
                }
                if (HotSpotGraalCompilerFactory.shouldExclude(method)) {
                    return HotSpotCompilationRequestResult.failure((String)"GraalCompileOnly excluded", (boolean)false);
                }
            }
            result = ProfileReplaySupport.profileReplayPrologue(debug, graalRuntime, entryBCI, method, this.profileProvider, this.profileSaveFilter);
            a = CompilationTime.start(debug);
            hotSpotCompilationRequestResult = (HotSpotCompilationRequestResult)compilation.run(debug);
            if (a == null) break block23;
            a.close();
        }
        try {
            if (compilation.result != null) {
                int compiledBytecodes = compilation.result.getBytecodeSize();
                CompiledBytecodes.add(debug, compiledBytecodes);
                if (this.installedCode != null) {
                    int codeSize = this.installedCode.getSize();
                    CompiledAndInstalledBytecodes.add(debug, compiledBytecodes);
                    InstalledCodeSize.add(debug, codeSize);
                }
                if (result != null && result.getExpectedResult() != null && !result.getExpectedResult().booleanValue()) {
                    TTY.printf("Expected failure: %s %s%n", method.format("%H.%n(%P)%R"), entryBCI);
                }
            }
            if (result != null) {
                result.profileReplayEpilogue(debug, compilation, this.profileProvider, this.compilationId, entryBCI, method);
            }
        }
        catch (Throwable t) {
            return compilation.handleException(t);
        }
        return hotSpotCompilationRequestResult;
        {
            catch (Throwable throwable) {
                try {
                    if (a != null) {
                        try {
                            a.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    try {
                        if (compilation.result != null) {
                            int compiledBytecodes = compilation.result.getBytecodeSize();
                            CompiledBytecodes.add(debug, compiledBytecodes);
                            if (this.installedCode != null) {
                                int codeSize = this.installedCode.getSize();
                                CompiledAndInstalledBytecodes.add(debug, compiledBytecodes);
                                InstalledCodeSize.add(debug, codeSize);
                            }
                            if (result != null && result.getExpectedResult() != null && !result.getExpectedResult().booleanValue()) {
                                TTY.printf("Expected failure: %s %s%n", method.format("%H.%n(%P)%R"), entryBCI);
                            }
                        }
                        if (result != null) {
                            result.profileReplayEpilogue(debug, compilation, this.profileProvider, this.compilationId, entryBCI, method);
                        }
                    }
                    catch (Throwable t) {
                        return compilation.handleException(t);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private void installMethod(DebugContext debug, StructuredGraph graph, CompilationResult compResult) {
        CodeCacheProvider codeCache = this.jvmciRuntime.getHostJVMCIBackend().getCodeCache();
        HotSpotBackend backend = this.compiler.getGraalRuntime().getHostBackend();
        this.installedCode = null;
        Object[] context = new Object[]{new DebugDumpScope(this.getIdString(), true), codeCache, this.getMethod(), compResult};
        try (DebugContext.Scope s = debug.scope("CodeInstall", context, graph);){
            HotSpotCompilationRequest request = this.getRequest();
            this.installedCode = (HotSpotInstalledCode)backend.createInstalledCode(debug, (ResolvedJavaMethod)request.getMethod(), (CompilationRequest)request, compResult, null, this.installAsDefault, context);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    public String toString() {
        return "Compilation[id=" + this.getId() + ", " + this.getMethod().format("%H.%n(%p)") + (String)(this.getEntryBCI() == -1 ? "" : "@" + this.getEntryBCI()) + "]";
    }

    private HotSpotCompilationRequest getRequest() {
        return this.compilationId.getRequest();
    }

    protected class HotSpotCompilationWrapper
    extends CompilationWrapper<HotSpotCompilationRequestResult> {
        CompilationResult result;
        StructuredGraph graph;

        protected HotSpotCompilationWrapper() {
            super(CompilationTask.this.compiler.getGraalRuntime().getOutputDirectory(), CompilationTask.this.compiler.getGraalRuntime().getCompilationProblemsPerAction());
        }

        @Override
        protected DebugContext createRetryDebugContext(DebugContext initialDebug, OptionValues retryOptions, PrintStream logStream) {
            SnippetReflectionProvider snippetReflection = CompilationTask.this.compiler.getGraalRuntime().getHostProviders().getSnippetReflection();
            DebugContext.Description description = initialDebug.getDescription();
            GraalDebugHandlersFactory factory = new GraalDebugHandlersFactory(snippetReflection);
            return new DebugContext.Builder(retryOptions, factory).globalMetrics(initialDebug.getGlobalMetrics()).description(description).logStream(logStream).build();
        }

        @Override
        protected void exitHostVM(int status) {
            HotSpotGraalServices.exit(status, CompilationTask.this.jvmciRuntime);
        }

        @Override
        public String toString() {
            return CompilationTask.this.getMethod().format("%H.%n(%p) @ " + CompilationTask.this.getEntryBCI());
        }

        @Override
        protected HotSpotCompilationRequestResult handleException(Throwable t) {
            if (t instanceof BailoutException) {
                BailoutException bailout = (BailoutException)t;
                return HotSpotCompilationRequestResult.failure((String)bailout.getMessage(), (!bailout.isPermanent() ? 1 : 0) != 0);
            }
            return HotSpotCompilationRequestResult.failure((String)t.toString(), (boolean)false);
        }

        @Override
        protected CompilationWrapper.ExceptionAction lookupAction(OptionValues values, Throwable cause) {
            if (cause instanceof BailoutException) {
                BailoutException bailout = (BailoutException)cause;
                if (bailout.isPermanent() && !GraalCompilerOptions.CompilationBailoutAsFailure.hasBeenSet(values) && CompilationTask.this.compiler.getGraalRuntime().isBootstrapping()) {
                    return CompilationWrapper.ExceptionAction.Diagnose;
                }
                if (!GraalCompilerOptions.CompilationBailoutAsFailure.getValue(values).booleanValue()) {
                    return super.lookupAction(values, cause);
                }
            }
            if (!GraalCompilerOptions.CompilationFailureAction.hasBeenSet(values) && CompilationTask.this.compiler.getGraalRuntime().isBootstrapping()) {
                return CompilationWrapper.ExceptionAction.ExitVM;
            }
            return super.lookupAction(values, cause);
        }

        @Override
        protected HotSpotCompilationRequestResult performCompilation(DebugContext debug) {
            HotSpotResolvedJavaMethod method = CompilationTask.this.getMethod();
            int entryBCI = CompilationTask.this.getEntryBCI();
            boolean isOSR = entryBCI != -1;
            CompilationStatistics stats = CompilationStatistics.create(debug.getOptions(), method, isOSR);
            CompilationPrinter printer = CompilationPrinter.begin(debug.getOptions(), CompilationTask.this.compilationId, method, entryBCI);
            try (DebugContext.Scope s = debug.scope((Object)"Compiling", new DebugDumpScope(CompilationTask.this.getIdString(), true));){
                this.graph = CompilationTask.this.compiler.createGraph((ResolvedJavaMethod)method, entryBCI, CompilationTask.this.profileProvider, CompilationTask.this.compilationId, debug.getOptions(), debug);
                this.result = CompilationTask.this.compiler.compile(this.graph, CompilationTask.this.shouldRetainLocalVariables, CompilationTask.this.eagerResolving, CompilationTask.this.compilationId, debug);
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            if (this.result != null) {
                try (DebugCloseable b = CodeInstallationTime.start(debug);){
                    CompilationTask.this.installMethod(debug, this.graph, this.result);
                }
                printer.finish(this.result, (InstalledCode)CompilationTask.this.installedCode);
            }
            stats.finish(method, CompilationTask.this.installedCode);
            if (this.result != null) {
                ResolvedJavaMethod rootMethod = this.result.getMethods()[0];
                int inlinedBytecodes = this.result.getBytecodeSize() - rootMethod.getCodeSize();
                assert (inlinedBytecodes >= 0) : rootMethod + " " + method;
                return HotSpotCompilationRequestResult.success((int)inlinedBytecodes);
            }
            return null;
        }
    }
}

