/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.util.MethodKey;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

class CompilationCounters {
    private final OptionValues options;
    private final Map<MethodKey, Integer> counters = new HashMap<MethodKey, Integer>();

    CompilationCounters(OptionValues options) {
        TTY.println("Warning: Compilation counters enabled, excessive recompilation of a method will cause a failure!");
        this.options = options;
    }

    synchronized void countCompilation(ResolvedJavaMethod method) {
        MethodKey key = new MethodKey(method);
        Integer val = this.counters.get(key);
        val = val != null ? val + 1 : 1;
        this.counters.put(key, val);
        if (val > Options.CompilationCountLimit.getValue(this.options)) {
            TTY.printf("Error. Method %s was compiled too many times. Number of compilations: %d\n", method.format("%H.%n(%p)"), Options.CompilationCountLimit.getValue(this.options));
            TTY.println("==================================== High compilation counters ====================================");
            TreeSet<Map.Entry<MethodKey, Integer>> sortedCounters = new TreeSet<Map.Entry<MethodKey, Integer>>(new CounterComparator());
            for (Map.Entry<MethodKey, Integer> e : this.counters.entrySet()) {
                sortedCounters.add(e);
            }
            for (Map.Entry<MethodKey, Integer> entry : sortedCounters) {
                if (entry.getValue() < Options.CompilationCountLimit.getValue(this.options) / 2) continue;
                TTY.out.printf("%d\t%s%n", entry.getValue(), entry.getKey());
            }
            TTY.flush();
            HotSpotGraalServices.exit(-1, HotSpotJVMCIRuntime.runtime());
        }
    }

    public static class Options {
        public static final OptionKey<Integer> CompilationCountLimit = new OptionKey<Integer>(0);
    }

    static final class CounterComparator
    implements Comparator<Map.Entry<MethodKey, Integer>> {
        CounterComparator() {
        }

        @Override
        public int compare(Map.Entry<MethodKey, Integer> o1, Map.Entry<MethodKey, Integer> o2) {
            if (o1.getValue() < o2.getValue()) {
                return -1;
            }
            if (o1.getValue() > o2.getValue()) {
                return 1;
            }
            return String.valueOf(o1.getKey()).compareTo(String.valueOf(o2.getKey()));
        }
    }
}

