/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen.variables;

import jdk.vm.ci.common.JVMCIError;
import org.graalvm.compiler.graph.Node;

public final class ResolvedVar {
    private final Node node;
    private boolean unborn;
    private String resolvedVarName;
    private boolean definitionLowered = false;

    public ResolvedVar(Node node) {
        this.node = node;
        this.unborn = true;
    }

    public void birth(String name) {
        this.unborn = false;
        this.resolvedVarName = name;
    }

    public void setDefinitionLowered() {
        assert (!this.definitionLowered);
        this.definitionLowered = true;
    }

    public boolean isDefinitionLowered() {
        return this.definitionLowered;
    }

    public boolean born() {
        return !this.unborn;
    }

    public String getName() {
        JVMCIError.guarantee((boolean)this.born(), (String)"Var is not born yet for node:%s", (Object[])new Object[]{this.node});
        if (this.resolvedVarName.endsWith("-1")) {
            JVMCIError.shouldNotReachHere((String)("Var has invalid id " + this.node.toString()));
        }
        return this.resolvedVarName;
    }

    public Node getOrig() {
        return this.node;
    }
}

