/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen.reconstruction.stackifier;

import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hightiercodegen.reconstruction.StackifierData;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.CatchScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.IfScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.LoopScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.Scope;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.ScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.SwitchScopeContainer;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;

public class StackifierScopeComputation {
    private final ControlFlowGraph cfg;
    private final EconomicMap<Node, ScopeContainer> scopes = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);

    public StackifierScopeComputation(StructuredGraph g) {
        this.cfg = g.getLastSchedule().getCFG();
    }

    private static EconomicSet<HIRBlock> computeDominatedBlocks(HIRBlock b, Scope loopScope) {
        if (loopScope != null && !loopScope.getBlocks().contains((Object)b)) {
            return null;
        }
        EconomicSet dominatedBlocksInsideLoop = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        EconomicSet dominatedBlocks = EconomicSet.create();
        dominatedBlocksInsideLoop.add((Object)b);
        if (b.getFirstDominated() != null) {
            dominatedBlocks.add((Object)((HIRBlock)b.getFirstDominated()));
        }
        while (!dominatedBlocks.isEmpty()) {
            HIRBlock dominatedBlock = (HIRBlock)dominatedBlocks.iterator().next();
            dominatedBlocks.remove((Object)dominatedBlock);
            if (loopScope == null || loopScope.getBlocks().contains((Object)dominatedBlock)) {
                dominatedBlocksInsideLoop.add((Object)dominatedBlock);
            }
            if (dominatedBlock.getFirstDominated() != null) {
                dominatedBlocks.add((Object)((HIRBlock)dominatedBlock.getFirstDominated()));
            }
            if (dominatedBlock.getDominatedSibling() == null) continue;
            dominatedBlocks.add((Object)((HIRBlock)dominatedBlock.getDominatedSibling()));
        }
        return dominatedBlocksInsideLoop;
    }

    public void computeScopes(StackifierData stackifierData) {
        try (DebugContext.Scope scope1 = this.cfg.graph.getDebug().scope("Stackifier scope computation");){
            this.computeLoopScopes();
            this.computeThenElseScopes();
            this.computeCatchScopes();
            this.computeSwitchCases();
            stackifierData.setScopeEntries(this.scopes);
        }
    }

    private void computeSwitchCases() {
        for (IntegerSwitchNode switchNode : this.cfg.graph.getNodes().filter(IntegerSwitchNode.class)) {
            this.computeCaseScopes(switchNode);
        }
    }

    private void computeCaseScopes(IntegerSwitchNode switchNode) {
        HIRBlock switchBlock = this.cfg.blockFor(switchNode);
        SwitchScopeContainer switchScopes = new SwitchScopeContainer(new Scope[switchNode.blockSuccessorCount()]);
        this.scopes.put((Object)switchNode, (Object)switchScopes);
        for (int i = 0; i < switchNode.blockSuccessorCount(); ++i) {
            Scope scope;
            HIRBlock caseBlock = this.cfg.blockFor(switchNode.blockSuccessor(i));
            assert (AbstractControlFlowGraph.dominates(switchBlock, caseBlock));
            Loop<HIRBlock> loop = switchBlock.getLoop();
            EconomicSet<HIRBlock> blocks = this.computeScopeBlocks(switchBlock, caseBlock, loop);
            if (blocks == null) continue;
            switchScopes.getCaseScopes()[i] = scope = new Scope(blocks, switchBlock);
        }
    }

    private void computeCatchScopes() {
        for (WithExceptionNode invokeNode : this.cfg.graph.getNodes().filter(WithExceptionNode.class)) {
            AbstractBeginNode begNode = invokeNode.exceptionEdge();
            HIRBlock invokeBlock = this.cfg.blockFor(invokeNode);
            EconomicSet<HIRBlock> blocks = this.computeScopeBlocks(invokeBlock, this.cfg.blockFor(begNode), invokeBlock.getLoop());
            Scope scope = blocks == null ? null : new Scope(blocks, invokeBlock);
            this.scopes.put((Object)invokeNode, (Object)new CatchScopeContainer(scope));
        }
    }

    private void computeLoopScopes() {
        for (Loop loop : this.cfg.getLoops()) {
            EconomicSet loopBlocks = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
            loopBlocks.addAll(loop.getBlocks());
            Scope loopScope = new Scope((EconomicSet<HIRBlock>)loopBlocks, (HIRBlock)loop.getHeader());
            this.scopes.put((Object)((HIRBlock)loop.getHeader()).getBeginNode(), (Object)new LoopScopeContainer(loopScope));
            this.cfg.graph.getDebug().log("%s", loopScope);
        }
    }

    private void computeThenElseScopes() {
        for (IfNode ifNode : this.cfg.graph.getNodes(IfNode.TYPE)) {
            HIRBlock ifBlock = this.cfg.blockFor(ifNode);
            AbstractBeginNode trueSuccessor = ifNode.trueSuccessor();
            AbstractBeginNode falseSuccessor = ifNode.falseSuccessor();
            Loop<HIRBlock> loop = ifBlock.getLoop();
            EconomicSet<HIRBlock> blocks = this.computeScopeBlocks(ifBlock, this.cfg.blockFor(trueSuccessor), loop);
            Scope thenScope = null;
            if (blocks != null) {
                thenScope = new Scope(blocks, ifBlock);
            }
            blocks = this.computeScopeBlocks(this.cfg.blockFor(ifNode), this.cfg.blockFor(falseSuccessor), loop);
            Scope elseScope = null;
            if (blocks != null) {
                elseScope = new Scope(blocks, ifBlock);
            }
            this.scopes.put((Object)ifNode, (Object)new IfScopeContainer(thenScope, elseScope));
        }
    }

    private EconomicSet<HIRBlock> computeScopeBlocks(HIRBlock startBlock, HIRBlock successor, Loop<HIRBlock> loop) {
        if (AbstractControlFlowGraph.dominates(startBlock, successor)) {
            Scope loopScope;
            if (loop == null) {
                loopScope = null;
            } else {
                loopScope = ((LoopScopeContainer)this.scopes.get((Object)loop.getHeader().getBeginNode())).getLoopScope();
                assert (loopScope != null);
            }
            EconomicSet<HIRBlock> dominatedBlocks = StackifierScopeComputation.computeDominatedBlocks(successor, loopScope);
            assert (dominatedBlocks == null || !dominatedBlocks.isEmpty());
            return dominatedBlocks;
        }
        return null;
    }
}

