/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen.reconstruction.stackifier;

import java.util.Optional;
import org.graalvm.compiler.hightiercodegen.reconstruction.ReconstructionPhase;
import org.graalvm.compiler.hightiercodegen.reconstruction.ScheduleWithReconstructionResult;
import org.graalvm.compiler.hightiercodegen.reconstruction.StackifierData;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.CFStackifierSortPhase;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.StackifierScopeComputation;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlockGeneration;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.schedule.SchedulePhase;

public class StackifierReconstructionPhase
extends ReconstructionPhase {
    @Override
    protected void run(StructuredGraph graph, CoreProviders providers) {
        SchedulePhase schedulePhase = new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS);
        schedulePhase.apply(graph, providers);
        StackifierData stackifierData = new StackifierData();
        new StackifierScopeComputation(graph).computeScopes(stackifierData);
        new CFStackifierSortPhase().apply(graph, stackifierData);
        LabeledBlockGeneration blockGeneration = this.createLabeledBlockGeneration(stackifierData, graph.getLastSchedule().getCFG());
        blockGeneration.generateLabeledBlocks();
        stackifierData.setLabeledBlockGeneration(blockGeneration);
        graph.setLastSchedule(new ScheduleWithReconstructionResult(graph.getLastSchedule(), stackifierData));
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.ALWAYS_APPLICABLE;
    }

    protected LabeledBlockGeneration createLabeledBlockGeneration(StackifierData stackifierData, ControlFlowGraph cfg) {
        return new LabeledBlockGeneration(stackifierData, cfg);
    }
}

