/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen.irwalk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.hightiercodegen.CodeGenTool;
import org.graalvm.compiler.hightiercodegen.irwalk.BlockNestingVerifier;
import org.graalvm.compiler.hightiercodegen.irwalk.IRWalker;
import org.graalvm.compiler.hightiercodegen.reconstruction.ReconstructionData;
import org.graalvm.compiler.hightiercodegen.reconstruction.StackifierData;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlock;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlockGeneration;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.CatchScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.IfScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.LoopScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.Scope;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.SwitchScopeContainer;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.replacements.nodes.BasicArrayCopyNode;

public class StackifierIRWalker
extends IRWalker {
    public static final String LABEL_PREFIX = "looplabel_";
    protected final BlockNestingVerifier blockNestingVerifier = new BlockNestingVerifier();

    public StackifierIRWalker(CodeGenTool codeGenTool, ControlFlowGraph cfg, BlockMap<List<Node>> blockToNodeMap, NodeMap<HIRBlock> nodeToBlockMap, ReconstructionData reconstructionData) {
        super(codeGenTool, cfg, blockToNodeMap, nodeToBlockMap, reconstructionData);
    }

    @Override
    protected void lower(DebugContext debugContext) {
        StackifierData stackifierData = (StackifierData)this.reconstructionData;
        stackifierData.debugDump(debugContext);
        for (AbstractMergeNode n : this.cfg.graph.getNodes(AbstractMergeNode.TYPE)) {
            for (PhiNode phi : n.phis()) {
                if (this.codeGenTool.nodeLowerer().actualUsageCount(phi) <= 0) continue;
                this.codeGenTool.nodeLowerer().lower(phi);
            }
        }
        this.lowerBlocks(stackifierData.getBlocks());
    }

    private void lowerBlocks(HIRBlock[] blocks) {
        StackifierData stackifierData = (StackifierData)this.reconstructionData;
        for (HIRBlock currentBlock : blocks) {
            Node node;
            if (this.blockHistory.blockVisited(currentBlock)) continue;
            boolean isLoopHeader = currentBlock.isLoopHeader();
            SortedSet<LabeledBlock> labeledBlockStartsBeforeLoop = LabeledBlockGeneration.getSortedSetByLabeledBlockEnd();
            SortedSet<LabeledBlock> labeledBlockStartsAfterLoop = LabeledBlockGeneration.getSortedSetByLabeledBlockEnd();
            SortedSet<LabeledBlock> blockStarts = stackifierData.labeledBlockStarts(currentBlock);
            if (blockStarts != null) {
                for (LabeledBlock labeledBlock : blockStarts) {
                    if (isLoopHeader && StackifierIRWalker.labeledBlockEndsInLoop((LoopScopeContainer)stackifierData.getScopeEntry(currentBlock.getBeginNode()), labeledBlock)) {
                        labeledBlockStartsAfterLoop.add(labeledBlock);
                        continue;
                    }
                    labeledBlockStartsBeforeLoop.add(labeledBlock);
                }
            }
            LabeledBlock blockEnd = stackifierData.labeledBlockEnd(currentBlock);
            if (!StackifierIRWalker.isInRecursiveLoopCall(isLoopHeader, currentBlock, blocks)) {
                this.genLabeledBlockEnd(blockEnd);
                labeledBlockStartsBeforeLoop.forEach(this::genLabeledBlockHeader);
            }
            if (StackifierIRWalker.newLoopStartsHere(isLoopHeader, currentBlock, blocks)) {
                this.lowerLoopStackifier(stackifierData, currentBlock);
                continue;
            }
            this.codeGenTool.genComment("Start of block " + currentBlock.getId());
            labeledBlockStartsAfterLoop.forEach(this::genLabeledBlockHeader);
            Iterator iterator = ((List)this.blockToNodeMap.get(currentBlock)).iterator();
            while (iterator.hasNext() && (node = (Node)iterator.next()) != currentBlock.getEndNode()) {
                if (node instanceof LoopBeginNode) {
                    assert (currentBlock == blocks[0]);
                } else if (!(node instanceof LoopExitNode)) {
                    this.lowerNode(node);
                }
                this.verifier.visitNode(node, this.codeGenTool);
            }
            FixedNode fixedNode = currentBlock.getEndNode();
            if (fixedNode instanceof ControlSinkNode) {
                this.lowerNode(fixedNode);
            } else if (fixedNode instanceof IfNode) {
                this.lowerIfStackifier(currentBlock, (IfNode)fixedNode);
            } else if (fixedNode instanceof IntegerSwitchNode) {
                this.lowerSwitch((IntegerSwitchNode)fixedNode, stackifierData);
            } else if (this.isWithExceptionNode(fixedNode)) {
                this.lowerWithExceptionStackifier(currentBlock, (WithExceptionNode)fixedNode);
            } else if (fixedNode instanceof ControlSplitNode && !(fixedNode instanceof BasicArrayCopyNode)) {
                assert (false) : "Unsupported control split node " + fixedNode + " is not implemented yet";
            } else if (fixedNode instanceof LoopEndNode) {
                this.lowerLoopEndResolver((LoopEndNode)fixedNode);
                this.codeGenTool.genLoopContinue();
            } else {
                if (!(fixedNode instanceof LoopExitNode) && !(fixedNode instanceof LoopBeginNode)) {
                    this.lowerNode(fixedNode);
                }
                HIRBlock successor = (HIRBlock)this.nodeToBlockMap.get(fixedNode.cfgSuccessors().iterator().next());
                this.generateForwardJump(currentBlock, successor, stackifierData);
            }
            this.verifier.visitNode(fixedNode, this.codeGenTool);
            this.blockHistory.visitBlock(currentBlock);
            this.codeGenTool.genComment("End of block " + currentBlock.getId());
        }
    }

    private static boolean isInRecursiveLoopCall(boolean isLoopHeader, HIRBlock currenBlock, HIRBlock[] blocks) {
        return isLoopHeader && currenBlock == blocks[0];
    }

    private static boolean newLoopStartsHere(boolean isLoopHeader, HIRBlock currenBlock, HIRBlock[] blocks) {
        return isLoopHeader && currenBlock != blocks[0];
    }

    protected boolean isWithExceptionNode(Node lastNode) {
        return lastNode instanceof InvokeWithExceptionNode;
    }

    private void generateForwardJump(HIRBlock currentBlock, HIRBlock successor, StackifierData stackifierData) {
        if (LabeledBlockGeneration.isNormalLoopExit(currentBlock, successor, stackifierData)) {
            Loop<HIRBlock> loop = currentBlock.getLoop();
            Scope loopScope = ((LoopScopeContainer)stackifierData.getScopeEntry(loop.getHeader().getBeginNode())).getLoopScope();
            Scope innerScope = (Scope)stackifierData.getEnclosingScope().get((Object)currentBlock);
            while (!innerScope.equals(loopScope) && !(innerScope.getStartBlock().getEndNode() instanceof IntegerSwitchNode)) {
                innerScope = innerScope.getParentScope();
            }
            if (innerScope.equals(loopScope) && !(currentBlock.getEndNode() instanceof IntegerSwitchNode)) {
                this.codeGenTool.genBreak();
            } else {
                this.codeGenTool.genBreak(StackifierIRWalker.getLabel(loop.getHeader()));
            }
        } else if (stackifierData.getLabeledBlockGeneration().isLabeledBlockNeeded(currentBlock, successor)) {
            LabeledBlock forwardBlock = stackifierData.labeledBlockEnd(successor);
            this.codeGenTool.genBreak(forwardBlock.getLabel());
        }
    }

    private void lowerLoopStackifier(StackifierData stackifierData, HIRBlock currentBlock) {
        assert (currentBlock.getBeginNode() instanceof LoopBeginNode);
        LoopScopeContainer loopScopeEntry = (LoopScopeContainer)stackifierData.getScopeEntry(currentBlock.getBeginNode());
        Scope loopScope = loopScopeEntry.getLoopScope();
        this.genLoopHeader(currentBlock);
        this.lowerBlocks(loopScope.getSortedBlocks());
        this.genLoopEnd(currentBlock);
    }

    private void lowerWithExceptionStackifier(HIRBlock currentBlock, WithExceptionNode lastNode) {
        StackifierData stackifierData = (StackifierData)this.reconstructionData;
        HIRBlock normSucc = this.cfg.blockFor(lastNode.next());
        HIRBlock excpSucc = this.cfg.blockFor(lastNode.exceptionEdge());
        CatchScopeContainer scopeEntry = (CatchScopeContainer)stackifierData.getScopeEntry(lastNode);
        Scope catchScope = scopeEntry.getCatchScope();
        ExceptionObjectNode excpObj = (ExceptionObjectNode)excpSucc.getBeginNode();
        this.codeGenTool.genTryBlock();
        this.lowerNode(lastNode);
        this.generateForwardJump(currentBlock, normSucc, stackifierData);
        this.codeGenTool.genCatchBlockPrefix(this.codeGenTool.getExceptionObjectId(excpObj));
        if (catchScope != null) {
            this.lowerBlocks(catchScope.getSortedBlocks());
        } else {
            this.generateForwardJump(currentBlock, excpSucc, stackifierData);
        }
        this.codeGenTool.genScopeEnd();
    }

    private void lowerIfStackifier(HIRBlock currentBlock, IfNode lastNode) {
        StackifierData stackifierData = (StackifierData)this.reconstructionData;
        HIRBlock trueBlock = (HIRBlock)this.nodeToBlockMap.get(lastNode.trueSuccessor());
        HIRBlock falseBlock = (HIRBlock)this.nodeToBlockMap.get(lastNode.falseSuccessor());
        IfScopeContainer ifScopeContainer = (IfScopeContainer)stackifierData.getScopeEntry(lastNode);
        Scope thenScope = ifScopeContainer.getThenScope();
        Scope elseScope = ifScopeContainer.getElseScope();
        this.codeGenTool.genIfHeader(lastNode.condition());
        if (thenScope != null) {
            this.lowerBlocks(thenScope.getSortedBlocks());
        } else {
            this.generateForwardJump(currentBlock, trueBlock, stackifierData);
        }
        this.codeGenTool.genElseHeader();
        if (elseScope != null) {
            this.lowerBlocks(elseScope.getSortedBlocks());
        } else {
            this.generateForwardJump(currentBlock, falseBlock, stackifierData);
        }
        this.codeGenTool.genScopeEnd();
    }

    public static boolean labeledBlockEndsInLoop(LoopScopeContainer loopScopeContainer, LabeledBlock labeledBlock) {
        HIRBlock labeledBlockEnd = labeledBlock.getEnd();
        return loopScopeContainer.getLoopScope().getBlocks().contains((Object)labeledBlockEnd);
    }

    public void lowerSwitch(IntegerSwitchNode switchNode, StackifierData stackifierData) {
        this.codeGenTool.genSwitchHeader(switchNode.value());
        boolean hasdefault = switchNode.defaultSuccessor() != null;
        SwitchScopeContainer switchScopeEntry = (SwitchScopeContainer)stackifierData.getScopeEntry(switchNode);
        Scope[] caseScopes = switchScopeEntry.getCaseScopes();
        assert (caseScopes != null);
        for (int i = 0; i < switchNode.blockSuccessorCount(); ++i) {
            AbstractBeginNode succ = switchNode.blockSuccessor(i);
            if (hasdefault && succ.equals(switchNode.defaultSuccessor())) continue;
            ArrayList<Integer> succKeys = new ArrayList<Integer>();
            for (int keyIndex = 0; keyIndex < switchNode.keyCount(); ++keyIndex) {
                int key = switchNode.intKeyAt(keyIndex);
                AbstractBeginNode keySucc = switchNode.keySuccessor(keyIndex);
                if (!succ.equals(keySucc)) continue;
                succKeys.add(key);
            }
            assert (succKeys.size() > 0);
            int[] succk = new int[succKeys.size()];
            for (int s = 0; s < succKeys.size(); ++s) {
                succk[s] = (Integer)succKeys.get(s);
            }
            this.codeGenTool.genSwitchCase(succk);
            if (caseScopes[i] != null) {
                this.lowerBlocks(caseScopes[i].getSortedBlocks());
            } else {
                this.generateForwardJump(this.cfg.blockFor(switchNode), this.cfg.blockFor(succ), stackifierData);
            }
            this.codeGenTool.genBreak();
            this.codeGenTool.genScopeEnd();
        }
        if (hasdefault) {
            this.codeGenTool.genSwitchDefaultCase();
            int defaultIndex = switchNode.defaultSuccessorIndex();
            if (caseScopes[defaultIndex] != null) {
                this.lowerBlocks(caseScopes[defaultIndex].getSortedBlocks());
            } else {
                this.generateForwardJump(this.cfg.blockFor(switchNode), this.cfg.blockFor(switchNode.defaultSuccessor()), stackifierData);
            }
            this.codeGenTool.genBreak();
            this.codeGenTool.genScopeEnd();
        }
        this.codeGenTool.genScopeEnd();
    }

    private void genLabeledBlockHeader(LabeledBlock labeledBlock) {
        this.blockNestingVerifier.pushLabel(labeledBlock);
        this.codeGenTool.genLabeledBlockHeader(labeledBlock.getLabel());
    }

    private void genLabeledBlockEnd(LabeledBlock blockEnd) {
        if (blockEnd != null) {
            this.blockNestingVerifier.popLabel(blockEnd);
            this.codeGenTool.genScopeEnd();
            this.codeGenTool.genComment("End of LabeledBlock " + blockEnd.getLabel());
        }
    }

    private void genLoopHeader(HIRBlock block) {
        assert (block.isLoopHeader());
        String label = StackifierIRWalker.getLabel(block);
        this.blockNestingVerifier.pushLabel(label);
        this.codeGenTool.genLabel(label);
        this.codeGenTool.genWhileTrueHeader();
    }

    private void genLoopEnd(HIRBlock header) {
        assert (header.isLoopHeader());
        String label = StackifierIRWalker.getLabel(header);
        this.blockNestingVerifier.popLabel(label);
        this.codeGenTool.genBreak();
        this.codeGenTool.genScopeEnd();
        this.codeGenTool.genComment("End of loop " + label);
    }

    private static String getLabel(HIRBlock block) {
        assert (block.isLoopHeader());
        return LABEL_PREFIX + block.getId();
    }
}

