/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeIdAccessor;

public class NodeUnionFind
extends NodeIdAccessor {
    private int[] rank;
    private int[] parent;

    public NodeUnionFind(Graph graph) {
        super(graph);
        this.rank = new int[graph.nodeIdCount()];
        this.parent = new int[graph.nodeIdCount()];
        for (int i = 0; i < this.parent.length; ++i) {
            this.parent[i] = i;
        }
    }

    public void union(Node a, Node b) {
        this.union(this.getNodeId(a), this.getNodeId(b));
    }

    public Node find(Node a) {
        int id = this.find(this.getNodeId(a));
        return this.graph.getNode(id);
    }

    private void union(int a, int b) {
        int bRoot;
        int aRoot = this.find(a);
        if (aRoot != (bRoot = this.find(b))) {
            if (this.rank[aRoot] < this.rank[bRoot]) {
                this.parent[aRoot] = bRoot;
            } else {
                this.parent[bRoot] = aRoot;
                if (this.rank[aRoot] == this.rank[bRoot]) {
                    int n = aRoot;
                    this.rank[n] = this.rank[n] + 1;
                }
            }
        }
    }

    private int find(int a) {
        int ret = a;
        while (ret != this.parent[ret]) {
            this.parent[ret] = this.parent[this.parent[ret]];
            ret = this.parent[ret];
        }
        return ret;
    }
}

