/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.graalvm.compiler.debug.PathUtilitiesProvider;
import org.graalvm.compiler.debug.TTY;

public class StandardPathUtilitiesProvider
implements PathUtilitiesProvider {
    public static final String DIAGNOSTIC_OUTPUT_DIRECTORY_MESSAGE_FORMAT = "Graal diagnostic output saved in '%s'";
    public static final String DIAGNOSTIC_OUTPUT_DIRECTORY_MESSAGE_REGEXP = "Graal diagnostic output saved in '(?<filename>[^']+)'";

    @Override
    public String createDirectories(String path) throws IOException {
        Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        return path;
    }

    @Override
    public String getPath(String first, String ... more) {
        Path res = Paths.get(first, new String[0]);
        for (String e : more) {
            res = res.resolve(e);
        }
        return res.toString();
    }

    @Override
    public String getAbsolutePath(String path) {
        return new File(path).getAbsolutePath();
    }

    @Override
    public OutputStream openOutputStream(String path, boolean append) throws IOException {
        return new FileOutputStream(path, append);
    }

    @Override
    public InputStream openInputStream(String path) throws IOException {
        return new FileInputStream(path);
    }

    @Override
    public boolean exists(String path) {
        return new File(path).exists();
    }

    @Override
    public String sanitizeFileName(String name) {
        try {
            Path path = Paths.get(name, new String[0]);
            if (path.getNameCount() == 0) {
                return name;
            }
        }
        catch (InvalidPathException path) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != File.separatorChar && c != ' ' && !Character.isISOControl(c)) {
                try {
                    Paths.get(String.valueOf(c), new String[0]);
                    buf.append(c);
                    continue;
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
            buf.append('_');
        }
        return buf.toString();
    }

    @Override
    public String createFile(String path) throws IOException {
        Files.createFile(Paths.get(path, new String[0]), new FileAttribute[0]);
        return path;
    }

    @Override
    public boolean isDirectory(String path, boolean followLinks) {
        if (followLinks) {
            return Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0]);
        }
        return Files.isDirectory(Paths.get(path, new String[0]), LinkOption.NOFOLLOW_LINKS);
    }

    @Override
    public void deleteFile(String path) throws IOException {
        Files.delete(Paths.get(path, new String[0]));
    }

    @Override
    public String getParent(String path) {
        return new File(path).getParent();
    }

    @Override
    public WritableByteChannel openFileChannel(String path, OpenOption ... options) throws IOException {
        return FileChannel.open(Paths.get(path, new String[0]), options);
    }

    @Override
    public String archiveAndDelete(String directory, String zip) throws IOException {
        final Path dir = Paths.get(directory, new String[0]);
        if (dir.toFile().exists()) {
            final String prefix = new File(directory).getName() + "/";
            File zipFile = new File(zip).getAbsoluteFile();
            final ArrayList toDelete = new ArrayList();
            try {
                String string;
                final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
                try {
                    zos.setLevel(9);
                    Files.walkFileTree(dir, Collections.emptySet(), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (attrs.isRegularFile()) {
                                String name = prefix + dir.relativize(file).toString();
                                ZipEntry ze = new ZipEntry(name);
                                zos.putNextEntry(ze);
                                Files.copy(file, zos);
                                zos.closeEntry();
                            }
                            toDelete.add(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path d, IOException exc) throws IOException {
                            toDelete.add(d);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    TTY.println(DIAGNOSTIC_OUTPUT_DIRECTORY_MESSAGE_FORMAT, zipFile);
                    string = zipFile.getAbsolutePath();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            zos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        toDelete.clear();
                        throw new IOException("Error archiving " + dir + ". This directory will not be deleted and must be manually removed.", e);
                    }
                }
                zos.close();
                return string;
            }
            finally {
                if (!toDelete.isEmpty()) {
                    IOException lastDeletionError = null;
                    for (Path p : toDelete) {
                        try {
                            Files.delete(p);
                        }
                        catch (IOException e) {
                            lastDeletionError = e;
                        }
                    }
                    if (lastDeletionError != null) {
                        throw new IOException("Error deleting " + dir + ". This is most likely due to a compilation on another thread holding an open handle to a file within this directory. Please delete the directory manually once the VM exits.", lastDeletionError);
                    }
                }
            }
        }
        return null;
    }
}

