/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.KeyRegistry;
import org.graalvm.compiler.debug.MetricKey;

abstract class AbstractKey
implements MetricKey {
    private final String nameFormat;
    private final Object nameArg1;
    private final Object nameArg2;
    private String name;
    private int index;
    private String doc;

    protected AbstractKey(String nameFormat, Object nameArg1, Object nameArg2) {
        this.nameFormat = nameFormat;
        this.nameArg1 = nameArg1;
        this.nameArg2 = nameArg2;
        this.index = -1;
    }

    protected void setDoc(String doc) {
        this.doc = doc;
    }

    @Override
    public String getDoc() {
        return this.doc;
    }

    @Override
    public String getDocName() {
        return this.getName();
    }

    public long getCurrentValue(DebugContext debug) {
        this.ensureInitialized();
        return debug.getMetricValue(this.index);
    }

    void ensureInitialized() {
        if (this.index == -1) {
            this.index = KeyRegistry.register(this);
        }
    }

    void addToCurrentValue(DebugContext debug, long value) {
        this.ensureInitialized();
        debug.setMetricValue(this.index, debug.getMetricValue(this.index) + value);
    }

    public int getIndex() {
        this.ensureInitialized();
        return this.index;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.createName(this.nameFormat, this.nameArg1, this.nameArg2);
        }
        return this.name;
    }

    protected String createName(String format, Object arg1, Object arg2) {
        return DebugContext.formatDebugName(format, arg1, arg2);
    }

    public String toString() {
        return this.getName() + "@" + this.index;
    }
}

