/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.match;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.gen.NodeLIRBuilder;
import org.graalvm.compiler.core.match.ComplexMatchResult;
import org.graalvm.compiler.core.match.ComplexMatchValue;
import org.graalvm.compiler.core.match.MatchPattern;
import org.graalvm.compiler.core.match.MatchStatement;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

public class MatchContext {
    private static final CounterKey MatchContextSuccessDifferentBlocks = DebugContext.counter("MatchContextSuccessDifferentBlocks");
    private final Node root;
    private final MatchStatement rule;
    private final StructuredGraph.ScheduleResult schedule;
    private EconomicMap<String, NamedNode> namedNodes;
    private ConsumedNodes consumed = new ConsumedNodes();
    private HIRBlock rootBlock;
    private int rootIndex;
    private int emitIndex;
    private HIRBlock emitBlock;
    private final NodeLIRBuilder builder;

    public MatchContext(NodeLIRBuilder builder, MatchStatement rule, int index, Node node, HIRBlock rootBlock, StructuredGraph.ScheduleResult schedule) {
        this.builder = builder;
        this.rule = rule;
        this.root = node;
        assert (index == schedule.getBlockToNodesMap().get(rootBlock).indexOf(node));
        this.schedule = schedule;
        this.rootBlock = rootBlock;
        this.rootIndex = index;
    }

    public Node getRoot() {
        return this.root;
    }

    public MatchStatement getRule() {
        return this.rule;
    }

    public MatchPattern.Result captureNamedValue(String name, Class<? extends Node> type, Node value) {
        NamedNode current;
        if (this.namedNodes == null) {
            this.namedNodes = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        }
        if ((current = (NamedNode)this.namedNodes.get((Object)name)) == null) {
            current = new NamedNode(type, value);
            this.namedNodes.put((Object)name, (Object)current);
            return MatchPattern.Result.OK;
        }
        if (current.value != value || current.type != type) {
            return MatchPattern.Result.namedValueMismatch(value, this.rule.getPattern());
        }
        return MatchPattern.Result.OK;
    }

    public MatchPattern.Result validate() {
        MatchPattern.Result result = this.findEarlyPosition();
        if (result != MatchPattern.Result.OK) {
            return result;
        }
        this.findLatePosition();
        assert (this.emitIndex == this.rootIndex || this.consumed.find((Node)this.root).ignoresSideEffects);
        return this.verifyInputs();
    }

    private MatchPattern.Result findEarlyPosition() {
        int startIndexSideEffect = -1;
        int endIndexSideEffect = -1;
        NodeMap<HIRBlock> nodeToBlockMap = this.schedule.getNodeToBlockMap();
        BlockMap<List<Node>> blockToNodesMap = this.schedule.getBlockToNodesMap();
        for (ConsumedNode cn : this.consumed) {
            if (cn.ignoresSideEffects) continue;
            HIRBlock b = nodeToBlockMap.get(cn.node);
            if (this.emitBlock == null) {
                this.emitBlock = b;
                startIndexSideEffect = endIndexSideEffect = blockToNodesMap.get(b).indexOf(cn.node);
                continue;
            }
            if (this.emitBlock == b) {
                int index = blockToNodesMap.get(b).indexOf(cn.node);
                startIndexSideEffect = Math.min(startIndexSideEffect, index);
                endIndexSideEffect = Math.max(endIndexSideEffect, index);
                continue;
            }
            this.logFailedMatch("nodes affected by side effects in different blocks %s", cn.node);
            return MatchPattern.Result.notInBlock(cn.node, this.rule.getPattern());
        }
        if (this.emitBlock != null) {
            assert (startIndexSideEffect != -1 && endIndexSideEffect != -1);
            List<Node> nodes = blockToNodesMap.get(this.emitBlock);
            for (int i = startIndexSideEffect; i <= endIndexSideEffect; ++i) {
                Node node = nodes.get(i);
                if (MatchContext.sideEffectFree(node) || this.consumed.contains(node)) continue;
                this.logFailedMatch("unexpected side effect %s", node);
                return MatchPattern.Result.notSafe(node, this.rule.getPattern());
            }
            this.emitIndex = endIndexSideEffect;
        } else {
            this.emitBlock = nodeToBlockMap.get(this.root);
            this.emitIndex = this.rootIndex;
        }
        return MatchPattern.Result.OK;
    }

    private static boolean sideEffectFree(Node node) {
        return node instanceof VirtualObjectNode || node instanceof FloatingNode || node instanceof VirtualState;
    }

    private void findLatePosition() {
        int index = this.rootIndex;
        if (this.emitBlock != this.rootBlock) {
            index = this.schedule.getBlockToNodesMap().get(this.emitBlock).size() - 1;
        }
        List<Node> emitBlockNodes = this.schedule.getBlockToNodesMap().get(this.emitBlock);
        for (int i = this.emitIndex + 1; i <= index; ++i) {
            Node node = emitBlockNodes.get(i);
            ConsumedNode cn = this.consumed.find(node);
            if (cn == null) {
                if (MatchContext.sideEffectFree(node)) continue;
                return;
            }
            assert (cn.ignoresSideEffects);
            this.emitIndex = i;
        }
    }

    private MatchPattern.Result verifyInputs() {
        DebugContext debug = this.root.getDebug();
        if (this.emitBlock != this.rootBlock) {
            assert (this.consumed.find((Node)this.root).ignoresSideEffects);
            MatchPattern.Result result = this.verifyInputsDifferentBlock(this.root);
            if (result == MatchPattern.Result.OK) {
                MatchContextSuccessDifferentBlocks.increment(debug);
            }
            return result;
        }
        List<Node> nodes = this.schedule.getBlockToNodesMap().get(this.rootBlock);
        for (int i = this.emitIndex + 1; i <= this.rootIndex; ++i) {
            Node node = nodes.get(i);
            ConsumedNode cn = this.consumed.find(node);
            if (cn == null) continue;
            assert (cn.ignoresSideEffects);
            for (Node in : node.inputs()) {
                if (this.consumed.contains(in)) continue;
                for (int j = this.emitIndex + 1; j < i; ++j) {
                    if (nodes.get(j) != in) continue;
                    this.logFailedMatch("Earliest position in block is too late %s", in);
                    assert (this.consumed.find((Node)this.root).ignoresSideEffects);
                    assert (this.verifyInputsDifferentBlock(this.root) != MatchPattern.Result.OK);
                    return MatchPattern.Result.tooLate(node, this.rule.getPattern());
                }
            }
        }
        assert (this.verifyInputsDifferentBlock(this.root) == MatchPattern.Result.OK);
        return MatchPattern.Result.OK;
    }

    private MatchPattern.Result verifyInputsDifferentBlock(Node node) {
        for (Node in : node.inputs()) {
            HIRBlock b;
            if (!(in instanceof PhiNode) ? (b = this.schedule.getNodeToBlockMap().get(in)).strictlyDominates(this.emitBlock) || b == this.emitBlock && this.schedule.getBlockToNodesMap().get(this.emitBlock).indexOf(in) <= this.emitIndex : (b = this.schedule.getNodeToBlockMap().get(((PhiNode)in).merge())).dominates(this.emitBlock)) continue;
            ConsumedNode cn = this.consumed.find(in);
            if (cn == null) {
                this.logFailedMatch("Earliest position in block is too late %s", in);
                return MatchPattern.Result.tooLate(node, this.rule.getPattern());
            }
            assert (cn.ignoresSideEffects);
            MatchPattern.Result res = this.verifyInputsDifferentBlock(in);
            if (res == MatchPattern.Result.OK) continue;
            return res;
        }
        return MatchPattern.Result.OK;
    }

    private void logFailedMatch(String s, Node node) {
        if (DebugOptions.LogVerbose.getValue(this.root.getOptions()).booleanValue()) {
            DebugContext debug = this.root.getDebug();
            debug.log(s, node);
            int startIndex = this.emitIndex;
            if (this.emitBlock != this.rootBlock) {
                int endIndex = this.schedule.getBlockToNodesMap().get(this.emitBlock).size() - 1;
                List<Node> emitBlockNodes = this.schedule.getBlockToNodesMap().get(this.emitBlock);
                debug.log("%s:", this.emitBlock);
                for (int j = startIndex; j <= endIndex; ++j) {
                    Node theNode = emitBlockNodes.get(j);
                    debug.log("%s(%s) %1s", (Object)(this.consumed.contains(theNode) ? "*" : " "), (Object)theNode.getUsageCount(), (Object)theNode);
                }
                startIndex = 0;
            }
            debug.log("%s:", this.rootBlock);
            List<Node> nodes = this.schedule.getBlockToNodesMap().get(this.rootBlock);
            for (int j = startIndex; j <= this.rootIndex; ++j) {
                Node theNode = nodes.get(j);
                debug.log("%s(%s) %1s", (Object)(this.consumed.contains(theNode) ? "*" : " "), (Object)theNode.getUsageCount(), (Object)theNode);
            }
        }
    }

    public void setResult(ComplexMatchResult result) {
        ComplexMatchValue value = new ComplexMatchValue(result);
        Node emitNode = this.schedule.getBlockToNodesMap().get(this.emitBlock).get(this.emitIndex);
        DebugContext debug = this.root.getDebug();
        if (debug.isLogEnabled()) {
            debug.log("matched %s %s%s", (Object)this.rule.getName(), (Object)this.rule.getPattern(), (Object)(this.emitIndex != this.rootIndex ? " skipping side effects" : ""));
            debug.log("with nodes %s", (Object)this.rule.formatMatch(this.root));
        }
        for (ConsumedNode cn : this.consumed) {
            if (cn.node == this.root || cn.node == emitNode) continue;
            this.setResult(cn);
        }
        this.builder.setMatchResult(emitNode, value);
        if (this.root != emitNode) {
            this.builder.setMatchResult(this.root, new ComplexMatchValue(gen -> gen.operand(emitNode)));
        }
    }

    private void setResult(ConsumedNode consumedNode) {
        Node node = consumedNode.node;
        if (consumedNode.singleUser) {
            this.builder.setMatchResult(node, ComplexMatchValue.INTERIOR_MATCH);
            return;
        }
        this.builder.incrementSharedMatchCount(node);
    }

    public MatchPattern.Result consume(Node node, boolean ignoresSideEffects, boolean atRoot, boolean singleUser) {
        if (atRoot) {
            this.consumed.add(node, ignoresSideEffects, singleUser);
            return MatchPattern.Result.OK;
        }
        if (this.builder.hasOperand(node)) {
            return MatchPattern.Result.alreadyUsed(node, this.rule.getPattern());
        }
        this.consumed.add(node, ignoresSideEffects, singleUser);
        return MatchPattern.Result.OK;
    }

    public Node namedNode(String name) {
        NamedNode value;
        if (this.namedNodes != null && (value = (NamedNode)this.namedNodes.get((Object)name)) != null) {
            return value.value;
        }
        throw new GraalError("missing node %s", name);
    }

    public String toString() {
        return String.format("%s %s (%s/%d, %s/%d) consumed %s", this.rule, this.root, this.rootBlock, this.rootIndex, this.emitBlock, this.emitIndex, this.consumed);
    }

    static final class ConsumedNodes
    implements Iterable<ConsumedNode> {
        private ArrayList<ConsumedNode> nodes = null;

        ConsumedNodes() {
        }

        public void add(Node node, boolean ignoresSideEffects, boolean singlerUser) {
            if (this.nodes == null) {
                this.nodes = new ArrayList(2);
            }
            this.nodes.add(new ConsumedNode(node, ignoresSideEffects, singlerUser));
        }

        public boolean contains(Node node) {
            for (ConsumedNode c : this.nodes) {
                if (c.node != node) continue;
                return true;
            }
            return false;
        }

        public ConsumedNode find(Node node) {
            for (ConsumedNode c : this.nodes) {
                if (c.node != node) continue;
                return c;
            }
            return null;
        }

        public String toString() {
            Object[] arr = new Node[this.nodes.size()];
            int i = 0;
            for (ConsumedNode c : this.nodes) {
                arr[i++] = c.node;
            }
            return Arrays.toString(arr);
        }

        @Override
        public Iterator<ConsumedNode> iterator() {
            return this.nodes.iterator();
        }
    }

    private static class NamedNode {
        final Class<? extends Node> type;
        final Node value;

        NamedNode(Class<? extends Node> type, Node value) {
            this.type = type;
            this.value = value;
        }
    }

    static final class ConsumedNode {
        final Node node;
        final boolean ignoresSideEffects;
        final boolean singleUser;

        ConsumedNode(Node node, boolean ignoresSideEffects, boolean singleUser) {
            this.node = node;
            this.ignoresSideEffects = ignoresSideEffects;
            this.singleUser = singleUser;
        }
    }
}

