/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.type;

import java.util.Objects;
import org.graalvm.compiler.core.common.type.Stamp;

public final class StampPair {
    private final Stamp trustedStamp;
    private final Stamp uncheckedStamp;

    private StampPair(Stamp trustedStamp, Stamp uncheckedStamp) {
        assert (trustedStamp != null);
        this.trustedStamp = trustedStamp;
        this.uncheckedStamp = uncheckedStamp;
    }

    public static StampPair create(Stamp trustedStamp, Stamp uncheckedStamp) {
        return new StampPair(trustedStamp, uncheckedStamp);
    }

    public static StampPair createSingle(Stamp stamp) {
        return new StampPair(stamp, null);
    }

    public Stamp getUncheckedStamp() {
        return this.uncheckedStamp;
    }

    public Stamp getTrustedStamp() {
        return this.trustedStamp;
    }

    public String toString() {
        if (this.uncheckedStamp == null) {
            return this.trustedStamp.toString();
        }
        return this.trustedStamp + " (unchecked=" + this.uncheckedStamp + ")";
    }

    public int hashCode() {
        return this.trustedStamp.hashCode() + 11 + (this.uncheckedStamp != null ? this.uncheckedStamp.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StampPair) {
            StampPair other = (StampPair)obj;
            return this.trustedStamp.equals(other.trustedStamp) && Objects.equals(this.uncheckedStamp, other.uncheckedStamp);
        }
        return false;
    }
}

