/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.cfg;

import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Set;
import java.util.stream.Stream;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.core.common.cfg.BlockMap;

public abstract class DominatorOptimizationProblem<E extends Enum<E>, C> {
    private BasicBlock<?>[] blocks;
    private EnumMap<E, BitSet> flags;
    private BlockMap<C> costs;

    protected DominatorOptimizationProblem(Class<E> flagType, AbstractControlFlowGraph<?> cfg) {
        this.blocks = cfg.getBlocks();
        this.flags = new EnumMap(flagType);
        this.costs = new BlockMap(cfg);
        assert (DominatorOptimizationProblem.verify(this.blocks));
    }

    private static boolean verify(BasicBlock<?>[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            BasicBlock<?> block = blocks[i];
            if (i == block.getId()) continue;
            assert (false) : String.format("Id index mismatch @ %d vs. %s.getId()==%d", i, block, block.getId());
            return false;
        }
        return true;
    }

    public final BasicBlock<?>[] getBlocks() {
        return this.blocks;
    }

    public final BasicBlock<?> getBlockForId(int id) {
        BasicBlock<?> block = this.blocks[id];
        assert (block.getId() == id) : "wrong block-to-id mapping";
        return block;
    }

    public final void set(E flag, BasicBlock<?> block) {
        BitSet bitSet = this.flags.get(flag);
        if (bitSet == null) {
            bitSet = new BitSet(this.blocks.length);
            this.flags.put(flag, bitSet);
        }
        bitSet.set(block.getId());
    }

    public final boolean get(E flag, BasicBlock<?> block) {
        BitSet bitSet = this.flags.get(flag);
        return bitSet == null ? false : bitSet.get(block.getId());
    }

    public final Stream<? extends BasicBlock<?>> stream(E flag) {
        return Arrays.asList(this.getBlocks()).stream().filter(block -> this.get(flag, (BasicBlock<?>)block));
    }

    public final C getCost(BasicBlock<?> block) {
        C cost = this.costs.get(block);
        return cost;
    }

    public final void setCost(BasicBlock<?> block, C cost) {
        this.costs.put(block, cost);
    }

    public final void setDominatorPath(E flag, BasicBlock<?> block) {
        BitSet bitSet = this.flags.get(flag);
        if (bitSet == null) {
            bitSet = new BitSet(this.blocks.length);
            this.flags.put(flag, bitSet);
        }
        for (BasicBlock<?> b = block; b != null && !bitSet.get(b.getId()); b = b.getDominator()) {
            bitSet.set(b.getId());
        }
    }

    public final Set<E> getFlags() {
        return this.flags.keySet();
    }

    public String getName(E flag) {
        return ((Enum)flag).toString();
    }
}

