/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;

public enum Condition {
    EQ("=="),
    NE("!="),
    LT("<"),
    LE("<="),
    GT(">"),
    GE(">="),
    AE("|>=|"),
    BE("|<=|"),
    AT("|>|"),
    BT("|<|");

    public final String operator;

    private Condition(String operator) {
        this.operator = operator;
    }

    public boolean check(int left, int right) {
        switch (this) {
            case EQ: {
                return left == right;
            }
            case NE: {
                return left != right;
            }
            case LT: {
                return left < right;
            }
            case LE: {
                return left <= right;
            }
            case GT: {
                return left > right;
            }
            case GE: {
                return left >= right;
            }
            case AE: {
                return UnsignedMath.aboveOrEqual(left, right);
            }
            case BE: {
                return UnsignedMath.belowOrEqual(left, right);
            }
            case AT: {
                return UnsignedMath.aboveThan(left, right);
            }
            case BT: {
                return UnsignedMath.belowThan(left, right);
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public CanonicalizedCondition canonicalize() {
        return new CanonicalizedCondition(switch (this) {
            case EQ, NE -> CanonicalCondition.EQ;
            case LT, LE, GT, GE -> CanonicalCondition.LT;
            case AE, BE, AT, BT -> CanonicalCondition.BT;
            default -> throw new IllegalArgumentException(this.toString());
        }, this.canonicalMirror(), this.canonicalNegate());
    }

    public boolean isCanonical() {
        switch (this) {
            case EQ: {
                return true;
            }
            case NE: {
                return false;
            }
            case LT: {
                return true;
            }
            case LE: {
                return false;
            }
            case GT: {
                return false;
            }
            case GE: {
                return false;
            }
            case BT: {
                return true;
            }
            case BE: {
                return false;
            }
            case AT: {
                return false;
            }
            case AE: {
                return false;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public boolean canonicalMirror() {
        switch (this) {
            case EQ: {
                return false;
            }
            case NE: {
                return false;
            }
            case LT: {
                return false;
            }
            case LE: {
                return true;
            }
            case GT: {
                return true;
            }
            case GE: {
                return false;
            }
            case BT: {
                return false;
            }
            case BE: {
                return true;
            }
            case AT: {
                return true;
            }
            case AE: {
                return false;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public boolean canonicalNegate() {
        switch (this) {
            case EQ: {
                return false;
            }
            case NE: {
                return true;
            }
            case LT: {
                return false;
            }
            case LE: {
                return true;
            }
            case GT: {
                return false;
            }
            case GE: {
                return true;
            }
            case BT: {
                return false;
            }
            case BE: {
                return true;
            }
            case AT: {
                return false;
            }
            case AE: {
                return true;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public final Condition negate() {
        switch (this) {
            case EQ: {
                return NE;
            }
            case NE: {
                return EQ;
            }
            case LT: {
                return GE;
            }
            case LE: {
                return GT;
            }
            case GT: {
                return LE;
            }
            case GE: {
                return LT;
            }
            case BT: {
                return AE;
            }
            case BE: {
                return AT;
            }
            case AT: {
                return BE;
            }
            case AE: {
                return BT;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public boolean implies(Condition other) {
        if (other == this) {
            return true;
        }
        switch (this) {
            case EQ: {
                return other == LE || other == GE || other == BE || other == AE;
            }
            case NE: {
                return false;
            }
            case LT: {
                return other == LE || other == NE;
            }
            case LE: {
                return false;
            }
            case GT: {
                return other == GE || other == NE;
            }
            case GE: {
                return false;
            }
            case BT: {
                return other == BE || other == NE;
            }
            case BE: {
                return false;
            }
            case AT: {
                return other == AE || other == NE;
            }
            case AE: {
                return false;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public final Condition mirror() {
        switch (this) {
            case EQ: {
                return EQ;
            }
            case NE: {
                return NE;
            }
            case LT: {
                return GT;
            }
            case LE: {
                return GE;
            }
            case GT: {
                return LT;
            }
            case GE: {
                return LE;
            }
            case BT: {
                return AT;
            }
            case BE: {
                return AE;
            }
            case AT: {
                return BT;
            }
            case AE: {
                return BE;
            }
        }
        throw new IllegalArgumentException();
    }

    public final boolean isUnsigned() {
        return this == BT || this == BE || this == AT || this == AE;
    }

    public final boolean isCommutative() {
        return this == EQ || this == NE;
    }

    public TriState foldCondition(Stamp compareStamp, Constant lt, Constant rt, ConstantReflectionProvider constantReflection, boolean unorderedIsTrue) {
        return compareStamp.tryConstantFold(this, lt, rt, unorderedIsTrue, constantReflection);
    }

    public boolean foldCondition(PrimitiveConstant lp, PrimitiveConstant rp, boolean unorderedIsTrue) {
        switch (lp.getJavaKind()) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: {
                int x = lp.asInt();
                int y = rp.asInt();
                switch (this) {
                    case EQ: {
                        return x == y;
                    }
                    case NE: {
                        return x != y;
                    }
                    case LT: {
                        return x < y;
                    }
                    case LE: {
                        return x <= y;
                    }
                    case GT: {
                        return x > y;
                    }
                    case GE: {
                        return x >= y;
                    }
                    case AE: {
                        return UnsignedMath.aboveOrEqual(x, y);
                    }
                    case BE: {
                        return UnsignedMath.belowOrEqual(x, y);
                    }
                    case AT: {
                        return UnsignedMath.aboveThan(x, y);
                    }
                    case BT: {
                        return UnsignedMath.belowThan(x, y);
                    }
                }
                throw new GraalError("expected condition: %s", new Object[]{this});
            }
            case Long: {
                long x = lp.asLong();
                long y = rp.asLong();
                switch (this) {
                    case EQ: {
                        return x == y;
                    }
                    case NE: {
                        return x != y;
                    }
                    case LT: {
                        return x < y;
                    }
                    case LE: {
                        return x <= y;
                    }
                    case GT: {
                        return x > y;
                    }
                    case GE: {
                        return x >= y;
                    }
                    case AE: {
                        return UnsignedMath.aboveOrEqual(x, y);
                    }
                    case BE: {
                        return UnsignedMath.belowOrEqual(x, y);
                    }
                    case AT: {
                        return UnsignedMath.aboveThan(x, y);
                    }
                    case BT: {
                        return UnsignedMath.belowThan(x, y);
                    }
                }
                throw new GraalError("expected condition: %s", new Object[]{this});
            }
            case Float: {
                float x = lp.asFloat();
                float y = rp.asFloat();
                if (Float.isNaN(x) || Float.isNaN(y)) {
                    return unorderedIsTrue;
                }
                switch (this) {
                    case EQ: {
                        return x == y;
                    }
                    case NE: {
                        return x != y;
                    }
                    case LT: {
                        return x < y;
                    }
                    case LE: {
                        return x <= y;
                    }
                    case GT: {
                        return x > y;
                    }
                    case GE: {
                        return x >= y;
                    }
                }
                throw new GraalError("expected condition: %s", new Object[]{this});
            }
            case Double: {
                double x = lp.asDouble();
                double y = rp.asDouble();
                if (Double.isNaN(x) || Double.isNaN(y)) {
                    return unorderedIsTrue;
                }
                switch (this) {
                    case EQ: {
                        return x == y;
                    }
                    case NE: {
                        return x != y;
                    }
                    case LT: {
                        return x < y;
                    }
                    case LE: {
                        return x <= y;
                    }
                    case GT: {
                        return x > y;
                    }
                    case GE: {
                        return x >= y;
                    }
                }
                throw new GraalError("expected condition: %s", new Object[]{this});
            }
        }
        throw new GraalError("expected value kind %s while folding condition: %s", new Object[]{lp.getJavaKind(), this});
    }

    private static boolean in(Condition needle, Condition ... haystack) {
        for (Condition c : haystack) {
            if (c != needle) continue;
            return true;
        }
        return false;
    }

    public boolean trueIsDisjoint(Condition other) {
        if (other == this) {
            return false;
        }
        switch (this) {
            case EQ: {
                return Condition.in(other, NE, LT, GT, AT, BT);
            }
            case NE: {
                return other == EQ;
            }
            case LT: {
                return Condition.in(other, EQ, GT, GE);
            }
            case LE: {
                return other == GT;
            }
            case GT: {
                return Condition.in(other, EQ, LT, LE);
            }
            case GE: {
                return other == LT;
            }
            case AE: {
                return other == BT;
            }
            case BE: {
                return other == AT;
            }
            case AT: {
                return Condition.in(other, EQ, BE, BT);
            }
            case BT: {
                return Condition.in(other, EQ, AE, AT);
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public Condition join(Condition other) {
        if (other == this) {
            return this;
        }
        switch (this) {
            case EQ: {
                if (other == LE || other == GE || other == BE || other == AE) {
                    return EQ;
                }
                return null;
            }
            case NE: {
                if (other == LT || other == GT || other == BT || other == AT) {
                    return other;
                }
                if (other == LE) {
                    return LT;
                }
                if (other == GE) {
                    return GT;
                }
                if (other == BE) {
                    return BT;
                }
                if (other == AE) {
                    return AT;
                }
                return null;
            }
            case LE: {
                if (other == GE || other == EQ) {
                    return EQ;
                }
                if (other == NE || other == LT) {
                    return LT;
                }
                return null;
            }
            case LT: {
                if (other == NE || other == LE) {
                    return LT;
                }
                return null;
            }
            case GE: {
                if (other == LE || other == EQ) {
                    return EQ;
                }
                if (other == NE || other == GT) {
                    return GT;
                }
                return null;
            }
            case GT: {
                if (other == NE || other == GE) {
                    return GT;
                }
                return null;
            }
            case BE: {
                if (other == AE || other == EQ) {
                    return EQ;
                }
                if (other == NE || other == BT) {
                    return BT;
                }
                return null;
            }
            case BT: {
                if (other == NE || other == BE) {
                    return BT;
                }
                return null;
            }
            case AE: {
                if (other == BE || other == EQ) {
                    return EQ;
                }
                if (other == NE || other == AT) {
                    return AT;
                }
                return null;
            }
            case AT: {
                if (other == NE || other == AE) {
                    return AT;
                }
                return null;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public Condition meet(Condition other) {
        if (other == this) {
            return this;
        }
        switch (this) {
            case EQ: {
                if (other == LE || other == GE || other == BE || other == AE) {
                    return other;
                }
                if (other == LT) {
                    return LE;
                }
                if (other == GT) {
                    return GE;
                }
                if (other == BT) {
                    return BE;
                }
                if (other == AT) {
                    return AE;
                }
                return null;
            }
            case NE: {
                if (other == LT || other == GT || other == BT || other == AT) {
                    return NE;
                }
                return null;
            }
            case LE: {
                if (other == EQ || other == LT) {
                    return LE;
                }
                return null;
            }
            case LT: {
                if (other == EQ || other == LE) {
                    return LE;
                }
                if (other == NE || other == GT) {
                    return NE;
                }
                return null;
            }
            case GE: {
                if (other == EQ || other == GT) {
                    return GE;
                }
                return null;
            }
            case GT: {
                if (other == EQ || other == GE) {
                    return GE;
                }
                if (other == NE || other == LT) {
                    return NE;
                }
                return null;
            }
            case BE: {
                if (other == EQ || other == BT) {
                    return BE;
                }
                return null;
            }
            case BT: {
                if (other == EQ || other == BE) {
                    return BE;
                }
                if (other == NE || other == AT) {
                    return NE;
                }
                return null;
            }
            case AE: {
                if (other == EQ || other == AT) {
                    return AE;
                }
                return null;
            }
            case AT: {
                if (other == EQ || other == AE) {
                    return AE;
                }
                if (other == NE || other == BT) {
                    return NE;
                }
                return null;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public static final class CanonicalizedCondition {
        private final CanonicalCondition canonicalCondition;
        private final boolean mirror;
        private final boolean negate;

        private CanonicalizedCondition(CanonicalCondition canonicalCondition, boolean mirror, boolean negate) {
            this.canonicalCondition = canonicalCondition;
            this.mirror = mirror;
            this.negate = negate;
        }

        public CanonicalCondition getCanonicalCondition() {
            return this.canonicalCondition;
        }

        public boolean mustMirror() {
            return this.mirror;
        }

        public boolean mustNegate() {
            return this.negate;
        }
    }
}

