/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.core.amd64.AMD64AddressNode;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.phases.common.AddressLoweringByNodePhase;

public class AMD64AddressLowering
extends AddressLoweringByNodePhase.AddressLowering {
    private static final int ADDRESS_BITS = 64;

    @Override
    public AddressNode lower(ValueNode base, ValueNode offset) {
        boolean changed;
        AMD64AddressNode ret = new AMD64AddressNode(base, offset);
        StructuredGraph graph = base.graph();
        while (changed = this.improve(graph, base.getDebug(), ret, false, false)) {
        }
        assert (AMD64AddressLowering.checkAddressBitWidth(ret.getBase()));
        assert (AMD64AddressLowering.checkAddressBitWidth(ret.getIndex()));
        return graph.unique(ret);
    }

    private static boolean checkAddressBitWidth(ValueNode value) {
        return value == null || value.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp || IntegerStamp.getBits(value.stamp(NodeView.DEFAULT)) == 64;
    }

    protected boolean improve(StructuredGraph graph, DebugContext debug, AMD64AddressNode ret, boolean isBaseNegated, boolean isIndexNegated) {
        int amount;
        LeftShiftNode shift;
        ValueNode newBase = AMD64AddressLowering.improveInput(ret, ret.getBase(), 0, isBaseNegated);
        if (newBase != ret.getBase()) {
            ret.setBase(newBase);
            return true;
        }
        ValueNode newIdx = AMD64AddressLowering.improveInput(ret, ret.getIndex(), ret.getScale().log2, isIndexNegated);
        if (newIdx != ret.getIndex()) {
            ret.setIndex(newIdx);
            return true;
        }
        if (ret.getIndex() instanceof LeftShiftNode && (shift = (LeftShiftNode)ret.getIndex()).getY().isConstant() && AMD64Address.isScaleShiftSupported(amount = ret.getScale().log2 + shift.getY().asJavaConstant().asInt())) {
            ret.setIndex(shift.getX());
            ret.setScale(Stride.fromLog2(amount));
            return true;
        }
        if (ret.getScale() == Stride.S1) {
            AddNode add;
            if (ret.getIndex() == null && ret.getBase() instanceof AddNode) {
                add = (AddNode)ret.getBase();
                ret.setBase(add.getX());
                ret.setIndex(AMD64AddressLowering.considerNegation(graph, add.getY(), isBaseNegated));
                return true;
            }
            if (ret.getBase() == null && ret.getIndex() instanceof AddNode) {
                add = (AddNode)ret.getIndex();
                ret.setBase(AMD64AddressLowering.considerNegation(graph, add.getX(), isIndexNegated));
                ret.setIndex(add.getY());
                return true;
            }
            if (ret.getBase() instanceof LeftShiftNode && !(ret.getIndex() instanceof LeftShiftNode)) {
                ValueNode tmp = ret.getBase();
                ret.setBase(AMD64AddressLowering.considerNegation(graph, ret.getIndex(), isIndexNegated != isBaseNegated));
                ret.setIndex(AMD64AddressLowering.considerNegation(graph, tmp, isIndexNegated != isBaseNegated));
                return true;
            }
        }
        return this.improveNegation(graph, debug, ret, isBaseNegated, isIndexNegated);
    }

    private boolean improveNegation(StructuredGraph graph, DebugContext debug, AMD64AddressNode ret, boolean originalBaseNegated, boolean originalIndexNegated) {
        NegateNode negate;
        boolean baseNegated = originalBaseNegated;
        boolean indexNegated = originalIndexNegated;
        ValueNode originalBase = ret.getBase();
        ValueNode originalIndex = ret.getIndex();
        if (ret.getBase() instanceof NegateNode) {
            negate = (NegateNode)ret.getBase();
            ret.setBase(negate.getValue());
            boolean bl = baseNegated = !baseNegated;
        }
        if (ret.getIndex() instanceof NegateNode) {
            negate = (NegateNode)ret.getIndex();
            ret.setIndex(negate.getValue());
            boolean bl = indexNegated = !indexNegated;
        }
        if (baseNegated != originalBaseNegated || indexNegated != originalIndexNegated) {
            ValueNode base = ret.getBase();
            ValueNode index = ret.getIndex();
            boolean improved = this.improve(graph, debug, ret, baseNegated, indexNegated);
            if (baseNegated != originalBaseNegated) {
                if (base == ret.getBase()) {
                    ret.setBase(originalBase);
                } else if (ret.getBase() != null) {
                    ret.setBase(graph.addOrUnique(NegateNode.create(ret.getBase(), NodeView.DEFAULT)));
                }
            }
            if (indexNegated != originalIndexNegated) {
                if (index == ret.getIndex()) {
                    ret.setIndex(originalIndex);
                } else if (ret.getIndex() != null) {
                    ret.setIndex(graph.addOrUnique(NegateNode.create(ret.getIndex(), NodeView.DEFAULT)));
                }
            }
            return improved;
        }
        assert (ret.getBase() == originalBase && ret.getIndex() == originalIndex);
        return false;
    }

    private static ValueNode considerNegation(StructuredGraph graph, ValueNode value, boolean negate) {
        if (negate && value != null) {
            return graph.addOrUnique(NegateNode.create(value, NodeView.DEFAULT));
        }
        return value;
    }

    private static ValueNode improveInput(AMD64AddressNode address, ValueNode node, int shift, boolean negateExtractedDisplacement) {
        if (node == null) {
            return null;
        }
        JavaConstant c = node.asJavaConstant();
        if (c != null) {
            return AMD64AddressLowering.improveConstDisp(address, node, c, null, shift, negateExtractedDisplacement);
        }
        if (node.stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
            assert (IntegerStamp.getBits(node.stamp(NodeView.DEFAULT)) == 64);
            if (node instanceof AddNode) {
                AddNode add = (AddNode)node;
                if (add.getX().isConstant()) {
                    return AMD64AddressLowering.improveConstDisp(address, node, add.getX().asJavaConstant(), add.getY(), shift, negateExtractedDisplacement);
                }
                if (add.getY().isConstant()) {
                    return AMD64AddressLowering.improveConstDisp(address, node, add.getY().asJavaConstant(), add.getX(), shift, negateExtractedDisplacement);
                }
            }
        }
        return node;
    }

    private static ValueNode improveConstDisp(AMD64AddressNode address, ValueNode original, JavaConstant c, ValueNode other, int shift, boolean negateExtractedDisplacement) {
        long delta;
        if (c.getJavaKind().isNumericInteger() && AMD64AddressLowering.updateDisplacement(address, delta = c.asLong() << shift, negateExtractedDisplacement)) {
            return other;
        }
        return original;
    }

    protected static boolean updateDisplacement(AMD64AddressNode address, long displacementDelta, boolean negateDelta) {
        long sign = negateDelta ? -1L : 1L;
        long disp = (long)address.getDisplacement() + displacementDelta * sign;
        if (NumUtil.isInt(disp)) {
            address.setDisplacement((int)disp);
            return true;
        }
        return false;
    }
}

