/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.VectorSize;
import org.graalvm.compiler.debug.GraalError;

public final class AVXKind {
    private AVXKind() {
    }

    public static AVXSize getRegisterSize(Value a) {
        AMD64Kind kind = (AMD64Kind)a.getPlatformKind();
        if (kind.isXMM()) {
            return AVXKind.getRegisterSize(kind);
        }
        return AVXSize.XMM;
    }

    public static AVXSize getDataSize(AMD64Kind kind) {
        assert (kind.isXMM()) : "unexpected kind " + kind;
        switch (kind.getSizeInBytes()) {
            case 4: {
                return AVXSize.DWORD;
            }
            case 8: {
                return AVXSize.QWORD;
            }
            case 16: {
                return AVXSize.XMM;
            }
            case 32: {
                return AVXSize.YMM;
            }
            case 64: {
                return AVXSize.ZMM;
            }
        }
        throw GraalError.shouldNotReachHere("unsupported kind: " + kind);
    }

    public static AVXSize getRegisterSize(AMD64Kind kind) {
        assert (kind.isXMM()) : "unexpected kind " + kind;
        int size = kind.getSizeInBytes();
        if (size > 32) {
            return AVXSize.ZMM;
        }
        if (size > 16) {
            return AVXSize.YMM;
        }
        return AVXSize.XMM;
    }

    public static AMD64Kind changeSize(AMD64Kind kind, AVXSize newSize) {
        return AVXKind.getAVXKind(kind.getScalar(), newSize);
    }

    public static AMD64Kind getMaskKind(AMD64Kind kind) {
        switch (kind.getScalar()) {
            case SINGLE: {
                return AVXKind.getAVXKind(AMD64Kind.DWORD, kind.getVectorLength());
            }
            case DOUBLE: {
                return AVXKind.getAVXKind(AMD64Kind.QWORD, kind.getVectorLength());
            }
        }
        return kind;
    }

    public static AMD64Kind getAVXKind(AMD64Kind base, AVXSize size) {
        for (AMD64Kind ret : AMD64Kind.values()) {
            if (ret.getScalar() != base || ret.getSizeInBytes() != size.getBytes()) continue;
            return ret;
        }
        throw GraalError.shouldNotReachHere(String.format("unsupported vector kind: %s x %s", size, base));
    }

    public static AMD64Kind getAVXKind(AMD64Kind base, int length) {
        AMD64Kind toReturn = null;
        for (AMD64Kind ret : AMD64Kind.values()) {
            if (ret.getScalar() != base || ret.getVectorLength() < length || toReturn != null && ret.getVectorLength() >= toReturn.getVectorLength()) continue;
            toReturn = ret;
        }
        if (toReturn == null) {
            throw GraalError.shouldNotReachHere(String.format("unsupported vector kind: %d x %s", length, base));
        }
        return toReturn;
    }

    public static enum AVXSize implements VectorSize
    {
        DWORD(4),
        QWORD(8),
        XMM(16),
        YMM(32),
        ZMM(64);

        private final int size;

        private AVXSize(int size) {
            this.size = size;
        }

        public int getBytes() {
            return this.size;
        }

        public boolean fitsWithin(AVXSize supportedVectorSize) {
            switch (this) {
                case XMM: {
                    if (supportedVectorSize == XMM) {
                        return true;
                    }
                }
                case YMM: {
                    if (supportedVectorSize == YMM) {
                        return true;
                    }
                }
                case ZMM: {
                    return supportedVectorSize == ZMM;
                }
            }
            return this == supportedVectorSize;
        }
    }
}

