/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.configwithorigins;

import com.oracle.svm.agent.configwithorigins.MethodInfoRecordKeeper;
import com.oracle.svm.configure.config.conditional.MethodInfo;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.word.WordFactory;

class ClassInfo {
    final String className;
    final Map<String, MethodInfo> nameAndSignatureToMethodInfoMap;

    ClassInfo(String classSignature) {
        this.className = MetaUtil.internalNameToJava((String)classSignature, (boolean)true, (boolean)false);
        this.nameAndSignatureToMethodInfoMap = new ConcurrentHashMap<String, MethodInfo>();
    }

    public MethodInfo findOrCreateMethodInfo(long rawJMethodIdValue) throws Support.WrongPhaseException {
        JNIMethodId jMethodId = (JNIMethodId)WordFactory.pointer((long)rawJMethodIdValue);
        CCharPointerPointer methodNamePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        CCharPointerPointer methodSignaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        Support.checkPhase((JvmtiError)Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), jMethodId, methodNamePtr, methodSignaturePtr, (CCharPointerPointer)WordFactory.nullPointer()));
        String methodName = MethodInfoRecordKeeper.getJavaStringAndFreeNativeString(methodNamePtr.read());
        String methodSignature = MethodInfoRecordKeeper.getJavaStringAndFreeNativeString(methodSignaturePtr.read());
        String methodNameAndSignature = ClassInfo.combineMethodNameAndSignature(methodName, methodSignature);
        this.nameAndSignatureToMethodInfoMap.computeIfAbsent(methodNameAndSignature, nameAndSignature -> new MethodInfo(methodName, methodSignature, this.className));
        return this.nameAndSignatureToMethodInfoMap.get(methodNameAndSignature);
    }

    private static String combineMethodNameAndSignature(String methodName, String methodSignature) {
        return methodName + "-" + methodSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassInfo classInfo = (ClassInfo)o;
        return this.className.equals(classInfo.className);
    }

    public int hashCode() {
        return Objects.hash(this.className);
    }
}

