/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.trace.AbstractProcessor;
import java.util.List;
import org.graalvm.collections.EconomicMap;

public class ClassLoadingProcessor
extends AbstractProcessor {
    @Override
    void processEntry(EconomicMap<String, ?> entry, ConfigurationSet configurationSet) {
        boolean invalidResult = Boolean.FALSE.equals(entry.get((Object)"result"));
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get((Object)"function");
        List args = (List)entry.get((Object)"args");
        if ("onClassFileLoadHook".equals(function)) {
            ClassLoadingProcessor.expectSize(args, 2);
            String nameInfo = (String)args.get(0);
            byte[] classData = ClassLoadingProcessor.asBinary(args.get(1));
            configurationSet.getPredefinedClassesConfiguration().add(nameInfo, classData);
        }
    }
}

