/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config.conditional;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.conditional.MethodCallNode;
import com.oracle.svm.configure.config.conditional.MethodInfo;
import com.oracle.svm.configure.config.conditional.MethodInfoRepository;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.json.JsonPrintable;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.util.json.JSONParserException;

public class PartialConfigurationWithOrigins
extends ConfigurationParser
implements JsonPrintable {
    private static final ConfigurationSet emptyConfigurationSet = new ConfigurationSet();
    private final MethodCallNode root;
    private final MethodInfoRepository methodInfoRegistry;

    public PartialConfigurationWithOrigins(MethodCallNode root, MethodInfoRepository methodInfoRegistry) {
        super(true);
        this.root = root;
        this.methodInfoRegistry = methodInfoRegistry;
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append("{").indent().newline().quote("configuration-with-origins").append(": ");
        this.printJson(this.root, writer);
        writer.unindent().newline();
        writer.append("}").newline();
    }

    private void printJson(MethodCallNode node, JsonWriter writer) throws IOException {
        ConfigurationSet configSet;
        writer.append("{").indent().newline();
        String className = node.methodInfo != null ? node.methodInfo.getJavaDeclaringClassName() : "<root>";
        String methodName = node.methodInfo != null ? node.methodInfo.getName() : "<root>";
        String signature = node.methodInfo != null ? node.methodInfo.getSignature() : "()V";
        writer.quote("class").append(": ").quote(className).append(",").newline();
        writer.quote("method").append(": ").quote(methodName).append(",").newline();
        writer.quote("signature").append(": ").quote(signature).append(",").newline();
        writer.quote("methods").append(": [");
        boolean first = true;
        for (MethodCallNode methodCallNode : node.calledMethods.values()) {
            if (first) {
                first = false;
            } else {
                writer.append(",");
            }
            writer.newline();
            this.printJson(methodCallNode, writer);
        }
        writer.newline().append("]");
        ConfigurationSet configurationSet = configSet = node.configuration == null ? emptyConfigurationSet : node.configuration;
        if (!configSet.isEmpty()) {
            writer.append(",").newline();
        }
        PartialConfigurationWithOrigins.printConfigurationSet(writer, configSet);
        writer.unindent().newline();
        writer.append("}");
    }

    public void parseAndRegister(Object json, URI origin) throws IOException {
        EconomicMap topObject = PartialConfigurationWithOrigins.asMap((Object)json, (String)"Top level of document must be an object");
        Object originsObject = topObject.get((Object)"configuration-with-origins");
        if (originsObject == null) {
            throw new JSONParserException("Top level object must have a 'configuration-with-origins' property.");
        }
        EconomicMap rootMethod = PartialConfigurationWithOrigins.asMap((Object)originsObject, (String)"'configuration-with-origins' must be an object");
        this.parseMethodEntry(null, rootMethod, origin);
    }

    private static String getStringProperty(EconomicMap<String, ?> json, String property) {
        Object prop = json.get((Object)property);
        if (prop == null) {
            throw new JSONParserException("Missing property '" + property + "'");
        }
        return PartialConfigurationWithOrigins.asString((Object)prop);
    }

    private void parseMethodEntry(MethodCallNode parent, EconomicMap<String, ?> methodJson, URI origin) throws IOException {
        MethodCallNode target;
        if (parent == null) {
            target = this.root;
        } else {
            String className = PartialConfigurationWithOrigins.getStringProperty(methodJson, "class");
            String methodName = PartialConfigurationWithOrigins.getStringProperty(methodJson, "method");
            String signature = PartialConfigurationWithOrigins.getStringProperty(methodJson, "signature");
            MethodInfo info = this.methodInfoRegistry.getOrAdd(className, methodName, signature);
            target = parent.getOrCreateChild(info);
        }
        Object config = methodJson.get((Object)"config");
        if (config != null) {
            EconomicMap configJson = PartialConfigurationWithOrigins.asMap((Object)config, (String)"'config' must be an object");
            PartialConfigurationWithOrigins.parseConfigurationSet(configJson, target.getConfiguration(), origin);
        }
        Object methods = methodJson.get((Object)"methods");
        List methodsList = PartialConfigurationWithOrigins.asList((Object)methods, (String)"'methods' must be a list");
        for (Object methodObject : methodsList) {
            EconomicMap method = PartialConfigurationWithOrigins.asMap(methodObject, (String)"'methods' must contain objects");
            this.parseMethodEntry(target, method, origin);
        }
    }

    private static void printConfigurationSet(JsonWriter writer, ConfigurationSet configurationSet) throws IOException {
        if (!configurationSet.isEmpty()) {
            writer.quote("config").append(": {").indent().newline();
            boolean first = true;
            for (ConfigurationFile file : ConfigurationFile.agentGeneratedFiles()) {
                if (((ConfigurationBase)configurationSet.getConfiguration(file)).isEmpty()) continue;
                if (first) {
                    first = false;
                } else {
                    writer.append(",").newline();
                }
                writer.quote(file.getName()).append(": ");
                configurationSet.getConfiguration(file).printJson(writer);
            }
            writer.unindent().newline().append("}");
        }
    }

    private static void parseConfigurationSet(EconomicMap<String, ?> configJson, ConfigurationSet configurationSet, URI origin) throws IOException {
        MapCursor cursor = configJson.getEntries();
        while (cursor.advance()) {
            String configName = (String)cursor.getKey();
            ConfigurationFile configType = ConfigurationFile.getByName((String)configName);
            if (configType == null) {
                throw new JSONParserException("Invalid configuration type: " + configName);
            }
            ((ConfigurationBase)configurationSet.getConfiguration(configType)).createParser().parseAndRegister(cursor.getValue(), origin);
        }
    }
}

