/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.SerializationConfigurationLambdaCapturingType;
import com.oracle.svm.configure.config.SerializationConfigurationType;
import com.oracle.svm.configure.config.SignatureUtil;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.SerializationConfigurationParser;
import com.oracle.svm.core.util.json.JsonPrintable;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public final class SerializationConfiguration
extends ConfigurationBase<SerializationConfiguration, Predicate>
implements RuntimeSerializationSupport {
    private final Set<SerializationConfigurationType> serializations = ConcurrentHashMap.newKeySet();
    private final Set<SerializationConfigurationLambdaCapturingType> lambdaSerializationCapturingTypes = ConcurrentHashMap.newKeySet();
    private final ProxyConfiguration proxyConfiguration;
    private final Set<ConditionalElement<List<String>>> interfaceListsSerializableProxies = ConcurrentHashMap.newKeySet();

    public SerializationConfiguration() {
        this.proxyConfiguration = new ProxyConfiguration();
    }

    public SerializationConfiguration(SerializationConfiguration other) {
        this.serializations.addAll(other.serializations);
        this.lambdaSerializationCapturingTypes.addAll(other.lambdaSerializationCapturingTypes);
        this.interfaceListsSerializableProxies.addAll(other.interfaceListsSerializableProxies);
        this.proxyConfiguration = new ProxyConfiguration(other.proxyConfiguration);
    }

    @Override
    public SerializationConfiguration copy() {
        return new SerializationConfiguration(this);
    }

    @Override
    protected void merge(SerializationConfiguration other) {
        this.serializations.addAll(other.serializations);
        this.lambdaSerializationCapturingTypes.addAll(other.lambdaSerializationCapturingTypes);
        this.proxyConfiguration.merge(other.proxyConfiguration);
    }

    @Override
    public void subtract(SerializationConfiguration other) {
        this.serializations.removeAll(other.serializations);
        this.lambdaSerializationCapturingTypes.removeAll(other.lambdaSerializationCapturingTypes);
        this.proxyConfiguration.subtract(other.proxyConfiguration);
    }

    @Override
    protected void intersect(SerializationConfiguration other) {
        this.serializations.retainAll(other.serializations);
        this.lambdaSerializationCapturingTypes.retainAll(other.lambdaSerializationCapturingTypes);
        this.proxyConfiguration.intersect(other.proxyConfiguration);
    }

    @Override
    protected void removeIf(Predicate predicate) {
        this.serializations.removeIf(predicate::testSerializationType);
        this.lambdaSerializationCapturingTypes.removeIf(predicate::testLambdaSerializationType);
    }

    @Override
    public void mergeConditional(ConfigurationCondition condition, SerializationConfiguration other) {
        for (SerializationConfigurationType type : other.serializations) {
            this.serializations.add(new SerializationConfigurationType(condition, type.getQualifiedJavaName(), type.getQualifiedCustomTargetConstructorJavaName()));
        }
    }

    public boolean contains(ConfigurationCondition condition, String serializationTargetClass, String customTargetConstructorClass) {
        return this.serializations.contains(SerializationConfiguration.createConfigurationType(condition, serializationTargetClass, customTargetConstructorClass)) || this.lambdaSerializationCapturingTypes.contains(SerializationConfiguration.createLambdaCapturingClassConfigurationType(condition, serializationTargetClass));
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        ArrayList<SerializationConfigurationType> listOfCapturedClasses = new ArrayList<SerializationConfigurationType>(this.serializations);
        Collections.sort(listOfCapturedClasses);
        SerializationConfiguration.printSerializationClasses(writer, "types", listOfCapturedClasses);
        writer.append(",").newline();
        ArrayList<SerializationConfigurationLambdaCapturingType> listOfCapturingClasses = new ArrayList<SerializationConfigurationLambdaCapturingType>(this.lambdaSerializationCapturingTypes);
        listOfCapturingClasses.sort(new SerializationConfigurationLambdaCapturingType.SerializationConfigurationLambdaCapturingTypesComparator());
        SerializationConfiguration.printSerializationClasses(writer, "lambdaCapturingTypes", listOfCapturingClasses);
        writer.append(",").newline().quote("proxies").append(":");
        this.printProxies(writer);
        writer.unindent().newline();
        writer.append('}');
    }

    @Override
    public ConfigurationParser createParser() {
        return new SerializationConfigurationParser((RuntimeSerializationSupport)this, true);
    }

    private void printProxies(JsonWriter writer) throws IOException {
        ArrayList<ConditionalElement<List<String>>> lists = new ArrayList<ConditionalElement<List<String>>>(this.interfaceListsSerializableProxies);
        ProxyConfiguration.printProxyInterfaces(writer, lists);
    }

    private static void printSerializationClasses(JsonWriter writer, String types, List<? extends JsonPrintable> serializationConfigurationTypes) throws IOException {
        writer.quote(types).append(":");
        writer.append('[');
        writer.indent();
        SerializationConfiguration.printSerializationTypes(serializationConfigurationTypes, writer);
        writer.unindent().newline();
        writer.append("]");
    }

    private static void printSerializationTypes(List<? extends JsonPrintable> serializationConfigurationTypes, JsonWriter writer) throws IOException {
        String prefix = "";
        for (JsonPrintable jsonPrintable : serializationConfigurationTypes) {
            writer.append(prefix).newline();
            jsonPrintable.printJson(writer);
            prefix = ",";
        }
    }

    public void registerIncludingAssociatedClasses(ConfigurationCondition condition, Class<?> clazz) {
        this.register(condition, clazz);
    }

    public void register(ConfigurationCondition condition, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.registerWithTargetConstructorClass(condition, clazz, null);
        }
    }

    public void registerWithTargetConstructorClass(ConfigurationCondition condition, Class<?> clazz, Class<?> customTargetConstructorClazz) {
        this.registerWithTargetConstructorClass(condition, clazz.getName(), customTargetConstructorClazz == null ? null : customTargetConstructorClazz.getName());
    }

    public void registerWithTargetConstructorClass(ConfigurationCondition condition, String className, String customTargetConstructorClassName) {
        this.serializations.add(SerializationConfiguration.createConfigurationType(condition, className, customTargetConstructorClassName));
    }

    public void registerLambdaCapturingClass(ConfigurationCondition condition, String lambdaCapturingClassName) {
        this.lambdaSerializationCapturingTypes.add(SerializationConfiguration.createLambdaCapturingClassConfigurationType(condition, lambdaCapturingClassName.split("\\$\\$Lambda\\$")[0]));
    }

    public void registerProxyClass(ConfigurationCondition condition, List<String> implementedInterfaces) {
        this.interfaceListsSerializableProxies.add((ConditionalElement<List<String>>)new ConditionalElement(condition, implementedInterfaces));
    }

    @Override
    public boolean isEmpty() {
        return this.serializations.isEmpty() && this.lambdaSerializationCapturingTypes.isEmpty() || this.interfaceListsSerializableProxies.isEmpty();
    }

    private static SerializationConfigurationType createConfigurationType(ConfigurationCondition condition, String className, String customTargetConstructorClassName) {
        String convertedClassName = SignatureUtil.toInternalClassName(className);
        String convertedCustomTargetConstructorClassName = customTargetConstructorClassName == null ? null : SignatureUtil.toInternalClassName(customTargetConstructorClassName);
        return new SerializationConfigurationType(condition, convertedClassName, convertedCustomTargetConstructorClassName);
    }

    private static SerializationConfigurationLambdaCapturingType createLambdaCapturingClassConfigurationType(ConfigurationCondition condition, String className) {
        String convertedClassName = SignatureUtil.toInternalClassName(className);
        return new SerializationConfigurationLambdaCapturingType(condition, convertedClassName);
    }

    public static interface Predicate {
        public boolean testSerializationType(SerializationConfigurationType var1);

        public boolean testLambdaSerializationType(SerializationConfigurationLambdaCapturingType var1);
    }
}

