/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ConfigurationPredefinedClass;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.PredefinedClassesConfigurationParser;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public final class PredefinedClassesConfiguration
extends ConfigurationBase<PredefinedClassesConfiguration, Predicate> {
    private final Path[] classDestinationDirs;
    private final ConcurrentMap<String, ConfigurationPredefinedClass> classes = new ConcurrentHashMap<String, ConfigurationPredefinedClass>();
    private final java.util.function.Predicate<String> shouldExcludeClassWithHash;

    public PredefinedClassesConfiguration(Path[] classDestinationDirs, java.util.function.Predicate<String> shouldExcludeClassWithHash) {
        this.classDestinationDirs = classDestinationDirs;
        this.shouldExcludeClassWithHash = shouldExcludeClassWithHash;
    }

    public PredefinedClassesConfiguration(PredefinedClassesConfiguration other) {
        this.classDestinationDirs = other.classDestinationDirs;
        this.classes.putAll(other.classes);
        this.shouldExcludeClassWithHash = other.shouldExcludeClassWithHash;
    }

    @Override
    public PredefinedClassesConfiguration copy() {
        return new PredefinedClassesConfiguration(this);
    }

    @Override
    protected void merge(PredefinedClassesConfiguration other) {
        this.classes.putAll(other.classes);
    }

    @Override
    protected void subtract(PredefinedClassesConfiguration other) {
        this.classes.keySet().removeAll(other.classes.keySet());
    }

    @Override
    protected void intersect(PredefinedClassesConfiguration other) {
        this.classes.keySet().retainAll(other.classes.keySet());
    }

    @Override
    protected void removeIf(Predicate predicate) {
        this.classes.values().removeIf(predicate::testPredefinedClass);
    }

    @Override
    public void mergeConditional(ConfigurationCondition condition, PredefinedClassesConfiguration other) {
        this.classes.putAll(other.classes);
    }

    public void add(String nameInfo, byte[] classData) {
        String hash = PredefinedClassesSupport.hash((byte[])classData, (int)0, (int)classData.length);
        if (this.shouldExcludeClassWithHash != null && this.shouldExcludeClassWithHash.test(hash)) {
            return;
        }
        if (this.classDestinationDirs != null) {
            for (Path dir : this.classDestinationDirs) {
                try {
                    Files.write(dir.resolve(PredefinedClassesConfiguration.getFileName(hash)), classData, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ConfigurationPredefinedClass clazz = new ConfigurationPredefinedClass(nameInfo, hash);
        this.classes.put(hash, clazz);
    }

    public void add(String nameInfo, String hash, URI baseUri) {
        if (this.shouldExcludeClassWithHash != null && this.shouldExcludeClassWithHash.test(hash)) {
            return;
        }
        if (this.classDestinationDirs != null) {
            Path localBaseDir;
            try {
                localBaseDir = Path.of(baseUri);
            }
            catch (Exception ignored) {
                localBaseDir = null;
            }
            for (Path destDir : this.classDestinationDirs) {
                if (destDir.equals(localBaseDir)) continue;
                try {
                    String fileName = PredefinedClassesConfiguration.getFileName(hash);
                    Path target = destDir.resolve(fileName);
                    if (baseUri != null) {
                        try (InputStream is = PredefinedClassesConfigurationParser.openClassdataStream((URI)baseUri, (String)hash);){
                            Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
                            continue;
                        }
                    }
                    if (Files.exists(target, new LinkOption[0])) continue;
                    throw new RuntimeException("Cannot copy class data file for predefined class " + nameInfo + " with hash " + hash + ": source directory is unknown and file does not already exist in target directory.");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ConfigurationPredefinedClass clazz = new ConfigurationPredefinedClass(nameInfo, hash);
        this.classes.put(hash, clazz);
    }

    private static String getFileName(String hash) {
        return hash + ".classdata";
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append('[').indent().newline();
        writer.append('{').indent().newline();
        writer.quote("type").append(':').quote("agent-extracted").append(',').newline();
        writer.quote("classes").append(":[").indent();
        String prefix = "";
        for (ConfigurationPredefinedClass value : this.classes.values()) {
            writer.append(prefix).newline();
            value.printJson(writer);
            prefix = ",";
        }
        writer.unindent().newline().append(']');
        writer.unindent().newline().append('}');
        writer.unindent().newline().append(']').newline();
    }

    @Override
    public ConfigurationParser createParser() {
        return new PredefinedClassesConfigurationParser(this::add, true);
    }

    @Override
    public boolean isEmpty() {
        return this.classes.isEmpty();
    }

    public boolean containsClassWithName(String className) {
        return this.classes.values().stream().anyMatch(clazz -> clazz.getNameInfo().equals(className));
    }

    public boolean containsClassWithHash(String hash) {
        return this.classes.containsKey(hash);
    }

    public static interface Predicate {
        public boolean testPredefinedClass(ConfigurationPredefinedClass var1);
    }
}

