/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationMethod;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import java.util.List;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class ParserConfigurationAdapter
implements ReflectionConfigurationParserDelegate<ConfigurationType> {
    private final TypeConfiguration configuration;

    public ParserConfigurationAdapter(TypeConfiguration configuration) {
        this.configuration = configuration;
    }

    public TypeResult<ConfigurationCondition> resolveCondition(String typeName) {
        return TypeResult.forType((String)typeName, (Object)ConfigurationCondition.create((String)typeName));
    }

    public TypeResult<ConfigurationType> resolveType(ConfigurationCondition condition, String typeName, boolean allowPrimitives) {
        ConfigurationType type = this.configuration.get(condition, typeName);
        ConfigurationType result = type != null ? type : new ConfigurationType(condition, typeName);
        return TypeResult.forType((String)typeName, (Object)result);
    }

    public void registerType(ConfigurationType type) {
        this.configuration.add(type);
    }

    public void registerField(ConfigurationType type, String fieldName, boolean finalButWritable) {
        type.addField(fieldName, ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, finalButWritable);
    }

    public boolean registerAllMethodsWithName(boolean queriedOnly, ConfigurationType type, String methodName) {
        type.addMethodsWithName(methodName, ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
        return true;
    }

    public boolean registerAllConstructors(boolean queriedOnly, ConfigurationType type) {
        type.addMethodsWithName("<init>", ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
        return true;
    }

    public void registerUnsafeAllocated(ConfigurationType type) {
        type.setUnsafeAllocated();
    }

    public void registerMethod(boolean queriedOnly, ConfigurationType type, String methodName, List<ConfigurationType> methodParameterTypes) {
        type.addMethod(methodName, ConfigurationMethod.toInternalParamsSignature(methodParameterTypes), ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerConstructor(boolean queriedOnly, ConfigurationType type, List<ConfigurationType> methodParameterTypes) {
        type.addMethod("<init>", ConfigurationMethod.toInternalParamsSignature(methodParameterTypes), ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerPublicClasses(ConfigurationType type) {
        type.setAllPublicClasses();
    }

    public void registerDeclaredClasses(ConfigurationType type) {
        type.setAllDeclaredClasses();
    }

    public void registerRecordComponents(ConfigurationType type) {
        type.setAllRecordComponents();
    }

    public void registerPermittedSubclasses(ConfigurationType type) {
        type.setAllPermittedSubclasses();
    }

    public void registerNestMembers(ConfigurationType type) {
        type.setAllNestMembers();
    }

    public void registerSigners(ConfigurationType type) {
        type.setAllSigners();
    }

    public void registerPublicFields(ConfigurationType type) {
        type.setAllPublicFields();
    }

    public void registerDeclaredFields(ConfigurationType type) {
        type.setAllDeclaredFields();
    }

    public void registerPublicMethods(boolean queriedOnly, ConfigurationType type) {
        type.setAllPublicMethods(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerDeclaredMethods(boolean queriedOnly, ConfigurationType type) {
        type.setAllDeclaredMethods(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerPublicConstructors(boolean queriedOnly, ConfigurationType type) {
        type.setAllPublicConstructors(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerDeclaredConstructors(boolean queriedOnly, ConfigurationType type) {
        type.setAllDeclaredConstructors(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public String getTypeName(ConfigurationType type) {
        return type.getQualifiedJavaName();
    }

    public String getSimpleName(ConfigurationType type) {
        return this.getTypeName(type);
    }
}

