/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationMemberInfo;

public final class FieldInfo {
    private static final FieldInfo[] FINAL_NOT_WRITABLE_CACHE;
    private final ConfigurationMemberInfo.ConfigurationMemberDeclaration kind;
    private final boolean finalButWritable;

    static FieldInfo get(ConfigurationMemberInfo.ConfigurationMemberDeclaration kind, boolean finalButWritable) {
        if (finalButWritable) {
            return new FieldInfo(kind, finalButWritable);
        }
        return FINAL_NOT_WRITABLE_CACHE[kind.ordinal()];
    }

    private FieldInfo(ConfigurationMemberInfo.ConfigurationMemberDeclaration kind, boolean finalButWritable) {
        this.kind = kind;
        this.finalButWritable = finalButWritable;
    }

    public FieldInfo newMergedWith(FieldInfo other) {
        assert (this.kind.equals((Object)other.kind));
        if (this.finalButWritable == other.finalButWritable) {
            return this;
        }
        return FieldInfo.get(this.kind, this.finalButWritable || other.finalButWritable);
    }

    public FieldInfo newWithDifferencesFrom(FieldInfo other) {
        boolean newFinalButWritable;
        assert (this.kind.equals((Object)other.kind));
        boolean bl = newFinalButWritable = this.finalButWritable && !other.finalButWritable;
        if (!newFinalButWritable) {
            return null;
        }
        return FieldInfo.get(this.kind, newFinalButWritable);
    }

    public FieldInfo newIntersectedWith(FieldInfo other) {
        assert (this.kind.equals((Object)other.kind));
        boolean newFinalButWritable = this.finalButWritable && other.finalButWritable;
        return FieldInfo.get(this.kind, newFinalButWritable);
    }

    public ConfigurationMemberInfo.ConfigurationMemberDeclaration getKind() {
        return this.kind;
    }

    public boolean isFinalButWritable() {
        return this.finalButWritable;
    }

    public boolean equals(Object obj) {
        if (obj != this && obj instanceof FieldInfo) {
            FieldInfo other = (FieldInfo)obj;
            return this.kind.equals((Object)other.kind) && this.finalButWritable == other.finalButWritable;
        }
        return obj == this;
    }

    public int hashCode() {
        return Boolean.hashCode(this.finalButWritable) * 31 + this.kind.hashCode();
    }

    static {
        ConfigurationMemberInfo.ConfigurationMemberDeclaration[] values = ConfigurationMemberInfo.ConfigurationMemberDeclaration.values();
        FINAL_NOT_WRITABLE_CACHE = new FieldInfo[values.length];
        for (ConfigurationMemberInfo.ConfigurationMemberDeclaration value : values) {
            FieldInfo.FINAL_NOT_WRITABLE_CACHE[value.ordinal()] = new FieldInfo(value, false);
        }
    }
}

