/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.command;

import com.oracle.svm.configure.ConfigurationUsageException;
import com.oracle.svm.configure.command.ConfigurationCommand;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.conditional.ConditionalConfigurationComputer;
import com.oracle.svm.configure.config.conditional.ConditionalConfigurationPredicate;
import com.oracle.svm.configure.config.conditional.MethodCallNode;
import com.oracle.svm.configure.config.conditional.MethodInfoRepository;
import com.oracle.svm.configure.config.conditional.PartialConfigurationWithOrigins;
import com.oracle.svm.configure.filters.ComplexFilter;
import com.oracle.svm.configure.filters.FilterConfigurationParser;
import com.oracle.svm.configure.filters.HierarchyFilterNode;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;

public final class ConfigurationGenerateConditionalsCommand
extends ConfigurationCommand {
    @Override
    public String getName() {
        return "generate-conditional";
    }

    @Override
    public void apply(Iterator<String> argumentsIterator) throws IOException {
        ComplexFilter classNameFilter;
        HashSet<URI> configInputPaths = new HashSet<URI>();
        HashSet<URI> configOutputPaths = new HashSet<URI>();
        URI userCodeFilterUri = null;
        HashSet<URI> classNameFiltersUri = new HashSet<URI>();
        block12: while (argumentsIterator.hasNext()) {
            String argument = argumentsIterator.next();
            String[] optionValue = argument.split("=");
            if (optionValue.length != 2) {
                throw new ConfigurationUsageException(String.format("Format is not valid: %s. Options should be in format --<option>=<value>. ", argument));
            }
            String option = optionValue[0];
            String value = optionValue[1];
            switch (option) {
                case "--input-dir": {
                    Path dir = ConfigurationGenerateConditionalsCommand.requirePath(option, value);
                    if (!Files.isDirectory(dir, new LinkOption[0])) {
                        throw new ConfigurationUsageException("Path is not a directory: " + dir);
                    }
                    Path configPath = dir.resolve("partial-config-with-origins.json");
                    if (!Files.isRegularFile(configPath, new LinkOption[0])) {
                        throw new ConfigurationUsageException("Cannot find partial configuration file at " + configPath);
                    }
                    configInputPaths.add(configPath.toUri());
                    continue block12;
                }
                case "--output-dir": {
                    Path outputDir = ConfigurationGenerateConditionalsCommand.getOrCreateDirectory(option, value);
                    configOutputPaths.add(outputDir.toUri());
                    continue block12;
                }
                case "--user-code-filter": {
                    Path userCodeFilter = ConfigurationGenerateConditionalsCommand.requirePath(option, value);
                    if (!Files.isRegularFile(userCodeFilter, new LinkOption[0])) {
                        throw new ConfigurationUsageException("Cannot find user code filter file at " + userCodeFilter);
                    }
                    userCodeFilterUri = userCodeFilter.toUri();
                    continue block12;
                }
                case "--class-name-filter": {
                    Path classNameFilter2 = ConfigurationGenerateConditionalsCommand.requirePath(option, value);
                    if (!Files.isRegularFile(classNameFilter2, new LinkOption[0])) {
                        throw new ConfigurationUsageException("Cannot find user code filter file at " + classNameFilter2);
                    }
                    classNameFiltersUri.add(classNameFilter2.toUri());
                    continue block12;
                }
            }
            throw new ConfigurationUsageException("Unknown option: " + (String)option);
        }
        ComplexFilter userCodeFilter = new ComplexFilter(HierarchyFilterNode.createRoot());
        new FilterConfigurationParser(userCodeFilter).parseAndRegister(userCodeFilterUri);
        if (classNameFiltersUri.isEmpty()) {
            classNameFilter = new ComplexFilter(HierarchyFilterNode.createInclusiveRoot());
        } else {
            classNameFilter = new ComplexFilter(HierarchyFilterNode.createRoot());
            for (URI classNameFilterUri : classNameFiltersUri) {
                new FilterConfigurationParser(classNameFilter).parseAndRegister(classNameFilterUri);
            }
        }
        MethodCallNode rootNode = MethodCallNode.createRoot();
        MethodInfoRepository registry = new MethodInfoRepository();
        for (URI inputUri : configInputPaths) {
            new PartialConfigurationWithOrigins(rootNode, registry).parseAndRegister(inputUri);
        }
        ConfigurationSet configSet = new ConditionalConfigurationComputer(rootNode, userCodeFilter, new ConditionalConfigurationPredicate(classNameFilter)).computeConditionalConfiguration();
        for (URI outputUri : configOutputPaths) {
            configSet.writeConfiguration(file -> Path.of(outputUri).resolve(file.getFileName()));
        }
    }

    @Override
    protected String getDescription0() {
        return "      generates conditional configuration from data\n                          collected by previous agent runs.\n    --input-dir=<path>\n                          reads configuration and metadata from a directory that\n                          was previously populated by a run with the agent in\n                          the partial configuration mode.\n    --output-dir=<path>\n                          writes a set of conditional configuration files to\n                          the given path.\n    --user-code-filter=<path>\n                          specifies a filter file used to classify classes as\n                          user application classes. Generated conditions will\n                          only reference these classes.\n    --class-name-filter=<path>\n                          specifies a filter file used to exclude classes from\n                          the computed configuration. Both the configuration\n                          and the conditions in the configuration will be\n                          tested against this filter.\n".replaceAll("\n", System.lineSeparator());
    }
}

