/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.command;

import com.oracle.svm.configure.ConfigurationUsageException;
import com.oracle.svm.configure.command.ConfigurationCommand;
import com.oracle.svm.configure.config.ConfigurationFileCollection;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.filters.ComplexFilter;
import com.oracle.svm.configure.filters.FilterConfigurationParser;
import com.oracle.svm.configure.filters.HierarchyFilterNode;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.TraceProcessor;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;

public class ConfigurationGenerateCommand
extends ConfigurationCommand {
    @Override
    public String getName() {
        return "generate";
    }

    @Override
    public void apply(Iterator<String> argumentsIterator) throws IOException {
        ConfigurationGenerateCommand.generate(argumentsIterator, false);
    }

    @Override
    protected String getDescription0() {
        return "                  generates configuration file(s) from all inputs.\n    --trace-input=<path>\n                          reads and processes a trace file at the given path.\n    --input-dir=<path>\n                          reads a set of configuration files from the directory\n                          at the given path. This is equivalent to all of:\n                           --reflect-input=<path>/reflect-config.json\n                           --jni-input=<path>/jni-config.json\n                           --proxy-input=<path>/proxy-config.json\n                           --resource-input=<path>/resource-config.json\n    --reflect-input=<path>\n                          reads a reflection configuration file at <path>.\n    --jni-input=<path>\n                          reads a JNI configuration file at <path>.\n    --proxy-input=<path>\n                          reads a dynamic proxy configuration file at <path>.\n    --resource-input=<path>\n                          reads a resource configuration file at <path>.\n    --serialization-input=<path>\n                          reads a serialization configuration file at <path>.\n    --predefined-classes-input=<path>\n                          reads a class predefinition config file at <path>.\n    --output-dir=<path>\n                          writes a set of configuration files to the directory\n                          at the given path. Existing files are replaced. This\n                          option is equivalent to all of:\n                           --reflect-output=<path>/reflect-config.json\n                           --jni-output=<path>/jni-config.json\n                           --proxy-output=<path>/proxy-config.json\n                           --resource-output=<path>/resource-config.json\n    --reflect-output=<path>\n                          write a reflection configuration file to <path>. This\n                          file can be later provided to native-image with\n                          -H:ReflectionConfigurationFiles=<path>.\n    --jni-output=<path>\n                          write a JNI configuration file to <path>. This file\n                          can be later provided to native-image with\n                          -H:JNIConfigurationFiles=<path>.\n    --proxy-output=<path>\n                          write a dynamic proxy configuration file to <path>.\n                          This file can be later provided to native-image with\n                          -H:DynamicProxyConfigurationFiles=<path>.\n    --resource-output=<path>\n                          write a configuration file containing used resources\n                          (getResource) to <path>. This file can later be\n                          provided to native-image with\n                          -H:ResourceConfigurationFiles=<path>.\n                          The paths in the configuration file might need to be\n                          adjusted for the build directories/classpath.\n    --serialization-input=<path>\n                          writes a serialization configuration file to <path>.\n                          This file can be later provided to native-image with\n                          -H:SerializationConfigurationFiles=<path>.\n    --predefined-classes-input=<path>\n                          writes a class predefinition config file to <path>.\n                          This file can be later provided to native-image with\n                          -H:PredefinedClassesConfigurationFiles=<path>.\n    --caller-filter-file=<path>\n                          Provides a custom filter file for excluding usages\n                          of JNI, reflection and resources based on the caller\n                          class (read more below). This option can be provided\n                          more than once, and the filter rules from the files\n                          will be processed in the specified order.\n    --no-builtin-caller-filter\n                          Usages of JNI, reflection and resources that are\n                          internal to the JDK, to GraalVM or to the Java VM do\n                          not need to be configured for native-image builds and\n                          by default, are filtered (removed) from the generated\n                          configurations. This option disables the built-in\n                          filter for such usages based on the caller class.\n    --no-builtin-heuristic-filter\n                          This option disables builtin heuristics that identify\n                          further internal JNI, reflection and resource usages.\n".replaceAll("\n", System.lineSeparator());
    }

    protected static void generate(Iterator<String> argumentsIterator, boolean acceptTraceFileArgs) throws IOException {
        ConfigurationSet configurationSet;
        ArrayList<URI> traceInputs = new ArrayList<URI>();
        boolean builtinCallerFilter = true;
        boolean builtinHeuristicFilter = true;
        ArrayList<URI> callerFilters = new ArrayList<URI>();
        ConfigurationFileCollection omittedCollection = new ConfigurationFileCollection();
        ConfigurationFileCollection inputCollection = new ConfigurationFileCollection();
        ConfigurationFileCollection outputCollection = new ConfigurationFileCollection();
        block86: while (argumentsIterator.hasNext()) {
            String[] optionValue = argumentsIterator.next().split("=", 2);
            String option = optionValue[0];
            String value = optionValue.length > 1 ? optionValue[1] : null;
            ConfigurationFileCollection collection = outputCollection;
            switch (option) {
                case "--input-dir": {
                    inputCollection.addDirectory(ConfigurationGenerateCommand.requirePath(option, value));
                    continue block86;
                }
                case "--output-dir": {
                    Path path = ConfigurationGenerateCommand.getOrCreateDirectory(option, value);
                    outputCollection.addDirectory(path);
                    continue block86;
                }
                case "--omit-from-input-dir": {
                    omittedCollection.addDirectory(ConfigurationGenerateCommand.requirePath(option, value));
                    continue block86;
                }
                case "--reflect-input": {
                    collection = inputCollection;
                }
                case "--reflect-output": {
                    collection.getReflectConfigPaths().add(ConfigurationGenerateCommand.requirePathUri(option, value));
                    continue block86;
                }
                case "--jni-input": {
                    collection = inputCollection;
                }
                case "--jni-output": {
                    collection.getJniConfigPaths().add(ConfigurationGenerateCommand.requirePathUri(option, value));
                    continue block86;
                }
                case "--proxy-input": {
                    collection = inputCollection;
                }
                case "--proxy-output": {
                    collection.getProxyConfigPaths().add(ConfigurationGenerateCommand.requirePathUri(option, value));
                    continue block86;
                }
                case "--resource-input": {
                    collection = inputCollection;
                }
                case "--resource-output": {
                    collection.getResourceConfigPaths().add(ConfigurationGenerateCommand.requirePathUri(option, value));
                    continue block86;
                }
                case "--serialization-input": {
                    collection = inputCollection;
                }
                case "--serialization-output": {
                    collection.getSerializationConfigPaths().add(ConfigurationGenerateCommand.requirePathUri(option, value));
                    continue block86;
                }
                case "--predefined-classes-input": {
                    collection = inputCollection;
                }
                case "--predefined-classes-output": {
                    collection.getPredefinedClassesConfigPaths().add(ConfigurationGenerateCommand.requirePathUri(option, value));
                    continue block86;
                }
                case "--trace-input": {
                    traceInputs.add(ConfigurationGenerateCommand.requirePathUri(option, value));
                    continue block86;
                }
                case "--no-filter": {
                    builtinCallerFilter = false;
                    builtinHeuristicFilter = false;
                    continue block86;
                }
                case "--no-builtin-caller-filter": {
                    builtinCallerFilter = false;
                    continue block86;
                }
                case "--no-builtin-heuristic-filter": {
                    builtinHeuristicFilter = false;
                    continue block86;
                }
                case "--caller-filter-file": {
                    callerFilters.add(ConfigurationGenerateCommand.requirePathUri(option, value));
                    continue block86;
                }
                case "--": {
                    if (acceptTraceFileArgs) {
                        argumentsIterator.forEachRemaining(arg -> traceInputs.add(Paths.get(arg, new String[0]).toUri()));
                        continue block86;
                    }
                    throw new ConfigurationUsageException("Unknown argument: " + option);
                }
            }
            if (!acceptTraceFileArgs || option.startsWith("-")) {
                throw new ConfigurationUsageException("Unknown argument: " + option);
            }
            traceInputs.add(Paths.get(option, new String[0]).toUri());
        }
        ConfigurationGenerateCommand.failIfAgentLockFilesPresent(inputCollection, omittedCollection, outputCollection);
        HierarchyFilterNode callersFilterHierarchyFilterNode = null;
        ComplexFilter callersFilter = null;
        if (!builtinCallerFilter) {
            callersFilterHierarchyFilterNode = HierarchyFilterNode.createInclusiveRoot();
            callersFilter = new ComplexFilter(callersFilterHierarchyFilterNode);
        }
        if (!callerFilters.isEmpty()) {
            if (callersFilterHierarchyFilterNode == null) {
                callersFilterHierarchyFilterNode = AccessAdvisor.copyBuiltinCallerFilterTree();
                callersFilter = new ComplexFilter(callersFilterHierarchyFilterNode);
            }
            for (URI uri : callerFilters) {
                try {
                    FilterConfigurationParser parser = new FilterConfigurationParser(callersFilter);
                    parser.parseAndRegister(uri);
                }
                catch (Exception e) {
                    throw new ConfigurationUsageException("Cannot parse filter file " + uri + ": " + e);
                }
            }
            callersFilter.getHierarchyFilterNode().removeRedundantNodes();
        }
        try {
            ConfigurationSet omittedConfigurationSet = omittedCollection.loadConfigurationSet(ConfigurationFileCollection.FAIL_ON_EXCEPTION, null, null);
            ArrayList<Path> predefinedClassDestDirs = new ArrayList<Path>();
            for (URI uRI : outputCollection.getPredefinedClassesConfigPaths()) {
                Path subdir = Files.createDirectories(Paths.get(uRI).getParent().resolve("agent-extracted-predefined-classes"), new FileAttribute[0]);
                subdir = Files.createDirectories(subdir, new FileAttribute[0]);
                predefinedClassDestDirs.add(subdir);
            }
            Predicate<String> shouldExcludeClassesWithHash = omittedConfigurationSet.getPredefinedClassesConfiguration()::containsClassWithHash;
            configurationSet = inputCollection.loadConfigurationSet(ConfigurationFileCollection.FAIL_ON_EXCEPTION, predefinedClassDestDirs.toArray(new Path[0]), shouldExcludeClassesWithHash);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        if (traceInputs.isEmpty() && inputCollection.isEmpty()) {
            throw new ConfigurationUsageException("No inputs specified.");
        }
        if (!traceInputs.isEmpty()) {
            AccessAdvisor advisor = new AccessAdvisor();
            advisor.setHeuristicsEnabled(builtinHeuristicFilter);
            if (callersFilter != null) {
                advisor.setCallerFilterTree(callersFilter);
            }
            TraceProcessor processor = new TraceProcessor(advisor);
            for (URI uri : traceInputs) {
                try (BufferedReader reader = Files.newBufferedReader(Paths.get(uri));){
                    processor.process(reader, configurationSet);
                }
            }
        }
        if (outputCollection.isEmpty()) {
            System.err.println("Warning: no outputs specified, validating inputs only.");
        }
        for (URI uri : outputCollection.getReflectConfigPaths()) {
            try (JsonWriter jsonWriter = new JsonWriter(Paths.get(uri), new OpenOption[0]);){
                configurationSet.getReflectionConfiguration().printJson(jsonWriter);
            }
        }
        for (URI uri : outputCollection.getJniConfigPaths()) {
            try (JsonWriter jsonWriter = new JsonWriter(Paths.get(uri), new OpenOption[0]);){
                configurationSet.getJniConfiguration().printJson(jsonWriter);
            }
        }
        for (URI uri : outputCollection.getProxyConfigPaths()) {
            try (JsonWriter jsonWriter = new JsonWriter(Paths.get(uri), new OpenOption[0]);){
                configurationSet.getProxyConfiguration().printJson(jsonWriter);
            }
        }
        for (URI uri : outputCollection.getResourceConfigPaths()) {
            try (JsonWriter jsonWriter = new JsonWriter(Paths.get(uri), new OpenOption[0]);){
                configurationSet.getResourceConfiguration().printJson(jsonWriter);
            }
        }
        for (URI uri : outputCollection.getSerializationConfigPaths()) {
            try (JsonWriter jsonWriter = new JsonWriter(Paths.get(uri), new OpenOption[0]);){
                configurationSet.getSerializationConfiguration().printJson(jsonWriter);
            }
        }
        for (URI uri : outputCollection.getPredefinedClassesConfigPaths()) {
            try (JsonWriter jsonWriter = new JsonWriter(Paths.get(uri), new OpenOption[0]);){
                configurationSet.getPredefinedClassesConfiguration().printJson(jsonWriter);
            }
        }
    }

    private static void failIfAgentLockFilesPresent(ConfigurationFileCollection ... collections) {
        HashSet<String> paths = null;
        for (ConfigurationFileCollection coll : collections) {
            for (URI path : coll.getDetectedAgentLockPaths()) {
                if (paths == null) {
                    paths = new HashSet<String>();
                }
                paths.add(path.toString());
            }
        }
        if (paths != null && !paths.isEmpty()) {
            throw new ConfigurationUsageException("The following agent lock files were found in specified configuration directories, which means an agent is currently writing to them. The agent must finish execution before its configuration can be safely accessed. Unless a lock file is a leftover from an earlier process that terminated abruptly, it is unsafe to delete it." + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), (Iterable<? extends CharSequence>)paths));
        }
    }
}

