/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.command;

import com.oracle.svm.configure.ConfigurationUsageException;
import com.oracle.svm.configure.command.ConfigurationCommand;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;

public final class ConfigurationCommandFileCommand
extends ConfigurationCommand {
    @Override
    public String getName() {
        return "command-file";
    }

    @Override
    public void apply(Iterator<String> argumentsIterator) throws IOException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    public static Iterator<String> handleCommandFile(Iterator<String> argumentsIterator) {
        if (!argumentsIterator.hasNext()) {
            throw new ConfigurationUsageException("Path to a command file must be provided.");
        }
        Path filePath = Paths.get(argumentsIterator.next(), new String[0]);
        if (argumentsIterator.hasNext()) {
            throw new ConfigurationUsageException("Too many arguments to command-file passed. Expected a single argument: <path to a command file>.");
        }
        try {
            List<String> lines = Files.readAllLines(filePath);
            return lines.iterator();
        }
        catch (IOException e) {
            throw new ConfigurationUsageException("Failed to read the command file at " + filePath + ". Check if the file exists, you have the required permissions and that the file is actually a text file.");
        }
    }

    @Override
    public String getUsage() {
        return "native-image-configure command-file <command-file-path>";
    }

    @Override
    protected String getDescription0() {
        return "              reads the command-line arguments from the given file.\n                          The command-file contains one argument per line, with\n                          no quoting of whitespace necessary (newline\n                          characters in an argument cannot be represented).\n                          An example command file:\n                          generate\n                          --input-dir=input-dir-1-path\n                          --input-dir=input-dir-2-path\n                          --output-dir=output-dir-path\n                          This option is meant for executing commands with\n                          an argument list that is too large to be passed by\n                          regular means, which might be generated by other\n                          tools.\n    <command-file-path>\n                          specifies the path to a command file\n".replaceAll("\n", System.lineSeparator());
    }
}

