/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticallyRegisteredFeature
public class JmxClientFeature
extends JNIRegistrationUtil
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return VMInspectionOptions.hasJmxClientSupport();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JmxClientFeature.configureJNI();
            JmxClientFeature.configureReflection(access);
        }
        catch (Exception e) {
            throw VMError.shouldNotReachHere("ManagementClientFeature configuration failed: " + e);
        }
    }

    private static void configureJNI() {
        JNIRuntimeAccess.register(Boolean.class);
        JNIRuntimeAccess.register(ReflectionUtil.lookupMethod(Boolean.class, (String)"getBoolean", (Class[])new Class[]{String.class}));
    }

    private static void configureReflection(Feature.BeforeAnalysisAccess access) {
        RuntimeReflection.register((Class[])new Class[]{access.findClassByName("com.sun.jndi.url.rmi.rmiURLContextFactory")});
        RuntimeReflection.register((Class[])new Class[]{access.findClassByName("sun.rmi.server.UnicastRef")});
        RuntimeReflection.register((Class[])new Class[]{access.findClassByName("com.sun.jmx.remote.protocol.rmi.ClientProvider")});
        RuntimeReflection.register((Executable[])access.findClassByName("com.sun.jndi.url.rmi.rmiURLContextFactory").getConstructors());
        RuntimeReflection.register((Executable[])access.findClassByName("sun.rmi.server.UnicastRef").getConstructors());
        RuntimeReflection.register((Executable[])access.findClassByName("sun.rmi.server.UnicastRef2").getConstructors());
        RuntimeReflection.register((Executable[])access.findClassByName("com.sun.jmx.remote.protocol.rmi.ClientProvider").getConstructors());
    }
}

