/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationExceptionProxyValue;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.internal.reflect.ConstantPool;
import sun.reflect.annotation.ExceptionProxy;

public final class AnnotationEnumValue
extends AnnotationMemberValue {
    private final Class<? extends Enum<?>> type;
    private final String name;

    static AnnotationMemberValue extract(ByteBuffer buf, ConstantPool cp, Class<?> container, boolean skip) {
        Object typeOrException = AnnotationMetadata.extractType(buf, cp, container, skip);
        String constName = AnnotationMetadata.extractString(buf, cp, skip);
        if (skip) {
            return null;
        }
        if (typeOrException instanceof ExceptionProxy) {
            return new AnnotationExceptionProxyValue((ExceptionProxy)typeOrException);
        }
        Class type = (Class)typeOrException;
        return new AnnotationEnumValue(type, constName);
    }

    AnnotationEnumValue(Enum<?> value) {
        this.type = value.getDeclaringClass();
        this.name = value.name();
    }

    private AnnotationEnumValue(Class<? extends Enum<?>> type, String name) {
        this.type = type;
        this.name = name;
    }

    public Class<? extends Enum<?>> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<Class<?>> getTypes() {
        return Collections.singletonList(this.type);
    }

    @Override
    public List<String> getStrings() {
        return Collections.singletonList(this.name);
    }

    @Override
    public char getTag() {
        return 'e';
    }

    @Override
    public Object get(Class<?> memberType) {
        Enum<?> value = Enum.valueOf(this.type, this.name);
        return AnnotationMetadata.checkResult(value, memberType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationEnumValue enumValue = (AnnotationEnumValue)o;
        return Objects.equals(this.type, enumValue.type) && Objects.equals(this.name, enumValue.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }
}

